/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.validation.rule;

import com.liferay.dynamic.data.mapping.expression.CreateExpressionRequest;
import com.liferay.dynamic.data.mapping.expression.DDMExpression;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.object.validation.rule.ObjectValidationRuleEngine;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ObjectValidationRuleEngine.class})
public class DDMObjectValidationRuleEngineImpl
implements ObjectValidationRuleEngine {
    private static final Log _log = LogFactoryUtil.getLog(DDMObjectValidationRuleEngineImpl.class);
    @Reference
    private DDMExpressionFactory _ddmExpressionFactory;

    public boolean evaluate(Map<String, Object> inputObjects, String script) {
        try {
            return this._evaluate(inputObjects, script);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return false;
        }
    }

    public String getName() {
        return "ddm";
    }

    private boolean _evaluate(Map<String, Object> inputObjects, String script) throws Exception {
        DDMExpression<Boolean> ddmExpression = this._getDDMExpression(script);
        ddmExpression.setVariables(inputObjects);
        return (Boolean)ddmExpression.evaluate();
    }

    private DDMExpression<Boolean> _getDDMExpression(String script) throws Exception {
        return this._ddmExpressionFactory.createExpression(CreateExpressionRequest.Builder.newBuilder((String)script).build());
    }
}

