/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.field.business.type;

import com.liferay.object.exception.ObjectFieldSettingValueException;
import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.field.render.ObjectFieldRenderingContext;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.service.ObjectFieldSettingLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"object.field.business.type.key=LongText"}, service={LongTextObjectFieldBusinessType.class, ObjectFieldBusinessType.class})
public class LongTextObjectFieldBusinessType
implements ObjectFieldBusinessType {
    @Reference
    private ObjectFieldSettingLocalService _objectFieldSettingLocalService;

    public Set<String> getAllowedObjectFieldSettingsNames() {
        if (!GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LPS-146889"))) {
            return super.getAllowedObjectFieldSettingsNames();
        }
        return SetUtil.fromArray((Object[])new String[]{"maxLength"});
    }

    public String getDBType() {
        return "Clob";
    }

    public String getDDMFormFieldTypeName() {
        return "text";
    }

    public String getDescription(Locale locale) {
        return LanguageUtil.get((ResourceBundle)ResourceBundleUtil.getModuleAndPortalResourceBundle((Locale)locale, this.getClass()), (String)"add-text-that-up-to-65,000-characters");
    }

    public String getLabel(Locale locale) {
        return LanguageUtil.get((ResourceBundle)ResourceBundleUtil.getModuleAndPortalResourceBundle((Locale)locale, this.getClass()), (String)"long-text");
    }

    public String getName() {
        return "LongText";
    }

    public Map<String, Object> getProperties(ObjectField objectField, ObjectFieldRenderingContext objectFieldRenderingContext) {
        HashMap properties = HashMapBuilder.put((Object)"displayStyle", (Object)"multiline").build();
        if (!GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LPS-146889"))) {
            return properties;
        }
        List objectFieldSettings = this._objectFieldSettingLocalService.getObjectFieldSettings(objectField.getObjectFieldId());
        ListUtil.isNotEmptyForEach((List)objectFieldSettings, objectFieldSetting -> properties.put(objectFieldSetting.getName(), objectFieldSetting.getValue()));
        return properties;
    }

    public Set<String> getRequiredObjectFieldSettingsNames() {
        if (!GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LPS-146889"))) {
            return super.getRequiredObjectFieldSettingsNames();
        }
        return SetUtil.fromArray((Object[])new String[]{"showCounter"});
    }

    public void validateObjectFieldSettings(String objectFieldName, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        super.validateObjectFieldSettings(objectFieldName, objectFieldSettings);
        if (!GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LPS-146889"))) {
            return;
        }
        for (ObjectFieldSetting objectFieldSetting : objectFieldSettings) {
            if (Objects.equals(objectFieldSetting.getName(), "maxLength") && Validator.isNotNull((String)objectFieldSetting.getValue())) {
                int maxLength = GetterUtil.getInteger((String)objectFieldSetting.getValue());
                if (maxLength >= 1 && maxLength <= 65000) continue;
                throw new ObjectFieldSettingValueException.InvalidValue(objectFieldName, "maxLength", objectFieldSetting.getValue());
            }
            if (!Objects.equals(objectFieldSetting.getName(), "showCounter") || Objects.equals(objectFieldSetting.getValue(), "false") || Objects.equals(objectFieldSetting.getValue(), "true")) continue;
            throw new ObjectFieldSettingValueException.InvalidValue(objectFieldName, "showCounter", objectFieldSetting.getValue());
        }
    }
}

