/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.object.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.object.model.ObjectViewColumn;
import com.liferay.object.model.ObjectViewColumnModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the ObjectViewColumn service. Represents a row in the &quot;ObjectViewColumn&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>ObjectViewColumnModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectViewColumnImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectViewColumnImpl
 * @generated
 */
@JSON(strict = true)
public class ObjectViewColumnModelImpl
	extends BaseModelImpl<ObjectViewColumn> implements ObjectViewColumnModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object view column model instance should use the <code>ObjectViewColumn</code> interface instead.
	 */
	public static final String TABLE_NAME = "ObjectViewColumn";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"objectViewColumnId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"objectViewId", Types.BIGINT}, {"label", Types.VARCHAR},
		{"objectFieldName", Types.VARCHAR}, {"priority", Types.INTEGER}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("objectViewColumnId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("objectViewId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("label", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("objectFieldName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("priority", Types.INTEGER);
	}

	public static final String TABLE_SQL_CREATE =
		"create table ObjectViewColumn (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,objectViewColumnId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,objectViewId LONG,label STRING null,objectFieldName VARCHAR(75) null,priority INTEGER)";

	public static final String TABLE_SQL_DROP = "drop table ObjectViewColumn";

	public static final String ORDER_BY_JPQL =
		" ORDER BY objectViewColumn.objectViewColumnId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY ObjectViewColumn.objectViewColumnId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTFIELDNAME_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTVIEWID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTVIEWCOLUMNID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public ObjectViewColumnModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _objectViewColumnId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setObjectViewColumnId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _objectViewColumnId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return ObjectViewColumn.class;
	}

	@Override
	public String getModelClassName() {
		return ObjectViewColumn.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<ObjectViewColumn, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<ObjectViewColumn, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectViewColumn, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((ObjectViewColumn)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<ObjectViewColumn, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<ObjectViewColumn, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(ObjectViewColumn)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<ObjectViewColumn, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<ObjectViewColumn, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, ObjectViewColumn>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			ObjectViewColumn.class.getClassLoader(), ObjectViewColumn.class,
			ModelWrapper.class);

		try {
			Constructor<ObjectViewColumn> constructor =
				(Constructor<ObjectViewColumn>)proxyClass.getConstructor(
					InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map<String, Function<ObjectViewColumn, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<ObjectViewColumn, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<ObjectViewColumn, Object>>
			attributeGetterFunctions =
				new LinkedHashMap<String, Function<ObjectViewColumn, Object>>();
		Map<String, BiConsumer<ObjectViewColumn, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<ObjectViewColumn, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", ObjectViewColumn::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<ObjectViewColumn, Long>)
				ObjectViewColumn::setMvccVersion);
		attributeGetterFunctions.put("uuid", ObjectViewColumn::getUuid);
		attributeSetterBiConsumers.put(
			"uuid",
			(BiConsumer<ObjectViewColumn, String>)ObjectViewColumn::setUuid);
		attributeGetterFunctions.put(
			"objectViewColumnId", ObjectViewColumn::getObjectViewColumnId);
		attributeSetterBiConsumers.put(
			"objectViewColumnId",
			(BiConsumer<ObjectViewColumn, Long>)
				ObjectViewColumn::setObjectViewColumnId);
		attributeGetterFunctions.put(
			"companyId", ObjectViewColumn::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<ObjectViewColumn, Long>)ObjectViewColumn::setCompanyId);
		attributeGetterFunctions.put("userId", ObjectViewColumn::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<ObjectViewColumn, Long>)ObjectViewColumn::setUserId);
		attributeGetterFunctions.put("userName", ObjectViewColumn::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<ObjectViewColumn, String>)
				ObjectViewColumn::setUserName);
		attributeGetterFunctions.put(
			"createDate", ObjectViewColumn::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<ObjectViewColumn, Date>)
				ObjectViewColumn::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", ObjectViewColumn::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<ObjectViewColumn, Date>)
				ObjectViewColumn::setModifiedDate);
		attributeGetterFunctions.put(
			"objectViewId", ObjectViewColumn::getObjectViewId);
		attributeSetterBiConsumers.put(
			"objectViewId",
			(BiConsumer<ObjectViewColumn, Long>)
				ObjectViewColumn::setObjectViewId);
		attributeGetterFunctions.put("label", ObjectViewColumn::getLabel);
		attributeSetterBiConsumers.put(
			"label",
			(BiConsumer<ObjectViewColumn, String>)ObjectViewColumn::setLabel);
		attributeGetterFunctions.put(
			"objectFieldName", ObjectViewColumn::getObjectFieldName);
		attributeSetterBiConsumers.put(
			"objectFieldName",
			(BiConsumer<ObjectViewColumn, String>)
				ObjectViewColumn::setObjectFieldName);
		attributeGetterFunctions.put("priority", ObjectViewColumn::getPriority);
		attributeSetterBiConsumers.put(
			"priority",
			(BiConsumer<ObjectViewColumn, Integer>)
				ObjectViewColumn::setPriority);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public long getObjectViewColumnId() {
		return _objectViewColumnId;
	}

	@Override
	public void setObjectViewColumnId(long objectViewColumnId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectViewColumnId = objectViewColumnId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getObjectViewId() {
		return _objectViewId;
	}

	@Override
	public void setObjectViewId(long objectViewId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectViewId = objectViewId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalObjectViewId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("objectViewId"));
	}

	@JSON
	@Override
	public String getLabel() {
		if (_label == null) {
			return "";
		}
		else {
			return _label;
		}
	}

	@Override
	public String getLabel(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getLabel(languageId);
	}

	@Override
	public String getLabel(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getLabel(languageId, useDefault);
	}

	@Override
	public String getLabel(String languageId) {
		return LocalizationUtil.getLocalization(getLabel(), languageId);
	}

	@Override
	public String getLabel(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getLabel(), languageId, useDefault);
	}

	@Override
	public String getLabelCurrentLanguageId() {
		return _labelCurrentLanguageId;
	}

	@JSON
	@Override
	public String getLabelCurrentValue() {
		Locale locale = getLocale(_labelCurrentLanguageId);

		return getLabel(locale);
	}

	@Override
	public Map<Locale, String> getLabelMap() {
		return LocalizationUtil.getLocalizationMap(getLabel());
	}

	@Override
	public void setLabel(String label) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_label = label;
	}

	@Override
	public void setLabel(String label, Locale locale) {
		setLabel(label, locale, LocaleUtil.getDefault());
	}

	@Override
	public void setLabel(String label, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(label)) {
			setLabel(
				LocalizationUtil.updateLocalization(
					getLabel(), "Label", label, languageId, defaultLanguageId));
		}
		else {
			setLabel(
				LocalizationUtil.removeLocalization(
					getLabel(), "Label", languageId));
		}
	}

	@Override
	public void setLabelCurrentLanguageId(String languageId) {
		_labelCurrentLanguageId = languageId;
	}

	@Override
	public void setLabelMap(Map<Locale, String> labelMap) {
		setLabelMap(labelMap, LocaleUtil.getDefault());
	}

	@Override
	public void setLabelMap(
		Map<Locale, String> labelMap, Locale defaultLocale) {

		if (labelMap == null) {
			return;
		}

		setLabel(
			LocalizationUtil.updateLocalization(
				labelMap, getLabel(), "Label",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getObjectFieldName() {
		if (_objectFieldName == null) {
			return "";
		}
		else {
			return _objectFieldName;
		}
	}

	@Override
	public void setObjectFieldName(String objectFieldName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectFieldName = objectFieldName;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalObjectFieldName() {
		return getColumnOriginalValue("objectFieldName");
	}

	@JSON
	@Override
	public int getPriority() {
		return _priority;
	}

	@Override
	public void setPriority(int priority) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_priority = priority;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(ObjectViewColumn.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), ObjectViewColumn.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> labelMap = getLabelMap();

		for (Map.Entry<Locale, String> entry : labelMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(
			new String[availableLanguageIds.size()]);
	}

	@Override
	public String getDefaultLanguageId() {
		String xml = getLabel();

		if (xml == null) {
			return "";
		}

		Locale defaultLocale = LocaleUtil.getDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException {
		Locale defaultLocale = LocaleUtil.fromLanguageId(
			getDefaultLanguageId());

		Locale[] availableLocales = LocaleUtil.fromLanguageIds(
			getAvailableLanguageIds());

		Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(
			ObjectViewColumn.class.getName(), getPrimaryKey(), defaultLocale,
			availableLocales);

		prepareLocalizedFieldsForImport(defaultImportLocale);
	}

	@Override
	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {

		Locale defaultLocale = LocaleUtil.getDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String label = getLabel(defaultLocale);

		if (Validator.isNull(label)) {
			setLabel(getLabel(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setLabel(getLabel(defaultLocale), defaultLocale, defaultLocale);
		}
	}

	@Override
	public ObjectViewColumn toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, ObjectViewColumn>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		ObjectViewColumnImpl objectViewColumnImpl = new ObjectViewColumnImpl();

		objectViewColumnImpl.setMvccVersion(getMvccVersion());
		objectViewColumnImpl.setUuid(getUuid());
		objectViewColumnImpl.setObjectViewColumnId(getObjectViewColumnId());
		objectViewColumnImpl.setCompanyId(getCompanyId());
		objectViewColumnImpl.setUserId(getUserId());
		objectViewColumnImpl.setUserName(getUserName());
		objectViewColumnImpl.setCreateDate(getCreateDate());
		objectViewColumnImpl.setModifiedDate(getModifiedDate());
		objectViewColumnImpl.setObjectViewId(getObjectViewId());
		objectViewColumnImpl.setLabel(getLabel());
		objectViewColumnImpl.setObjectFieldName(getObjectFieldName());
		objectViewColumnImpl.setPriority(getPriority());

		objectViewColumnImpl.resetOriginalValues();

		return objectViewColumnImpl;
	}

	@Override
	public ObjectViewColumn cloneWithOriginalValues() {
		ObjectViewColumnImpl objectViewColumnImpl = new ObjectViewColumnImpl();

		objectViewColumnImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		objectViewColumnImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		objectViewColumnImpl.setObjectViewColumnId(
			this.<Long>getColumnOriginalValue("objectViewColumnId"));
		objectViewColumnImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		objectViewColumnImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		objectViewColumnImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		objectViewColumnImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		objectViewColumnImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		objectViewColumnImpl.setObjectViewId(
			this.<Long>getColumnOriginalValue("objectViewId"));
		objectViewColumnImpl.setLabel(
			this.<String>getColumnOriginalValue("label"));
		objectViewColumnImpl.setObjectFieldName(
			this.<String>getColumnOriginalValue("objectFieldName"));
		objectViewColumnImpl.setPriority(
			this.<Integer>getColumnOriginalValue("priority"));

		return objectViewColumnImpl;
	}

	@Override
	public int compareTo(ObjectViewColumn objectViewColumn) {
		long primaryKey = objectViewColumn.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof ObjectViewColumn)) {
			return false;
		}

		ObjectViewColumn objectViewColumn = (ObjectViewColumn)object;

		long primaryKey = objectViewColumn.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<ObjectViewColumn> toCacheModel() {
		ObjectViewColumnCacheModel objectViewColumnCacheModel =
			new ObjectViewColumnCacheModel();

		objectViewColumnCacheModel.mvccVersion = getMvccVersion();

		objectViewColumnCacheModel.uuid = getUuid();

		String uuid = objectViewColumnCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			objectViewColumnCacheModel.uuid = null;
		}

		objectViewColumnCacheModel.objectViewColumnId = getObjectViewColumnId();

		objectViewColumnCacheModel.companyId = getCompanyId();

		objectViewColumnCacheModel.userId = getUserId();

		objectViewColumnCacheModel.userName = getUserName();

		String userName = objectViewColumnCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			objectViewColumnCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			objectViewColumnCacheModel.createDate = createDate.getTime();
		}
		else {
			objectViewColumnCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			objectViewColumnCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			objectViewColumnCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		objectViewColumnCacheModel.objectViewId = getObjectViewId();

		objectViewColumnCacheModel.label = getLabel();

		String label = objectViewColumnCacheModel.label;

		if ((label != null) && (label.length() == 0)) {
			objectViewColumnCacheModel.label = null;
		}

		objectViewColumnCacheModel.objectFieldName = getObjectFieldName();

		String objectFieldName = objectViewColumnCacheModel.objectFieldName;

		if ((objectFieldName != null) && (objectFieldName.length() == 0)) {
			objectViewColumnCacheModel.objectFieldName = null;
		}

		objectViewColumnCacheModel.priority = getPriority();

		return objectViewColumnCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<ObjectViewColumn, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<ObjectViewColumn, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectViewColumn, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(ObjectViewColumn)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<ObjectViewColumn, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<ObjectViewColumn, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectViewColumn, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((ObjectViewColumn)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, ObjectViewColumn>
			_escapedModelProxyProviderFunction = _getProxyProviderFunction();

	}

	private long _mvccVersion;
	private String _uuid;
	private long _objectViewColumnId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _objectViewId;
	private String _label;
	private String _labelCurrentLanguageId;
	private String _objectFieldName;
	private int _priority;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<ObjectViewColumn, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((ObjectViewColumn)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put("objectViewColumnId", _objectViewColumnId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("objectViewId", _objectViewId);
		_columnOriginalValues.put("label", _label);
		_columnOriginalValues.put("objectFieldName", _objectFieldName);
		_columnOriginalValues.put("priority", _priority);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("objectViewColumnId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("userName", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("objectViewId", 256L);

		columnBitmasks.put("label", 512L);

		columnBitmasks.put("objectFieldName", 1024L);

		columnBitmasks.put("priority", 2048L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private ObjectViewColumn _escapedModel;

}