/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.exception.DuplicateObjectRelationshipException;
import com.liferay.object.exception.ObjectRelationshipNameException;
import com.liferay.object.exception.ObjectRelationshipReverseException;
import com.liferay.object.exception.ObjectRelationshipTypeException;
import com.liferay.object.internal.petra.sql.dsl.DynamicObjectDefinitionTable;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.base.ObjectRelationshipLocalServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.object.service.persistence.ObjectFieldPersistence;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"model.class.name=com.liferay.object.model.ObjectRelationship"}, service={AopService.class})
public class ObjectRelationshipLocalServiceImpl
extends ObjectRelationshipLocalServiceBaseImpl {
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectFieldPersistence _objectFieldPersistence;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public ObjectRelationship addObjectRelationship(long userId, long objectDefinitionId1, long objectDefinitionId2, String deletionType, Map<Locale, String> labelMap, String name, String type) throws PortalException {
        return this._addObjectRelationship(userId, objectDefinitionId1, objectDefinitionId2, deletionType, labelMap, name, false, type);
    }

    public void addObjectRelationshipMappingTableValues(long userId, long objectRelationshipId, long primaryKey1, long primaryKey2, ServiceContext serviceContext) throws PortalException {
        ObjectRelationship objectRelationship = this.objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        ObjectDefinition objectDefinition2 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId2());
        if (Objects.equals(objectRelationship.getType(), "manyToMany")) {
            ObjectDefinition objectDefinition1 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId1());
            this.runSQL(StringBundler.concat((Object[])new Object[]{"insert into ", objectRelationship.getDBTableName(), " (", objectDefinition1.getPKObjectFieldDBColumnName(), " , ", objectDefinition2.getPKObjectFieldDBColumnName(), ") values (", primaryKey1, ", ", primaryKey2, ")"}));
            return;
        }
        ObjectField objectField2 = this._objectFieldLocalService.getObjectField(objectRelationship.getObjectFieldId2());
        if (objectDefinition2.isSystem()) {
            this._objectEntryLocalService.insertIntoOrUpdateExtensionTable(objectRelationship.getObjectDefinitionId2(), primaryKey2, (Map)HashMapBuilder.put((Object)objectField2.getName(), (Object)primaryKey1).build());
        } else {
            this._objectEntryLocalService.updateObjectEntry(userId, primaryKey2, (Map)HashMapBuilder.put((Object)objectField2.getName(), (Object)primaryKey1).build(), serviceContext);
        }
    }

    @Override
    public ObjectRelationship deleteObjectRelationship(long objectRelationshipId) throws PortalException {
        ObjectRelationship objectRelationship = this.objectRelationshipPersistence.findByPrimaryKey(objectRelationshipId);
        return this.deleteObjectRelationship(objectRelationship);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public ObjectRelationship deleteObjectRelationship(ObjectRelationship objectRelationship) throws PortalException {
        if (objectRelationship.isReverse()) {
            throw new ObjectRelationshipReverseException("Reverse object relationships cannot be deleted");
        }
        if (Objects.equals((objectRelationship = (ObjectRelationship)this.objectRelationshipPersistence.remove((BaseModel)objectRelationship)).getType(), "oneToOne") || Objects.equals(objectRelationship.getType(), "oneToMany")) {
            this._objectFieldLocalService.deleteRelationshipTypeObjectField(objectRelationship.getObjectFieldId2());
        } else if (Objects.equals(objectRelationship.getType(), "manyToMany")) {
            this.runSQL("drop table " + objectRelationship.getDBTableName());
            ObjectRelationship reverseObjectRelationship = this.fetchReverseObjectRelationship(objectRelationship, true);
            this.objectRelationshipPersistence.remove(reverseObjectRelationship.getObjectRelationshipId());
        }
        return objectRelationship;
    }

    public void deleteObjectRelationshipMappingTableValues(long objectRelationshipId, long primaryKey1) throws PortalException {
        ObjectRelationship objectRelationship = this.objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        if (Objects.equals(objectRelationship.getType(), "manyToMany")) {
            ObjectDefinition objectDefinition1 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId1());
            this.runSQL(StringBundler.concat((Object[])new Object[]{"delete from ", objectRelationship.getDBTableName(), " where ", objectDefinition1.getPKObjectFieldDBColumnName(), " = ", primaryKey1}));
        }
    }

    public void deleteObjectRelationshipMappingTableValues(long objectRelationshipId, long primaryKey1, long primaryKey2) throws PortalException {
        ObjectRelationship objectRelationship = this.objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        if (Objects.equals(objectRelationship.getType(), "manyToMany")) {
            ObjectDefinition objectDefinition1 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId1());
            ObjectDefinition objectDefinition2 = this._objectDefinitionPersistence.findByPrimaryKey(objectRelationship.getObjectDefinitionId2());
            this.runSQL(StringBundler.concat((Object[])new Object[]{"delete from ", objectRelationship.getDBTableName(), " where ", objectDefinition1.getPKObjectFieldDBColumnName(), " = ", primaryKey1, " and ", objectDefinition2.getPKObjectFieldDBColumnName(), " = ", primaryKey2}));
        }
    }

    public ObjectRelationship fetchObjectRelationshipByObjectFieldId2(long objectFieldId2) {
        return this.objectRelationshipPersistence.fetchByObjectFieldId2(objectFieldId2);
    }

    public ObjectRelationship fetchReverseObjectRelationship(ObjectRelationship objectRelationship, boolean reverse) {
        return this.objectRelationshipPersistence.fetchByODI1_ODI2_N_R_T(objectRelationship.getObjectDefinitionId2(), objectRelationship.getObjectDefinitionId1(), objectRelationship.getName(), reverse, objectRelationship.getType());
    }

    public List<ObjectRelationship> getObjectRelationships(long objectDefinitionId1) {
        return this.objectRelationshipPersistence.findByObjectDefinitionId1(objectDefinitionId1);
    }

    public List<ObjectRelationship> getObjectRelationships(long objectDefinitionId1, int start, int end) {
        return this.objectRelationshipPersistence.findByObjectDefinitionId1(objectDefinitionId1, start, end);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectRelationship updateObjectRelationship(long objectRelationshipId, String deletionType, Map<Locale, String> labelMap) throws PortalException {
        ObjectRelationship objectRelationship;
        if (Validator.isNull((String)deletionType)) {
            deletionType = "prevent";
        }
        if ((objectRelationship = this.objectRelationshipPersistence.findByPrimaryKey(objectRelationshipId)).isReverse()) {
            throw new ObjectRelationshipReverseException("Reverse object relationships cannot be updated");
        }
        objectRelationship.setDeletionType(deletionType);
        objectRelationship.setLabelMap(labelMap);
        return (ObjectRelationship)this.objectRelationshipPersistence.update((BaseModel)objectRelationship);
    }

    private ObjectField _addObjectField(User user, String name, long objectDefinitionId1, long objectDefinitionId2, String type) throws PortalException {
        ObjectField objectField = this._objectFieldPersistence.create(this.counterLocalService.increment());
        objectField.setCompanyId(user.getCompanyId());
        objectField.setUserId(user.getUserId());
        objectField.setUserName(user.getFullName());
        objectField.setListTypeDefinitionId(0L);
        objectField.setObjectDefinitionId(objectDefinitionId2);
        objectField.setBusinessType("Relationship");
        ObjectDefinition objectDefinition1 = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId1);
        String dbColumnName = StringBundler.concat((String[])new String[]{"r_", name, "_", objectDefinition1.getPKObjectFieldName()});
        objectField.setDBColumnName(dbColumnName);
        ObjectDefinition objectDefinition2 = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId2);
        String dbTableName = objectDefinition2.getDBTableName();
        if (objectDefinition2.isApproved()) {
            dbTableName = objectDefinition2.getExtensionDBTableName();
        }
        objectField.setDBTableName(dbTableName);
        objectField.setDBType("Long");
        objectField.setIndexed(true);
        objectField.setIndexedAsKeyword(false);
        objectField.setIndexedLanguageId(null);
        objectField.setLabelMap(objectDefinition1.getLabelMap(), LocaleUtil.getSiteDefault());
        objectField.setName(dbColumnName);
        objectField.setRelationshipType(type);
        objectField.setRequired(false);
        objectField = this._objectFieldLocalService.updateObjectField(objectField);
        if (objectDefinition2.isApproved()) {
            this.runSQL(DynamicObjectDefinitionTable.getAlterTableAddColumnSQL(dbTableName, objectField.getDBColumnName(), "Long"));
            if (this._objectDefinitionLocalService != null) {
                this._objectDefinitionLocalService.deployObjectDefinition(objectDefinition2);
            }
        }
        return objectField;
    }

    private ObjectRelationship _addObjectRelationship(long userId, long objectDefinitionId1, long objectDefinitionId2, String deletionType, Map<Locale, String> labelMap, String name, boolean reverse, String type) throws PortalException {
        this._validate(objectDefinitionId1, objectDefinitionId2, name, type);
        ObjectRelationship objectRelationship = this.objectRelationshipPersistence.create(this.counterLocalService.increment());
        User user = this._userLocalService.getUser(userId);
        objectRelationship.setCompanyId(user.getCompanyId());
        objectRelationship.setUserId(user.getUserId());
        objectRelationship.setUserName(user.getFullName());
        objectRelationship.setObjectDefinitionId1(objectDefinitionId1);
        objectRelationship.setObjectDefinitionId2(objectDefinitionId2);
        objectRelationship.setDeletionType(GetterUtil.getString((String)deletionType, (String)"prevent"));
        objectRelationship.setLabelMap(labelMap);
        objectRelationship.setName(name);
        objectRelationship.setReverse(reverse);
        objectRelationship.setType(type);
        if (Objects.equals(type, "oneToOne") || Objects.equals(type, "oneToMany")) {
            ObjectField objectField = this._addObjectField(user, name, objectDefinitionId1, objectDefinitionId2, type);
            objectRelationship.setObjectFieldId2(objectField.getObjectFieldId());
        } else if (Objects.equals(type, "manyToMany") && !reverse) {
            ObjectDefinition objectDefinition1 = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId1);
            ObjectDefinition objectDefinition2 = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId2);
            objectRelationship.setDBTableName(StringBundler.concat((Object[])new Object[]{"R_", user.getCompanyId(), objectDefinition1.getShortName(), "_", objectDefinition2.getShortName(), "_", name}));
            this.runSQL(StringBundler.concat((String[])new String[]{"create table ", objectRelationship.getDBTableName(), " (", objectDefinition1.getPKObjectFieldDBColumnName(), " LONG not null,", objectDefinition2.getPKObjectFieldDBColumnName(), " LONG not null, primary key (", objectDefinition1.getPKObjectFieldDBColumnName(), ", ", objectDefinition2.getPKObjectFieldDBColumnName(), "))"}));
            ObjectRelationship reverseObjectRelationship = this._addObjectRelationship(userId, objectDefinitionId2, objectDefinitionId1, deletionType, labelMap, name, true, type);
            reverseObjectRelationship.setDBTableName(objectRelationship.getDBTableName());
            this.objectRelationshipLocalService.updateObjectRelationship(reverseObjectRelationship);
        }
        return this.objectRelationshipLocalService.updateObjectRelationship(objectRelationship);
    }

    private void _validate(long objectDefinitionId1, long objectDefinitionId2, String name, String type) throws PortalException {
        int count;
        char[] nameCharArray;
        if (Validator.isNull((String)name)) {
            throw new ObjectRelationshipNameException("Name is null");
        }
        for (char c : nameCharArray = name.toCharArray()) {
            if (Validator.isChar((char)c) || Validator.isDigit((char)c)) continue;
            throw new ObjectRelationshipNameException("Name must only contain letters and digits");
        }
        if (!Character.isLowerCase(nameCharArray[0])) {
            throw new ObjectRelationshipNameException("The first character of a name must be a lower case letter");
        }
        if (nameCharArray.length > 41) {
            throw new ObjectRelationshipNameException("Names must be less than 41 characters");
        }
        ObjectRelationship objectRelationship = this.objectRelationshipPersistence.fetchByODI1_N(objectDefinitionId1, name);
        if (objectRelationship != null) {
            throw new DuplicateObjectRelationshipException("Duplicate name " + name);
        }
        if (!(Objects.equals(type, "manyToMany") || Objects.equals(type, "oneToMany") || Objects.equals(type, "oneToOne"))) {
            throw new ObjectRelationshipTypeException("Invalid type " + type);
        }
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId1);
        if (objectDefinition.isSystem() && !Objects.equals(type, "oneToMany")) {
            throw new ObjectRelationshipTypeException("Invalid type for system object definition " + objectDefinitionId1);
        }
        if ((Objects.equals(type, "manyToMany") || Objects.equals(type, "oneToOne")) && (count = this.objectRelationshipPersistence.countByODI1_ODI2_N_T(objectDefinitionId2, objectDefinitionId1, name, type)) > 0) {
            throw new ObjectRelationshipTypeException("Inverse type already exists");
        }
    }
}

