/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.service.base.ObjectFieldSettingServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectFieldPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=object", "json.web.service.context.path=ObjectFieldSetting"}, service={AopService.class})
public class ObjectFieldSettingServiceImpl
extends ObjectFieldSettingServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.object.model.ObjectDefinition)")
    private ModelResourcePermission<ObjectDefinition> _objectDefinitionModelResourcePermission;
    @Reference
    private ObjectFieldPersistence _objectFieldPersistence;

    public ObjectFieldSetting addObjectFieldSetting(long objectFieldId, String name, boolean required, String value) throws PortalException {
        ObjectField objectField = this._objectFieldPersistence.fetchByPrimaryKey(objectFieldId);
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectField.getObjectDefinitionId(), "UPDATE");
        return this.objectFieldSettingLocalService.addObjectFieldSetting(this.getUserId(), objectFieldId, name, required, value);
    }

    public ObjectFieldSetting deleteObjectFieldSetting(long objectFieldSettingId) throws PortalException {
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), this._getObjectDefinitionId(objectFieldSettingId), "UPDATE");
        return this.objectFieldSettingLocalService.deleteObjectFieldSetting(objectFieldSettingId);
    }

    public ObjectFieldSetting getObjectFieldSetting(long objectFieldSettingId) throws PortalException {
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), this._getObjectDefinitionId(objectFieldSettingId), "VIEW");
        return this.objectFieldSettingLocalService.getObjectFieldSetting(objectFieldSettingId);
    }

    public ObjectFieldSetting updateObjectFieldSetting(long objectFieldSettingId, String value) throws PortalException {
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), this._getObjectDefinitionId(objectFieldSettingId), "UPDATE");
        return this.objectFieldSettingLocalService.updateObjectFieldSetting(objectFieldSettingId, value);
    }

    private long _getObjectDefinitionId(long objectFieldSettingId) throws PortalException {
        ObjectFieldSetting objectFieldSetting = this.objectFieldSettingPersistence.findByPrimaryKey(objectFieldSettingId);
        ObjectField objectField = this._objectFieldPersistence.fetchByPrimaryKey(objectFieldSetting.getObjectFieldId());
        return objectField.getObjectDefinitionId();
    }
}

