/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.exception.ObjectFieldSettingValueException;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.service.base.ObjectFieldSettingLocalServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectFieldPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectFieldSetting"}, service={AopService.class})
public class ObjectFieldSettingLocalServiceImpl
extends ObjectFieldSettingLocalServiceBaseImpl {
    @Reference
    private ObjectFieldPersistence _objectFieldPersistence;
    @Reference
    private UserLocalService _userLocalService;

    public ObjectFieldSetting addObjectFieldSetting(long userId, long objectFieldId, String name, boolean required, String value) throws PortalException {
        this._objectFieldPersistence.findByPrimaryKey(objectFieldId);
        this._validate(required, value);
        ObjectFieldSetting objectFieldSetting = this.objectFieldSettingPersistence.create(this.counterLocalService.increment());
        User user = this._userLocalService.getUser(userId);
        objectFieldSetting.setCompanyId(user.getCompanyId());
        objectFieldSetting.setUserId(user.getUserId());
        objectFieldSetting.setUserName(user.getFullName());
        objectFieldSetting.setObjectFieldId(objectFieldId);
        objectFieldSetting.setName(name);
        objectFieldSetting.setRequired(required);
        objectFieldSetting.setValue(value);
        return (ObjectFieldSetting)this.objectFieldSettingPersistence.update((BaseModel)objectFieldSetting);
    }

    public ObjectFieldSetting fetchObjectFieldSetting(long objectFieldId, String name) {
        return this.objectFieldSettingPersistence.fetchByOFI_N(objectFieldId, name);
    }

    public List<ObjectFieldSetting> getObjectFieldSettings(long objectFieldId) {
        return this.objectFieldSettingPersistence.findByObjectFieldId(objectFieldId);
    }

    public ObjectFieldSetting updateObjectFieldSetting(long objectFieldSettingId, String value) throws PortalException {
        ObjectFieldSetting objectFieldSetting = this.objectFieldSettingPersistence.fetchByPrimaryKey(objectFieldSettingId);
        this._validate(objectFieldSetting.isRequired(), value);
        objectFieldSetting.setValue(value);
        return (ObjectFieldSetting)this.objectFieldSettingPersistence.update((BaseModel)objectFieldSetting);
    }

    private void _validate(boolean required, String value) throws PortalException {
        if (required && Validator.isNull((String)value)) {
            throw new ObjectFieldSettingValueException();
        }
    }
}

