/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.field.business.type;

import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.field.render.ObjectFieldRenderingContext;
import com.liferay.object.model.ObjectField;
import com.liferay.object.service.ObjectFieldSettingLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"object.field.business.type.key=Attachment"}, service={ObjectFieldBusinessType.class})
public class AttachmentObjectFieldBusinessType
implements ObjectFieldBusinessType {
    private static final Log _log = LogFactoryUtil.getLog(AttachmentObjectFieldBusinessType.class);
    @Reference
    private ObjectFieldSettingLocalService _objectFieldSettingLocalService;
    @Reference
    private PortletFileRepository _portletFileRepository;

    public String getDBType() {
        return "Long";
    }

    public String getDDMFormFieldTypeName() {
        return "attachment";
    }

    public String getDescription(Locale locale) {
        return LanguageUtil.get((ResourceBundle)ResourceBundleUtil.getModuleAndPortalResourceBundle((Locale)locale, this.getClass()), (String)"upload-files-or-select-from-documents-and-media");
    }

    public String getLabel(Locale locale) {
        return LanguageUtil.get((ResourceBundle)ResourceBundleUtil.getModuleAndPortalResourceBundle((Locale)locale, this.getClass()), (String)"attachment");
    }

    public String getName() {
        return "Attachment";
    }

    public Map<String, Object> getProperties(ObjectField objectField, ObjectFieldRenderingContext objectFieldRenderingContext) {
        HashMap properties = HashMapBuilder.put((Object)"folderId", () -> {
            if (Validator.isNull((String)objectFieldRenderingContext.getPortletId())) {
                return null;
            }
            Folder folder = this._getFolder(objectFieldRenderingContext);
            if (folder == null) {
                return null;
            }
            return folder.getFolderId();
        }).put((Object)"objectEntryId", (Object)objectFieldRenderingContext.getObjectEntryId()).put((Object)"objectFieldId", (Object)objectField.getObjectFieldId()).put((Object)"portletId", (Object)objectFieldRenderingContext.getPortletId()).build();
        List objectFieldSettings = this._objectFieldSettingLocalService.getObjectFieldSettings(objectField.getObjectFieldId());
        ListUtil.isNotEmptyForEach((List)objectFieldSettings, objectFieldSetting -> properties.put(objectFieldSetting.getName(), objectFieldSetting.getValue()));
        return properties;
    }

    private Folder _addFolder(long userId, long repositoryId, HttpServletRequest httpServletRequest) {
        try {
            return this._portletFileRepository.addPortletFolder(userId, repositoryId, 0L, String.valueOf(userId), ServiceContextFactory.getInstance((HttpServletRequest)httpServletRequest));
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return null;
        }
    }

    private Folder _getFolder(ObjectFieldRenderingContext objectFieldRenderingContext) {
        Repository repository = this._getRepository(objectFieldRenderingContext.getGroupId(), objectFieldRenderingContext.getPortletId(), objectFieldRenderingContext.getHttpServletRequest());
        if (repository == null) {
            return null;
        }
        try {
            return this._portletFileRepository.getPortletFolder(repository.getRepositoryId(), 0L, String.valueOf(objectFieldRenderingContext.getUserId()));
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return this._addFolder(objectFieldRenderingContext.getUserId(), repository.getRepositoryId(), objectFieldRenderingContext.getHttpServletRequest());
        }
    }

    private Repository _getRepository(long groupId, String portletId, HttpServletRequest httpServletRequest) {
        Repository repository = this._portletFileRepository.fetchPortletRepository(groupId, portletId);
        if (repository != null) {
            return repository;
        }
        try {
            ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)httpServletRequest);
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            return this._portletFileRepository.addPortletRepository(groupId, portletId, serviceContext);
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return null;
        }
    }
}

