/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.service.impl;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.service.base.ObjectFieldSettingServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectFieldPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.ActionKeys;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Carolina Barbosa
 */
@Component(
	property = {
		"json.web.service.context.name=object",
		"json.web.service.context.path=ObjectFieldSetting"
	},
	service = AopService.class
)
public class ObjectFieldSettingServiceImpl
	extends ObjectFieldSettingServiceBaseImpl {

	@Override
	public ObjectFieldSetting addObjectFieldSetting(
			long objectFieldId, String name, boolean required, String value)
		throws PortalException {

		ObjectField objectField = _objectFieldPersistence.fetchByPrimaryKey(
			objectFieldId);

		_objectDefinitionModelResourcePermission.check(
			getPermissionChecker(), objectField.getObjectDefinitionId(),
			ActionKeys.UPDATE);

		return objectFieldSettingLocalService.addObjectFieldSetting(
			getUserId(), objectFieldId, name, required, value);
	}

	@Override
	public ObjectFieldSetting deleteObjectFieldSetting(
			long objectFieldSettingId)
		throws PortalException {

		_objectDefinitionModelResourcePermission.check(
			getPermissionChecker(),
			_getObjectDefinitionId(objectFieldSettingId), ActionKeys.UPDATE);

		return objectFieldSettingLocalService.deleteObjectFieldSetting(
			objectFieldSettingId);
	}

	@Override
	public ObjectFieldSetting getObjectFieldSetting(long objectFieldSettingId)
		throws PortalException {

		_objectDefinitionModelResourcePermission.check(
			getPermissionChecker(),
			_getObjectDefinitionId(objectFieldSettingId), ActionKeys.VIEW);

		return objectFieldSettingLocalService.getObjectFieldSetting(
			objectFieldSettingId);
	}

	@Override
	public ObjectFieldSetting updateObjectFieldSetting(
			long objectFieldSettingId, String value)
		throws PortalException {

		_objectDefinitionModelResourcePermission.check(
			getPermissionChecker(),
			_getObjectDefinitionId(objectFieldSettingId), ActionKeys.UPDATE);

		return objectFieldSettingLocalService.updateObjectFieldSetting(
			objectFieldSettingId, value);
	}

	private long _getObjectDefinitionId(long objectFieldSettingId)
		throws PortalException {

		ObjectFieldSetting objectFieldSetting =
			objectFieldSettingPersistence.findByPrimaryKey(
				objectFieldSettingId);

		ObjectField objectField = _objectFieldPersistence.fetchByPrimaryKey(
			objectFieldSetting.getObjectFieldId());

		return objectField.getObjectDefinitionId();
	}

	@Reference(
		target = "(model.class.name=com.liferay.object.model.ObjectDefinition)"
	)
	private ModelResourcePermission<ObjectDefinition>
		_objectDefinitionModelResourcePermission;

	@Reference
	private ObjectFieldPersistence _objectFieldPersistence;

}