/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.upgrade;

import com.liferay.object.internal.upgrade.v1_1_0.ObjectDefinitionUpgradeProcess;
import com.liferay.object.internal.upgrade.v1_2_0.ObjectViewUpgradeProcess;
import com.liferay.object.internal.upgrade.v2_0_0.ObjectFieldUpgradeProcess;
import com.liferay.object.internal.upgrade.v2_1_0.ObjectFieldBusinessTypeUpgradeProcess;
import com.liferay.object.internal.upgrade.v2_2_0.ObjectValidationRuleUpgradeProcess;
import com.liferay.object.internal.upgrade.v2_3_0.ObjectFieldSettingUpgradeProcess;
import com.liferay.object.internal.upgrade.v2_4_0.ObjectViewSortColumnUpgradeProcess;
import com.liferay.portal.upgrade.registry.UpgradeStepRegistrator;

import org.osgi.service.component.annotations.Component;

/**
 * @author Marco Leo
 */
@Component(immediate = true, service = UpgradeStepRegistrator.class)
public class ObjectServiceUpgrade implements UpgradeStepRegistrator {

	@Override
	public void register(Registry registry) {
		registry.register(
			"1.0.0", "1.1.0", new ObjectDefinitionUpgradeProcess());

		registry.register("1.1.0", "1.2.0", new ObjectViewUpgradeProcess());

		registry.register("1.2.0", "2.0.0", new ObjectFieldUpgradeProcess());

		registry.register(
			"2.0.0", "2.1.0", new ObjectFieldBusinessTypeUpgradeProcess());

		registry.register(
			"2.1.0", "2.2.0", new ObjectValidationRuleUpgradeProcess());

		registry.register(
			"2.2.0", "2.3.0", new ObjectFieldSettingUpgradeProcess());

		registry.register(
			"2.3.0", "2.4.0", new ObjectViewSortColumnUpgradeProcess());
	}

}