/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.scope;

import com.liferay.application.list.constants.PanelCategoryKeys;
import com.liferay.object.constants.ObjectDefinitionConstants;
import com.liferay.object.scope.ObjectScopeProvider;
import com.liferay.portal.kernel.language.LanguageUtil;

import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.osgi.service.component.annotations.Component;

/**
 * @author Marco Leo
 */
@Component(
	immediate = true,
	property = "object.scope.provider.key=" + ObjectDefinitionConstants.SCOPE_COMPANY,
	service = ObjectScopeProvider.class
)
public class CompanyInstanceObjectScopeProviderImpl
	implements ObjectScopeProvider {

	@Override
	public long getGroupId(HttpServletRequest httpServletRequest) {
		return 0;
	}

	@Override
	public String getKey() {
		return ObjectDefinitionConstants.SCOPE_COMPANY;
	}

	@Override
	public String getLabel(Locale locale) {
		return LanguageUtil.get(locale, "company");
	}

	@Override
	public String[] getRootPanelCategoryKeys() {
		return new String[] {
			PanelCategoryKeys.CONTROL_PANEL, PanelCategoryKeys.COMMERCE,
			PanelCategoryKeys.APPLICATIONS_MENU_APPLICATIONS
		};
	}

	@Override
	public boolean isGroupAware() {
		return false;
	}

	@Override
	public boolean isValidGroupId(long groupId) {
		if (groupId == 0) {
			return true;
		}

		return false;
	}

}