/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetLinkLocalService;
import com.liferay.list.type.service.ListTypeEntryLocalService;
import com.liferay.object.exception.NoSuchObjectFieldException;
import com.liferay.object.exception.ObjectDefinitionScopeException;
import com.liferay.object.exception.ObjectEntryValuesException;
import com.liferay.object.internal.petra.sql.dsl.DynamicObjectDefinitionTable;
import com.liferay.object.internal.petra.sql.dsl.DynamicObjectRelationshipMappingTable;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryTable;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.related.models.ObjectRelatedModelsProvider;
import com.liferay.object.related.models.ObjectRelatedModelsProviderRegistry;
import com.liferay.object.scope.ObjectScopeProvider;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.base.ObjectEntryLocalServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.object.service.persistence.ObjectFieldPersistence;
import com.liferay.object.service.persistence.ObjectRelationshipPersistence;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.ast.ASTNodeListener;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.spi.ast.DefaultASTNodeListener;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.dao.jdbc.postgresql.PostgreSQLJDBCUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnection;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.InlineSQLHelper;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.searcher.Searcher;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.sort.SortFieldBuilder;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.sort.Sorts;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectEntry"}, service={AopService.class})
public class ObjectEntryLocalServiceImpl
extends ObjectEntryLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryLocalServiceImpl.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetLinkLocalService _assetLinkLocalService;
    @Reference
    private CurrentConnection _currentConnection;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private InlineSQLHelper _inlineSQLHelper;
    @Reference
    private ListTypeEntryLocalService _listTypeEntryLocalService;
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectFieldPersistence _objectFieldPersistence;
    @Reference
    private ObjectRelatedModelsProviderRegistry _objectRelatedModelsProviderRegistry;
    @Reference
    private ObjectRelationshipPersistence _objectRelationshipPersistence;
    @Reference
    private ObjectScopeProviderRegistry _objectScopeProviderRegistry;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private Searcher _searcher;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private SortFieldBuilder _sortFieldBuilder;
    @Reference
    private Sorts _sorts;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;

    public ObjectEntry addObjectEntry(long userId, long groupId, long objectDefinitionId, Map<String, Serializable> values, ServiceContext serviceContext) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        this._validateGroupId(groupId, objectDefinition.getScope());
        this._validateValues(objectDefinitionId, values);
        long objectEntryId = this.counterLocalService.increment();
        this._insertIntoTable(this._getDynamicObjectDefinitionTable(objectDefinitionId), objectEntryId, values);
        this._insertIntoTable(this._getExtensionDynamicObjectDefinitionTable(objectDefinitionId), objectEntryId, values);
        ObjectEntry objectEntry = this.objectEntryPersistence.create(objectEntryId);
        objectEntry.setGroupId(groupId);
        User user = this._userLocalService.getUser(userId);
        objectEntry.setCompanyId(user.getCompanyId());
        objectEntry.setUserId(user.getUserId());
        objectEntry.setUserName(user.getFullName());
        objectEntry.setObjectDefinitionId(objectDefinitionId);
        objectEntry.setStatus(2);
        objectEntry.setStatusByUserId(user.getUserId());
        objectEntry.setStatusDate(serviceContext.getModifiedDate(null));
        objectEntry = (ObjectEntry)this.objectEntryPersistence.update((BaseModel)objectEntry);
        this._resourceLocalService.addResources(objectEntry.getCompanyId(), objectEntry.getGroupId(), objectEntry.getUserId(), objectDefinition.getClassName(), objectEntry.getPrimaryKey(), false, false, false);
        this.updateAsset(serviceContext.getUserId(), objectEntry, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        this._startWorkflowInstance(userId, objectEntry, serviceContext);
        this._reindex(objectEntry);
        return objectEntry;
    }

    public ObjectEntry addOrUpdateObjectEntry(String externalReferenceCode, long userId, long groupId, long objectDefinitionId, Map<String, Serializable> values, ServiceContext serviceContext) throws PortalException {
        ObjectEntry objectEntry;
        User user = this._userLocalService.getUser(userId);
        if (groupId != 0L) {
            Group group = this._groupLocalService.getGroup(groupId);
            if (user.getCompanyId() != group.getCompanyId()) {
                throw new PrincipalException();
            }
        }
        if ((objectEntry = this.objectEntryPersistence.fetchByG_C_ERC(groupId, user.getCompanyId(), externalReferenceCode)) != null) {
            return this.updateObjectEntry(userId, objectEntry.getObjectEntryId(), values, serviceContext);
        }
        objectEntry = this.addObjectEntry(userId, groupId, objectDefinitionId, values, serviceContext);
        objectEntry.setExternalReferenceCode(externalReferenceCode);
        objectEntry = (ObjectEntry)this.objectEntryPersistence.update((BaseModel)objectEntry);
        this._reindex(objectEntry);
        return objectEntry;
    }

    @Override
    public ObjectEntry deleteObjectEntry(long objectEntryId) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryPersistence.findByPrimaryKey(objectEntryId);
        return this.objectEntryLocalService.deleteObjectEntry(objectEntry);
    }

    @Override
    @SystemEvent(type=1)
    public ObjectEntry deleteObjectEntry(ObjectEntry objectEntry) throws PortalException {
        objectEntry = (ObjectEntry)this.objectEntryPersistence.remove((BaseModel)objectEntry);
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectEntry.getObjectDefinitionId());
        this._resourceLocalService.deleteResource(objectEntry.getCompanyId(), objectDefinition.getClassName(), 4, objectEntry.getObjectEntryId());
        this._assetEntryLocalService.deleteEntry(objectDefinition.getClassName(), objectEntry.getObjectEntryId());
        this._workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(objectEntry.getCompanyId(), objectEntry.getNonzeroGroupId(), objectDefinition.getClassName(), objectEntry.getObjectEntryId());
        this._deleteFromTable(objectDefinition.getDBTableName(), objectDefinition, objectEntry);
        this._deleteFromTable(objectDefinition.getExtensionDBTableName(), objectDefinition, objectEntry);
        this.deleteRelatedObjectEntries(objectEntry.getGroupId(), objectDefinition.getObjectDefinitionId(), objectEntry.getPrimaryKey());
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)objectDefinition.getClassName());
        indexer.delete((Object)objectEntry);
        return objectEntry;
    }

    public ObjectEntry deleteObjectEntry(String externalReferenceCode, long companyId, long groupId) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryPersistence.findByG_C_ERC(groupId, companyId, externalReferenceCode);
        return this.objectEntryLocalService.deleteObjectEntry(objectEntry);
    }

    public void deleteRelatedObjectEntries(long groupId, long objectDefinitionId, long primaryKey) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        List objectRelationships = this._objectRelationshipPersistence.findByObjectDefinitionId1(objectDefinitionId);
        for (ObjectRelationship objectRelationship : objectRelationships) {
            ObjectRelatedModelsProvider objectRelatedModelsProvider = this._objectRelatedModelsProviderRegistry.getObjectRelatedModelsProvider(objectDefinition.getClassName(), objectRelationship.getType());
            objectRelatedModelsProvider.deleteRelatedModel(PrincipalThreadLocal.getUserId(), groupId, objectRelationship.getObjectRelationshipId(), primaryKey);
        }
    }

    public List<ObjectEntry> getManyToManyRelatedObjectEntries(long groupId, long objectRelationshipId, long primaryKey, boolean reverse, int start, int end) throws PortalException {
        DSLQuery dslQuery = this._getManyToManyRelatedObjectEntriesGroupByStep(groupId, objectRelationshipId, primaryKey, reverse, DSLQueryFactoryUtil.selectDistinct((Table)ObjectEntryTable.INSTANCE)).limit(start, end);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Get many to many related object entries: " + dslQuery));
        }
        return (List)this.objectEntryPersistence.dslQuery(dslQuery);
    }

    public int getManyToManyRelatedObjectEntriesCount(long groupId, long objectRelationshipId, long primaryKey, boolean reverse) throws PortalException {
        GroupByStep dslQuery = this._getManyToManyRelatedObjectEntriesGroupByStep(groupId, objectRelationshipId, primaryKey, reverse, DSLQueryFactoryUtil.countDistinct((Expression)ObjectEntryTable.INSTANCE.objectEntryId));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Get many to many related object entries count: " + dslQuery));
        }
        return this.objectEntryPersistence.dslQueryCount((DSLQuery)dslQuery);
    }

    public List<ObjectEntry> getObjectEntries(long groupId, long objectDefinitionId, int start, int end) throws PortalException {
        return this.objectEntryPersistence.findByG_ODI(groupId, objectDefinitionId, start, end);
    }

    public List<ObjectEntry> getObjectEntries(long groupId, long objectDefinitionId, int status, int start, int end) throws PortalException {
        return this.objectEntryPersistence.findByG_ODI_S(groupId, objectDefinitionId, status, start, end);
    }

    public int getObjectEntriesCount(long groupId, long objectDefinitionId) {
        return this.objectEntryPersistence.countByG_ODI(groupId, objectDefinitionId);
    }

    public ObjectEntry getObjectEntry(String externalReferenceCode, long companyId, long groupId) throws PortalException {
        return this.objectEntryPersistence.findByG_C_ERC(groupId, companyId, externalReferenceCode);
    }

    public List<ObjectEntry> getOneToManyRelatedObjectEntries(long groupId, long objectRelationshipId, long primaryKey, int start, int end) throws PortalException {
        DSLQuery dslQuery = this._getOneToManyRelatedObjectEntriesGroupByStep(groupId, objectRelationshipId, primaryKey, DSLQueryFactoryUtil.selectDistinct((Table)ObjectEntryTable.INSTANCE)).limit(start, end);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Get one to many related object entries: " + dslQuery));
        }
        return (List)this.objectEntryPersistence.dslQuery(dslQuery);
    }

    public int getOneToManyRelatedObjectEntriesCount(long groupId, long objectRelationshipId, long primaryKey) throws PortalException {
        GroupByStep dslQuery = this._getOneToManyRelatedObjectEntriesGroupByStep(groupId, objectRelationshipId, primaryKey, DSLQueryFactoryUtil.countDistinct((Expression)ObjectEntryTable.INSTANCE.objectEntryId));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Get one to many related object entries count: " + dslQuery));
        }
        return this.objectEntryPersistence.dslQueryCount((DSLQuery)dslQuery);
    }

    public Map<String, Serializable> getValues(long objectEntryId) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryPersistence.findByPrimaryKey(objectEntryId);
        return this.getValues(objectEntry);
    }

    public Map<String, Serializable> getValues(ObjectEntry objectEntry) throws PortalException {
        DynamicObjectDefinitionTable dynamicObjectDefinitionTable = this._getDynamicObjectDefinitionTable(objectEntry.getObjectDefinitionId());
        DynamicObjectDefinitionTable extensionDynamicObjectDefinitionTable = this._getExtensionDynamicObjectDefinitionTable(objectEntry.getObjectDefinitionId());
        Expression[] selectExpressions = (Expression[])ArrayUtil.append((Object[])dynamicObjectDefinitionTable.getSelectExpressions(), (Object[])extensionDynamicObjectDefinitionTable.getSelectExpressions());
        List<Object[]> rows = this._list((DSLQuery)DSLQueryFactoryUtil.selectDistinct((Expression[])selectExpressions).from((Table)dynamicObjectDefinitionTable).innerJoinON((Table)extensionDynamicObjectDefinitionTable, dynamicObjectDefinitionTable.getPrimaryKeyColumn().eq(extensionDynamicObjectDefinitionTable.getPrimaryKeyColumn())).where(dynamicObjectDefinitionTable.getPrimaryKeyColumn().eq((Object)objectEntry.getObjectEntryId())), selectExpressions);
        if (ListUtil.isEmpty(rows)) {
            throw new ObjectEntryValuesException("No values exist for object entry " + objectEntry.getObjectEntryId());
        }
        return this._getValues(rows.get(0), selectExpressions);
    }

    public List<Map<String, Serializable>> getValuesList(long objectDefinitionId, int[] statuses, int start, int end) throws PortalException {
        DynamicObjectDefinitionTable dynamicObjectDefinitionTable = this._getDynamicObjectDefinitionTable(objectDefinitionId);
        DynamicObjectDefinitionTable extensionDynamicObjectDefinitionTable = this._getExtensionDynamicObjectDefinitionTable(objectDefinitionId);
        Expression[] selectExpressions = (Expression[])ArrayUtil.append((Object[])dynamicObjectDefinitionTable.getSelectExpressions(), (Object[])extensionDynamicObjectDefinitionTable.getSelectExpressions());
        List<Object[]> rows = this._list(DSLQueryFactoryUtil.selectDistinct((Expression[])selectExpressions).from((Table)dynamicObjectDefinitionTable).innerJoinON((Table)ObjectEntryTable.INSTANCE, ObjectEntryTable.INSTANCE.objectEntryId.eq(dynamicObjectDefinitionTable.getPrimaryKeyColumn())).innerJoinON((Table)extensionDynamicObjectDefinitionTable, extensionDynamicObjectDefinitionTable.getPrimaryKeyColumn().eq(dynamicObjectDefinitionTable.getPrimaryKeyColumn())).where(ObjectEntryTable.INSTANCE.objectDefinitionId.eq((Object)objectDefinitionId).and(() -> {
            if (ArrayUtil.isEmpty((int[])statuses)) {
                return null;
            }
            return ObjectEntryTable.INSTANCE.status.in((Object[])ArrayUtil.toArray((int[])statuses));
        }).and(() -> {
            if (PermissionThreadLocal.getPermissionChecker() == null) {
                return null;
            }
            return this._inlineSQLHelper.getPermissionWherePredicate(dynamicObjectDefinitionTable.getName(), dynamicObjectDefinitionTable.getPrimaryKeyColumn(), new long[0]);
        })).limit(start, end), selectExpressions);
        ArrayList<Map<String, Serializable>> valuesList = new ArrayList<Map<String, Serializable>>(rows.size());
        for (Object[] objects : rows) {
            Map<String, Serializable> values = this._getValues(objects, selectExpressions);
            valuesList.add(values);
        }
        return valuesList;
    }

    public void insertIntoOrUpdateExtensionTable(long objectDefinitionId, long primaryKey, Map<String, Serializable> values) throws PortalException {
        DynamicObjectDefinitionTable dynamicObjectDefinitionTable = this._getExtensionDynamicObjectDefinitionTable(objectDefinitionId);
        Column<DynamicObjectDefinitionTable, Long> primaryKeyColumn = dynamicObjectDefinitionTable.getPrimaryKeyColumn();
        int count = this.objectEntryPersistence.dslQueryCount((DSLQuery)DSLQueryFactoryUtil.count().from((Table)dynamicObjectDefinitionTable).where(primaryKeyColumn.eq((Object)primaryKey)));
        if (count > 0) {
            this._updateTable(dynamicObjectDefinitionTable, primaryKey, values);
        } else {
            this._insertIntoTable(dynamicObjectDefinitionTable, primaryKey, values);
        }
    }

    public BaseModelSearchResult<ObjectEntry> searchObjectEntries(long groupId, long objectDefinitionId, String keywords, int cur, int delta) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        ObjectScopeProvider objectScopeProvider = this._objectScopeProviderRegistry.getObjectScopeProvider(objectDefinition.getScope());
        SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder();
        searchRequestBuilder.entryClassNames(new String[]{objectDefinition.getClassName()}).emptySearchEnabled(true).from(Integer.valueOf(cur)).size(Integer.valueOf(delta)).sorts(new Sort[]{this._sorts.field("entryClassPK", SortOrder.ASC)}).withSearchContext(searchContext -> {
            searchContext.setAttribute("status", (Serializable)Integer.valueOf(-1));
            searchContext.setAttribute("objectDefinitionId", (Serializable)Long.valueOf(objectDefinition.getObjectDefinitionId()));
            searchContext.setCompanyId(objectDefinition.getCompanyId());
            if (objectScopeProvider.isGroupAware()) {
                searchContext.setGroupIds(new long[]{groupId});
            } else {
                searchContext.setGroupIds(new long[]{0L});
            }
            searchContext.setKeywords(keywords);
        });
        SearchResponse searchResponse = this._searcher.search(searchRequestBuilder.build());
        SearchHits searchHits = searchResponse.getSearchHits();
        List searchHitsList = searchHits.getSearchHits();
        Stream stream = searchHitsList.stream();
        List objectEntries = stream.map(searchHit -> {
            Document document = searchHit.getDocument();
            long objectEntryId = document.getLong("entryClassPK");
            return this.objectEntryPersistence.fetchByPrimaryKey(objectEntryId);
        }).collect(Collectors.toList());
        return new BaseModelSearchResult(objectEntries, searchResponse.getTotalHits());
    }

    public void updateAsset(long userId, ObjectEntry objectEntry, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds, Double priority) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectEntry.getObjectDefinitionId());
        boolean visible = false;
        if (objectEntry.isApproved()) {
            visible = true;
        }
        AssetEntry assetEntry = this._assetEntryLocalService.updateEntry(userId, objectEntry.getNonzeroGroupId(), objectEntry.getCreateDate(), objectEntry.getModifiedDate(), objectDefinition.getClassName(), objectEntry.getObjectEntryId(), objectEntry.getUuid(), 0L, assetCategoryIds, assetTagNames, true, visible, null, null, null, null, "text/plain", String.valueOf(objectEntry.getObjectEntryId()), String.valueOf(objectEntry.getObjectEntryId()), null, null, null, 0, 0, priority);
        this._assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    public ObjectEntry updateObjectEntry(long userId, long objectEntryId, Map<String, Serializable> values, ServiceContext serviceContext) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryPersistence.findByPrimaryKey(objectEntryId);
        this._validateValues(objectEntry.getObjectDefinitionId(), values);
        objectEntry.setTransientValues(objectEntry.getValues());
        this._updateTable(this._getDynamicObjectDefinitionTable(objectEntry.getObjectDefinitionId()), objectEntryId, values);
        this._updateTable(this._getExtensionDynamicObjectDefinitionTable(objectEntry.getObjectDefinitionId()), objectEntryId, values);
        objectEntry.setModifiedDate(serviceContext.getModifiedDate(null));
        objectEntry.setValues(null);
        objectEntry = (ObjectEntry)this.objectEntryPersistence.update((BaseModel)objectEntry);
        this.updateAsset(serviceContext.getUserId(), objectEntry, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        this._startWorkflowInstance(userId, objectEntry, serviceContext);
        this._reindex(objectEntry);
        return objectEntry;
    }

    public ObjectEntry updateStatus(long userId, long objectEntryId, int status, ServiceContext serviceContext) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryPersistence.findByPrimaryKey(objectEntryId);
        if (objectEntry.getStatus() == status) {
            return objectEntry;
        }
        objectEntry.setStatus(status);
        User user = this._userLocalService.getUser(userId);
        objectEntry.setStatusByUserId(user.getUserId());
        objectEntry.setStatusByUserName(user.getFullName());
        objectEntry.setStatusDate(serviceContext.getModifiedDate(null));
        objectEntry = (ObjectEntry)this.objectEntryPersistence.update((BaseModel)objectEntry);
        this._reindex(objectEntry);
        return objectEntry;
    }

    private void _deleteFromTable(String dbTableName, ObjectDefinition objectDefinition, ObjectEntry objectEntry) throws PortalException {
        this.runSQL(StringBundler.concat((Object[])new Object[]{"delete from ", dbTableName, " where ", objectDefinition.getPKObjectFieldDBColumnName(), " = ", objectEntry.getObjectEntryId()}));
    }

    private DynamicObjectDefinitionTable _getDynamicObjectDefinitionTable(long objectDefinitionId) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        return new DynamicObjectDefinitionTable(objectDefinition, this._objectFieldPersistence.findByODI_DTN(objectDefinitionId, objectDefinition.getDBTableName()), objectDefinition.getDBTableName());
    }

    private DynamicObjectDefinitionTable _getExtensionDynamicObjectDefinitionTable(long objectDefinitionId) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        return new DynamicObjectDefinitionTable(objectDefinition, this._objectFieldPersistence.findByODI_DTN(objectDefinitionId, objectDefinition.getExtensionDBTableName()), objectDefinition.getExtensionDBTableName());
    }

    private GroupByStep _getManyToManyRelatedObjectEntriesGroupByStep(long groupId, long objectRelationshipId, long primaryKey, boolean reverse, FromStep fromStep) throws PortalException {
        ObjectRelationship objectRelationship = this._objectRelationshipPersistence.findByPrimaryKey(objectRelationshipId);
        long objectDefinitionId1 = objectRelationship.getObjectDefinitionId1();
        long objectDefinitionId2 = objectRelationship.getObjectDefinitionId2();
        if (reverse) {
            objectDefinitionId1 = objectRelationship.getObjectDefinitionId2();
            objectDefinitionId2 = objectRelationship.getObjectDefinitionId1();
        }
        DynamicObjectDefinitionTable dynamicObjectDefinitionTable = this._getDynamicObjectDefinitionTable(objectDefinitionId2);
        DynamicObjectDefinitionTable extensionDynamicObjectDefinitionTable = this._getExtensionDynamicObjectDefinitionTable(objectDefinitionId2);
        ObjectDefinition objectDefinition1 = this._objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId1);
        ObjectDefinition objectDefinition2 = this._objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId2);
        DynamicObjectRelationshipMappingTable dynamicObjectRelationshipMappingTable = new DynamicObjectRelationshipMappingTable(objectDefinition1.getPKObjectFieldDBColumnName(), objectDefinition2.getPKObjectFieldDBColumnName(), objectRelationship.getDBTableName());
        Column<DynamicObjectRelationshipMappingTable, Long> primaryKeyColumn1 = dynamicObjectRelationshipMappingTable.getPrimaryKeyColumn1();
        Column<DynamicObjectRelationshipMappingTable, Long> primaryKeyColumn2 = dynamicObjectRelationshipMappingTable.getPrimaryKeyColumn2();
        return fromStep.from((Table)dynamicObjectDefinitionTable).innerJoinON((Table)ObjectEntryTable.INSTANCE, ObjectEntryTable.INSTANCE.objectEntryId.eq(dynamicObjectDefinitionTable.getPrimaryKeyColumn())).innerJoinON((Table)extensionDynamicObjectDefinitionTable, extensionDynamicObjectDefinitionTable.getPrimaryKeyColumn().eq(dynamicObjectDefinitionTable.getPrimaryKeyColumn())).innerJoinON((Table)dynamicObjectRelationshipMappingTable, primaryKeyColumn2.eq(dynamicObjectDefinitionTable.getPrimaryKeyColumn())).where(ObjectEntryTable.INSTANCE.groupId.eq((Object)groupId).and((Expression)ObjectEntryTable.INSTANCE.companyId.eq((Object)objectRelationship.getCompanyId())).and((Expression)ObjectEntryTable.INSTANCE.objectDefinitionId.eq((Object)objectDefinitionId2)).and((Expression)primaryKeyColumn1.eq((Object)primaryKey)).and(() -> {
            if (PermissionThreadLocal.getPermissionChecker() == null) {
                return null;
            }
            return this._inlineSQLHelper.getPermissionWherePredicate(dynamicObjectDefinitionTable.getName(), dynamicObjectDefinitionTable.getPrimaryKeyColumn(), new long[0]);
        }));
    }

    private GroupByStep _getOneToManyRelatedObjectEntriesGroupByStep(long groupId, long objectRelationshipId, long primaryKey, FromStep fromStep) throws PortalException {
        ObjectRelationship objectRelationship = this._objectRelationshipPersistence.findByPrimaryKey(objectRelationshipId);
        DynamicObjectDefinitionTable dynamicObjectDefinitionTable = this._getDynamicObjectDefinitionTable(objectRelationship.getObjectDefinitionId2());
        DynamicObjectDefinitionTable extensionDynamicObjectDefinitionTable = this._getExtensionDynamicObjectDefinitionTable(objectRelationship.getObjectDefinitionId2());
        ObjectField objectField = this._objectFieldPersistence.fetchByPrimaryKey(objectRelationship.getObjectFieldId2());
        return fromStep.from((Table)dynamicObjectDefinitionTable).innerJoinON((Table)ObjectEntryTable.INSTANCE, ObjectEntryTable.INSTANCE.objectEntryId.eq(dynamicObjectDefinitionTable.getPrimaryKeyColumn())).innerJoinON((Table)extensionDynamicObjectDefinitionTable, extensionDynamicObjectDefinitionTable.getPrimaryKeyColumn().eq(dynamicObjectDefinitionTable.getPrimaryKeyColumn())).where(ObjectEntryTable.INSTANCE.groupId.eq((Object)groupId).and((Expression)ObjectEntryTable.INSTANCE.companyId.eq((Object)objectRelationship.getCompanyId())).and((Expression)ObjectEntryTable.INSTANCE.objectDefinitionId.eq((Object)objectRelationship.getObjectDefinitionId2())).and(() -> {
            Column primaryKeyColumn = null;
            primaryKeyColumn = Objects.equals(objectField.getDBTableName(), dynamicObjectDefinitionTable.getName()) ? dynamicObjectDefinitionTable.getColumn(objectField.getDBColumnName()) : extensionDynamicObjectDefinitionTable.getColumn(objectField.getDBColumnName());
            return primaryKeyColumn.eq((Object)primaryKey);
        }).and(() -> {
            if (PermissionThreadLocal.getPermissionChecker() == null) {
                return null;
            }
            return this._inlineSQLHelper.getPermissionWherePredicate(dynamicObjectDefinitionTable.getName(), dynamicObjectDefinitionTable.getPrimaryKeyColumn(), new long[0]);
        }));
    }

    private Object _getValue(ResultSet resultSet, String name, int sqlType) throws SQLException {
        if (sqlType == -5) {
            return resultSet.getLong(name);
        }
        if (sqlType == 2004) {
            if (PostgreSQLJDBCUtil.isPGStatement((Statement)resultSet.getStatement())) {
                return PostgreSQLJDBCUtil.getLargeObject((ResultSet)resultSet, (String)name);
            }
            return resultSet.getBytes(name);
        }
        if (sqlType == 16) {
            return resultSet.getBoolean(name);
        }
        if (sqlType == 2005) {
            return resultSet.getClob(name);
        }
        if (sqlType == 91) {
            return resultSet.getTimestamp(name);
        }
        if (sqlType == 3) {
            return resultSet.getBigDecimal(name);
        }
        if (sqlType == 8) {
            return resultSet.getDouble(name);
        }
        if (sqlType == 4) {
            return resultSet.getInt(name);
        }
        if (sqlType == 12) {
            return resultSet.getString(name);
        }
        throw new IllegalArgumentException("Unable to get value with SQL type " + sqlType);
    }

    private String _getValue(String valueString) {
        try {
            JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)valueString);
            return GetterUtil.getString((Object)jsonArray.get(0));
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)jsonException, (Throwable)jsonException);
            }
            return GetterUtil.getString((String)valueString);
        }
    }

    private Map<String, Serializable> _getValues(Object[] objects, Expression<?>[] selectExpressions) {
        HashMap<String, Serializable> values = new HashMap<String, Serializable>();
        for (int i = 0; i < selectExpressions.length; ++i) {
            Column column = (Column)selectExpressions[i];
            String columnName = column.getName();
            if (columnName.endsWith("_")) {
                columnName = columnName.substring(0, columnName.length() - 1);
            }
            this._putValue(column, columnName, objects[i], values);
        }
        return values;
    }

    private void _insertIntoTable(DynamicObjectDefinitionTable dynamicObjectDefinitionTable, long objectEntryId, Map<String, Serializable> values) throws PortalException {
        StringBundler sb = new StringBundler();
        sb.append("insert into ");
        sb.append(dynamicObjectDefinitionTable.getName());
        sb.append(" (");
        Column<DynamicObjectDefinitionTable, Long> primaryKeyColumn = dynamicObjectDefinitionTable.getPrimaryKeyColumn();
        sb.append(primaryKeyColumn.getName());
        int count = 1;
        List<ObjectField> objectFields = dynamicObjectDefinitionTable.getObjectFields();
        for (ObjectField objectField : objectFields) {
            Serializable value = values.get(objectField.getName());
            if (value == null) {
                if (objectField.isRequired()) {
                    throw new ObjectEntryValuesException("No value was provided for required object field \"" + objectField.getName() + "\"");
                }
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("No value was provided for object field \"" + objectField.getName() + "\""));
                continue;
            }
            if (Objects.equals(objectField.getRelationshipType(), "oneToOne")) {
                this._validateOneToOneInsert(objectField.getDBColumnName(), GetterUtil.getLong((Object)value), dynamicObjectDefinitionTable);
            }
            sb.append(", ");
            sb.append(objectField.getDBColumnName());
            ++count;
        }
        sb.append(") values (?");
        for (int i = 1; i < count; ++i) {
            sb.append(", ?");
        }
        sb.append(")");
        String sql = sb.toString();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("SQL: " + sql));
        }
        Connection connection = this._currentConnection.getConnection(this.objectEntryPersistence.getDataSource());
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            int index = 1;
            this._setColumn(preparedStatement, index++, -5, objectEntryId);
            for (ObjectField objectField : objectFields) {
                Serializable value = values.get(objectField.getName());
                if (value == null) continue;
                Column column = dynamicObjectDefinitionTable.getColumn(objectField.getDBColumnName());
                this._setColumn(preparedStatement, index++, column.getSQLType(), value);
            }
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private void _list(Connection connection, DSLQuery dslQuery, List<Object[]> results, Expression<?>[] selectExpressions) throws SQLException {
        DefaultASTNodeListener defaultASTNodeListener = new DefaultASTNodeListener();
        try (PreparedStatement preparedStatement = connection.prepareStatement(dslQuery.toSQL((ASTNodeListener)defaultASTNodeListener));){
            List scalarValues = defaultASTNodeListener.getScalarValues();
            for (int i = 0; i < scalarValues.size(); ++i) {
                preparedStatement.setObject(i + 1, scalarValues.get(i));
            }
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    Object[] result = new Object[selectExpressions.length];
                    for (int i = 0; i < selectExpressions.length; ++i) {
                        Column column = (Column)selectExpressions[i];
                        String columnName = column.getName();
                        result[i] = this._getValue(resultSet, columnName, column.getSQLType());
                    }
                    results.add(result);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object[]> _list(DSLQuery dslQuery, Expression<?>[] selectExpressions) {
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        Session session = this.objectEntryPersistence.openSession();
        try {
            session.apply(connection -> this._list((Connection)connection, dslQuery, (List<Object[]>)results, selectExpressions));
        }
        finally {
            this.objectEntryPersistence.closeSession(session);
        }
        return results;
    }

    private void _putValue(Column<?, ?> column, String name, Object object, Map<String, Serializable> values) {
        Class clazz = column.getJavaType();
        if (clazz == BigDecimal.class) {
            values.put(name, (BigDecimal)object);
        } else if (clazz == Blob.class) {
            byte[] bytes = null;
            if (object != null) {
                if (object instanceof Blob) {
                    Blob blob = (Blob)object;
                    try {
                        bytes = blob.getBytes(1L, (int)blob.length());
                    }
                    catch (SQLException sqlException) {
                        throw new SystemException((Throwable)sqlException);
                    }
                } else if (object instanceof byte[]) {
                    bytes = (byte[])object;
                } else {
                    Class<?> objectClass = object.getClass();
                    throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"Unable to put \"", name, "\" with unknown object class ", objectClass.getName()}));
                }
            }
            values.put(name, (Serializable)bytes);
        } else if (clazz == Boolean.class) {
            if (object == null) {
                object = Boolean.FALSE;
            }
            if (object instanceof Byte) {
                Byte byteObject = (Byte)object;
                object = byteObject.intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            values.put(name, (Boolean)object);
        } else if (clazz == Clob.class) {
            if (object == null) {
                values.put(name, (Serializable)((Object)""));
            } else {
                Clob clob = (Clob)object;
                try {
                    InputStream inputStream = clob.getAsciiStream();
                    values.put(name, (Serializable)((Object)GetterUtil.getString((String)IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8))));
                }
                catch (IOException | SQLException exception) {
                    throw new SystemException((Throwable)exception);
                }
            }
        } else if (clazz == Date.class) {
            values.put(name, (Date)object);
        } else if (clazz == Double.class) {
            Number number = (Number)object;
            if (number == null) {
                number = 0.0;
            } else if (!(number instanceof Double)) {
                number = number.doubleValue();
            }
            values.put(name, number);
        } else if (clazz == Integer.class) {
            Number number = (Number)object;
            if (number == null) {
                number = 0;
            } else if (!(number instanceof Integer)) {
                number = number.intValue();
            }
            values.put(name, number);
        } else if (clazz == Long.class) {
            Number number = (Number)object;
            if (number == null) {
                number = 0L;
            } else if (!(number instanceof Long)) {
                number = number.longValue();
            }
            values.put(name, number);
        } else if (clazz == String.class) {
            values.put(name, (Serializable)((Object)((String)object)));
        } else {
            throw new IllegalArgumentException("Unable to put value with class " + clazz.getName());
        }
    }

    private void _reindex(ObjectEntry objectEntry) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectEntry.getObjectDefinitionId());
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)objectDefinition.getClassName());
        indexer.reindex(objectDefinition.getClassName(), objectEntry.getObjectEntryId());
    }

    private void _setColumn(PreparedStatement preparedStatement, int index, int sqlType, Object value) throws Exception {
        if (sqlType == -5) {
            preparedStatement.setLong(index, GetterUtil.getLong((Object)value));
        } else if (sqlType == 2004) {
            if (PostgreSQLJDBCUtil.isPGStatement((Statement)preparedStatement)) {
                PostgreSQLJDBCUtil.setLargeObject((PreparedStatement)preparedStatement, (int)index, (byte[])((byte[])value));
            } else {
                preparedStatement.setBytes(index, (byte[])value);
            }
        } else if (sqlType == 16) {
            preparedStatement.setBoolean(index, GetterUtil.getBoolean((Object)value));
        } else if (sqlType == 2005) {
            preparedStatement.setClob(index, new StringReader(String.valueOf(value)));
        } else if (sqlType == 91) {
            String valueString = GetterUtil.getString((Object)value);
            if (value instanceof Date) {
                Date date = (Date)value;
                preparedStatement.setTimestamp(index, new Timestamp(date.getTime()));
            } else if (valueString.isEmpty()) {
                preparedStatement.setTimestamp(index, null);
            } else {
                Date date = DateUtil.parseDate((String)"yyyy-MM-dd", (String)valueString, (Locale)LocaleUtil.getSiteDefault());
                preparedStatement.setTimestamp(index, new Timestamp(date.getTime()));
            }
        } else if (sqlType == 3) {
            preparedStatement.setBigDecimal(index, (BigDecimal)GetterUtil.get((Object)value, (Number)BigDecimal.ZERO));
        } else if (sqlType == 8) {
            preparedStatement.setDouble(index, GetterUtil.getDouble((Object)value));
        } else if (sqlType == 4) {
            preparedStatement.setInt(index, GetterUtil.getInteger((Object)value));
        } else if (sqlType == 12) {
            preparedStatement.setString(index, String.valueOf(value));
        } else {
            throw new IllegalArgumentException("Unable to set column with SQL type " + sqlType);
        }
    }

    private void _startWorkflowInstance(long userId, ObjectEntry objectEntry, ServiceContext serviceContext) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectEntry.getObjectDefinitionId());
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)objectEntry.getCompanyId(), (long)objectEntry.getNonzeroGroupId(), (long)userId, (String)objectDefinition.getClassName(), (long)objectEntry.getObjectEntryId(), (Object)objectEntry, (ServiceContext)serviceContext);
    }

    private void _updateTable(DynamicObjectDefinitionTable dynamicObjectDefinitionTable, long objectEntryId, Map<String, Serializable> values) throws PortalException {
        StringBundler sb = new StringBundler();
        sb.append("update ");
        sb.append(dynamicObjectDefinitionTable.getName());
        sb.append(" set ");
        int count = 0;
        List<ObjectField> objectFields = dynamicObjectDefinitionTable.getObjectFields();
        for (ObjectField objectField : objectFields) {
            Serializable value = values.get(objectField.getName());
            if (value == null) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("No value was provided for object field \"" + objectField.getName() + "\""));
                continue;
            }
            if (Objects.equals(objectField.getRelationshipType(), "oneToOne")) {
                this._validateOneToOneUpdate(objectField.getDBColumnName(), GetterUtil.getLong((Object)value), dynamicObjectDefinitionTable, objectEntryId);
            }
            if (count > 0) {
                sb.append(", ");
            }
            sb.append(objectField.getDBColumnName());
            sb.append(" = ?");
            ++count;
        }
        if (count == 0) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No values were provided for object entry " + objectEntryId));
            }
            return;
        }
        sb.append(" where ");
        Column<DynamicObjectDefinitionTable, Long> primaryKeyColumn = dynamicObjectDefinitionTable.getPrimaryKeyColumn();
        sb.append(primaryKeyColumn.getName());
        sb.append(" = ?");
        String sql = sb.toString();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("SQL: " + sql));
        }
        Connection connection = this._currentConnection.getConnection(this.objectEntryPersistence.getDataSource());
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            int index = 1;
            for (ObjectField objectField : objectFields) {
                Serializable value = values.get(objectField.getName());
                if (value == null) continue;
                Column column = dynamicObjectDefinitionTable.getColumn(objectField.getDBColumnName());
                this._setColumn(preparedStatement, index++, column.getSQLType(), value);
            }
            this._setColumn(preparedStatement, index++, -5, objectEntryId);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private void _validateGroupId(long groupId, String scope) throws PortalException {
        ObjectScopeProvider objectScopeProvider = this._objectScopeProviderRegistry.getObjectScopeProvider(scope);
        if (!objectScopeProvider.isValidGroupId(groupId)) {
            throw new ObjectDefinitionScopeException(StringBundler.concat((Object[])new Object[]{"Group ID ", groupId, " is not valid for scope \"", scope, "\""}));
        }
    }

    private void _validateListTypeEntriesValues(Map<String, Serializable> values, Map.Entry<String, Serializable> entry, ObjectField objectField) throws ObjectEntryValuesException {
        List listTypeEntries = this._listTypeEntryLocalService.getListTypeEntries(objectField.getListTypeDefinitionId());
        Stream stream = listTypeEntries.stream();
        String value = this._getValue(String.valueOf(values.get(entry.getKey())));
        if (!(value.isEmpty() && !objectField.isRequired() || stream.anyMatch(listTypeEntry -> Objects.equals(listTypeEntry.getKey(), value)))) {
            throw new ObjectEntryValuesException("Object field name \"" + entry.getKey() + "\" is not mapped to a valid list type entry");
        }
    }

    private void _validateObjectFieldStringTypeLength(Map.Entry<String, Serializable> entry) throws ObjectEntryValuesException {
        String value = (String)((Object)entry.getValue());
        if (value != null && value.length() > 280) {
            throw new ObjectEntryValuesException("Object field \"" + entry.getKey() + "\" value exceeds 280 characters.");
        }
    }

    private void _validateOneToOneInsert(String dbColumnName, long dbColumnValue, DynamicObjectDefinitionTable dynamicObjectDefinitionTable) throws PortalException {
        if (dbColumnValue == 0L) {
            return;
        }
        int count = 0;
        Connection connection = this._currentConnection.getConnection(this.objectEntryPersistence.getDataSource());
        try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"select count(*) from ", dynamicObjectDefinitionTable.getTableName(), " where ", dbColumnName, " = ", dbColumnValue}));
             ResultSet resultSet = preparedStatement.executeQuery();){
            resultSet.next();
            count = resultSet.getInt(1);
        }
        catch (SQLException sqlException) {
            throw new SystemException((Throwable)sqlException);
        }
        if (count > 0) {
            throw new ObjectEntryValuesException(StringBundler.concat((Object[])new Object[]{"One to one constraint violation for ", dynamicObjectDefinitionTable.getTableName(), ".", dbColumnName, " with value ", dbColumnValue}));
        }
    }

    private void _validateOneToOneUpdate(String dbColumnName, long dbColumnValue, DynamicObjectDefinitionTable dynamicObjectDefinitionTable, long objectEntryId) throws PortalException {
        if (dbColumnValue == 0L) {
            return;
        }
        int count = 0;
        Connection connection = this._currentConnection.getConnection(this.objectEntryPersistence.getDataSource());
        try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"select count(*) from ", dynamicObjectDefinitionTable.getTableName(), " where ", dynamicObjectDefinitionTable.getPrimaryKeyColumnName(), " != ", objectEntryId, " and ", dbColumnName, " = ", dbColumnValue}));
             ResultSet resultSet = preparedStatement.executeQuery();){
            resultSet.next();
            count = resultSet.getInt(1);
        }
        catch (SQLException sqlException) {
            throw new SystemException((Throwable)sqlException);
        }
        if (count > 0) {
            throw new ObjectEntryValuesException(StringBundler.concat((Object[])new Object[]{"One to one constraint violation for ", dynamicObjectDefinitionTable.getTableName(), ".", dbColumnName, " with value ", dbColumnValue}));
        }
    }

    private void _validateValues(long objectDefinitionId, Map<String, Serializable> values) throws PortalException {
        for (Map.Entry<String, Serializable> entry : values.entrySet()) {
            ObjectField objectField = null;
            try {
                objectField = this._objectFieldLocalService.getObjectField(objectDefinitionId, entry.getKey());
            }
            catch (NoSuchObjectFieldException noSuchObjectFieldException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)noSuchObjectFieldException, (Throwable)noSuchObjectFieldException);
                continue;
            }
            if (StringUtil.equals((String)objectField.getDBType(), (String)"String")) {
                this._validateObjectFieldStringTypeLength(entry);
            }
            if (objectField.getListTypeDefinitionId() == 0L) continue;
            this._validateListTypeEntriesValues(values, entry, objectField);
        }
    }
}

