/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.security.permission.resource;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.object.model.ObjectDefinition"}, service={ModelResourcePermission.class})
public class ObjectDefinitionModelResourcePermission
implements ModelResourcePermission<ObjectDefinition> {
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference(target="(resource.name=com.liferay.object)")
    private PortletResourcePermission _portletResourcePermission;

    public void check(PermissionChecker permissionChecker, long objectDefinitionId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, objectDefinitionId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, ObjectDefinition.class.getName(), objectDefinitionId, new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, ObjectDefinition objectDefinition, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, objectDefinition, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, ObjectDefinition.class.getName(), objectDefinition.getPrimaryKey(), new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, long objectDefinitionId, String actionId) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectDefinitionId);
        return this.contains(permissionChecker, objectDefinition, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, ObjectDefinition objectDefinition, String actionId) throws PortalException {
        return permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), ObjectDefinition.class.getName(), objectDefinition.getObjectDefinitionId(), objectDefinition.getUserId(), actionId) || permissionChecker.getUserId() == objectDefinition.getUserId() || permissionChecker.hasPermission(null, ObjectDefinition.class.getName(), objectDefinition.getPrimaryKey(), actionId);
    }

    public String getModelName() {
        return ObjectDefinition.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return this._portletResourcePermission;
    }
}

