/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.object.model.ObjectLayoutRow;
import com.liferay.object.model.ObjectLayoutRowModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the ObjectLayoutRow service. Represents a row in the &quot;ObjectLayoutRow&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>ObjectLayoutRowModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectLayoutRowImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectLayoutRowImpl
 * @generated
 */
public class ObjectLayoutRowModelImpl
	extends BaseModelImpl<ObjectLayoutRow> implements ObjectLayoutRowModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object layout row model instance should use the <code>ObjectLayoutRow</code> interface instead.
	 */
	public static final String TABLE_NAME = "ObjectLayoutRow";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"objectLayoutRowId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"objectLayoutBoxId", Types.BIGINT}, {"priority", Types.INTEGER}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("objectLayoutRowId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("objectLayoutBoxId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("priority", Types.INTEGER);
	}

	public static final String TABLE_SQL_CREATE =
		"create table ObjectLayoutRow (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,objectLayoutRowId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,objectLayoutBoxId LONG,priority INTEGER)";

	public static final String TABLE_SQL_DROP = "drop table ObjectLayoutRow";

	public static final String ORDER_BY_JPQL =
		" ORDER BY objectLayoutRow.objectLayoutRowId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY ObjectLayoutRow.objectLayoutRowId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTLAYOUTBOXID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTLAYOUTROWID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public ObjectLayoutRowModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _objectLayoutRowId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setObjectLayoutRowId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _objectLayoutRowId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return ObjectLayoutRow.class;
	}

	@Override
	public String getModelClassName() {
		return ObjectLayoutRow.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<ObjectLayoutRow, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<ObjectLayoutRow, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectLayoutRow, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((ObjectLayoutRow)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<ObjectLayoutRow, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<ObjectLayoutRow, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(ObjectLayoutRow)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<ObjectLayoutRow, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<ObjectLayoutRow, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, ObjectLayoutRow>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			ObjectLayoutRow.class.getClassLoader(), ObjectLayoutRow.class,
			ModelWrapper.class);

		try {
			Constructor<ObjectLayoutRow> constructor =
				(Constructor<ObjectLayoutRow>)proxyClass.getConstructor(
					InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map<String, Function<ObjectLayoutRow, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<ObjectLayoutRow, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<ObjectLayoutRow, Object>>
			attributeGetterFunctions =
				new LinkedHashMap<String, Function<ObjectLayoutRow, Object>>();
		Map<String, BiConsumer<ObjectLayoutRow, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<ObjectLayoutRow, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", ObjectLayoutRow::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<ObjectLayoutRow, Long>)ObjectLayoutRow::setMvccVersion);
		attributeGetterFunctions.put("uuid", ObjectLayoutRow::getUuid);
		attributeSetterBiConsumers.put(
			"uuid",
			(BiConsumer<ObjectLayoutRow, String>)ObjectLayoutRow::setUuid);
		attributeGetterFunctions.put(
			"objectLayoutRowId", ObjectLayoutRow::getObjectLayoutRowId);
		attributeSetterBiConsumers.put(
			"objectLayoutRowId",
			(BiConsumer<ObjectLayoutRow, Long>)
				ObjectLayoutRow::setObjectLayoutRowId);
		attributeGetterFunctions.put(
			"companyId", ObjectLayoutRow::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<ObjectLayoutRow, Long>)ObjectLayoutRow::setCompanyId);
		attributeGetterFunctions.put("userId", ObjectLayoutRow::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<ObjectLayoutRow, Long>)ObjectLayoutRow::setUserId);
		attributeGetterFunctions.put("userName", ObjectLayoutRow::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<ObjectLayoutRow, String>)ObjectLayoutRow::setUserName);
		attributeGetterFunctions.put(
			"createDate", ObjectLayoutRow::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<ObjectLayoutRow, Date>)ObjectLayoutRow::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", ObjectLayoutRow::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<ObjectLayoutRow, Date>)
				ObjectLayoutRow::setModifiedDate);
		attributeGetterFunctions.put(
			"objectLayoutBoxId", ObjectLayoutRow::getObjectLayoutBoxId);
		attributeSetterBiConsumers.put(
			"objectLayoutBoxId",
			(BiConsumer<ObjectLayoutRow, Long>)
				ObjectLayoutRow::setObjectLayoutBoxId);
		attributeGetterFunctions.put("priority", ObjectLayoutRow::getPriority);
		attributeSetterBiConsumers.put(
			"priority",
			(BiConsumer<ObjectLayoutRow, Integer>)ObjectLayoutRow::setPriority);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@Override
	public long getObjectLayoutRowId() {
		return _objectLayoutRowId;
	}

	@Override
	public void setObjectLayoutRowId(long objectLayoutRowId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectLayoutRowId = objectLayoutRowId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public long getObjectLayoutBoxId() {
		return _objectLayoutBoxId;
	}

	@Override
	public void setObjectLayoutBoxId(long objectLayoutBoxId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectLayoutBoxId = objectLayoutBoxId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalObjectLayoutBoxId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("objectLayoutBoxId"));
	}

	@Override
	public int getPriority() {
		return _priority;
	}

	@Override
	public void setPriority(int priority) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_priority = priority;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(ObjectLayoutRow.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), ObjectLayoutRow.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public ObjectLayoutRow toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, ObjectLayoutRow>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		ObjectLayoutRowImpl objectLayoutRowImpl = new ObjectLayoutRowImpl();

		objectLayoutRowImpl.setMvccVersion(getMvccVersion());
		objectLayoutRowImpl.setUuid(getUuid());
		objectLayoutRowImpl.setObjectLayoutRowId(getObjectLayoutRowId());
		objectLayoutRowImpl.setCompanyId(getCompanyId());
		objectLayoutRowImpl.setUserId(getUserId());
		objectLayoutRowImpl.setUserName(getUserName());
		objectLayoutRowImpl.setCreateDate(getCreateDate());
		objectLayoutRowImpl.setModifiedDate(getModifiedDate());
		objectLayoutRowImpl.setObjectLayoutBoxId(getObjectLayoutBoxId());
		objectLayoutRowImpl.setPriority(getPriority());

		objectLayoutRowImpl.resetOriginalValues();

		return objectLayoutRowImpl;
	}

	@Override
	public ObjectLayoutRow cloneWithOriginalValues() {
		ObjectLayoutRowImpl objectLayoutRowImpl = new ObjectLayoutRowImpl();

		objectLayoutRowImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		objectLayoutRowImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		objectLayoutRowImpl.setObjectLayoutRowId(
			this.<Long>getColumnOriginalValue("objectLayoutRowId"));
		objectLayoutRowImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		objectLayoutRowImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		objectLayoutRowImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		objectLayoutRowImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		objectLayoutRowImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		objectLayoutRowImpl.setObjectLayoutBoxId(
			this.<Long>getColumnOriginalValue("objectLayoutBoxId"));
		objectLayoutRowImpl.setPriority(
			this.<Integer>getColumnOriginalValue("priority"));

		return objectLayoutRowImpl;
	}

	@Override
	public int compareTo(ObjectLayoutRow objectLayoutRow) {
		long primaryKey = objectLayoutRow.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof ObjectLayoutRow)) {
			return false;
		}

		ObjectLayoutRow objectLayoutRow = (ObjectLayoutRow)object;

		long primaryKey = objectLayoutRow.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<ObjectLayoutRow> toCacheModel() {
		ObjectLayoutRowCacheModel objectLayoutRowCacheModel =
			new ObjectLayoutRowCacheModel();

		objectLayoutRowCacheModel.mvccVersion = getMvccVersion();

		objectLayoutRowCacheModel.uuid = getUuid();

		String uuid = objectLayoutRowCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			objectLayoutRowCacheModel.uuid = null;
		}

		objectLayoutRowCacheModel.objectLayoutRowId = getObjectLayoutRowId();

		objectLayoutRowCacheModel.companyId = getCompanyId();

		objectLayoutRowCacheModel.userId = getUserId();

		objectLayoutRowCacheModel.userName = getUserName();

		String userName = objectLayoutRowCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			objectLayoutRowCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			objectLayoutRowCacheModel.createDate = createDate.getTime();
		}
		else {
			objectLayoutRowCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			objectLayoutRowCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			objectLayoutRowCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		objectLayoutRowCacheModel.objectLayoutBoxId = getObjectLayoutBoxId();

		objectLayoutRowCacheModel.priority = getPriority();

		return objectLayoutRowCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<ObjectLayoutRow, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<ObjectLayoutRow, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectLayoutRow, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((ObjectLayoutRow)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<ObjectLayoutRow, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<ObjectLayoutRow, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectLayoutRow, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((ObjectLayoutRow)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, ObjectLayoutRow>
			_escapedModelProxyProviderFunction = _getProxyProviderFunction();

	}

	private long _mvccVersion;
	private String _uuid;
	private long _objectLayoutRowId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _objectLayoutBoxId;
	private int _priority;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<ObjectLayoutRow, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((ObjectLayoutRow)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put("objectLayoutRowId", _objectLayoutRowId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("objectLayoutBoxId", _objectLayoutBoxId);
		_columnOriginalValues.put("priority", _priority);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("objectLayoutRowId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("userName", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("objectLayoutBoxId", 256L);

		columnBitmasks.put("priority", 512L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private ObjectLayoutRow _escapedModel;

}