/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.language;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.portal.kernel.util.HashMapBuilder;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

/**
 * @author Brian Wing Shun Chan
 * @author Marco Leo
 */
public class ObjectResourceBundle extends ResourceBundle {

	public ObjectResourceBundle(
		Locale locale, ObjectDefinition objectDefinition) {

		_map = HashMapBuilder.put(
			"model.resource." + objectDefinition.getResourceName(),
			objectDefinition.getPluralLabel(locale)
		).put(
			"model.resource.com.liferay.object.model.ObjectDefinition#" +
				objectDefinition.getObjectDefinitionId(),
			objectDefinition.getLabel(locale)
		).build();
	}

	@Override
	public Enumeration<String> getKeys() {
		return Collections.enumeration(_map.keySet());
	}

	@Override
	protected Object handleGetObject(String key) {
		return _map.get(key);
	}

	private final Map<String, String> _map;

}