/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.model.listener;

import com.liferay.object.action.engine.ObjectActionEngine;
import com.liferay.object.model.ObjectEntry;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class ObjectEntryModelListener
extends BaseModelListener<ObjectEntry> {
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private ObjectActionEngine _objectActionEngine;

    public void onAfterCreate(ObjectEntry objectEntry) throws ModelListenerException {
        this._executeObjectActions("onAfterAdd", null, objectEntry);
    }

    public void onAfterRemove(ObjectEntry objectEntry) throws ModelListenerException {
        this._executeObjectActions("onAfterDelete", null, objectEntry);
    }

    public void onAfterUpdate(ObjectEntry originalObjectEntry, ObjectEntry objectEntry) throws ModelListenerException {
        this._executeObjectActions("onAfterUpdate", originalObjectEntry, objectEntry);
    }

    private void _executeObjectActions(String objectActionTriggerKey, ObjectEntry originalObjectEntry, ObjectEntry objectEntry) throws ModelListenerException {
        try {
            long userId = PrincipalThreadLocal.getUserId();
            if (userId == 0L) {
                userId = objectEntry.getUserId();
            }
            this._objectActionEngine.executeObjectActions(objectEntry.getModelClassName(), objectEntry.getCompanyId(), objectActionTriggerKey, this._getPayloadJSONObject(objectActionTriggerKey, originalObjectEntry, objectEntry), userId);
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    private JSONObject _getPayloadJSONObject(String objectActionTriggerKey, ObjectEntry originalObjectEntry, ObjectEntry objectEntry) throws JSONException {
        return JSONUtil.put((String)"objectActionTriggerKey", (Object)objectActionTriggerKey).put("objectEntry", this._jsonFactory.createJSONObject(objectEntry.toString()).put("values", (Object)objectEntry.getValues())).put("originalObjectEntry", () -> {
            if (originalObjectEntry != null) {
                return this._jsonFactory.createJSONObject(originalObjectEntry.toString()).put("values", (Object)originalObjectEntry.getValues());
            }
            return null;
        });
    }
}

