/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.object.model.ObjectFolder;
import com.liferay.object.service.ObjectFolderLocalService;
import com.liferay.object.service.persistence.ObjectFolderPersistence;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class ObjectFolderLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
IdentifiableOSGiService,
ObjectFolderLocalService {
    protected ObjectFolderLocalService objectFolderLocalService;
    @Reference
    protected ObjectFolderPersistence objectFolderPersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(ObjectFolderLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public ObjectFolder addObjectFolder(ObjectFolder objectFolder) {
        objectFolder.setNew(true);
        return (ObjectFolder)this.objectFolderPersistence.update((BaseModel)objectFolder);
    }

    @Transactional(enabled=false)
    public ObjectFolder createObjectFolder(long objectFolderId) {
        return this.objectFolderPersistence.create(objectFolderId);
    }

    @Indexable(type=IndexableType.DELETE)
    public ObjectFolder deleteObjectFolder(long objectFolderId) throws PortalException {
        return this.objectFolderPersistence.remove(objectFolderId);
    }

    @Indexable(type=IndexableType.DELETE)
    public ObjectFolder deleteObjectFolder(ObjectFolder objectFolder) throws PortalException {
        return (ObjectFolder)this.objectFolderPersistence.remove((BaseModel)objectFolder);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.objectFolderPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(ObjectFolder.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.objectFolderPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.objectFolderPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.objectFolderPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.objectFolderPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.objectFolderPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public ObjectFolder fetchObjectFolder(long objectFolderId) {
        return this.objectFolderPersistence.fetchByPrimaryKey(objectFolderId);
    }

    public ObjectFolder fetchObjectFolderByUuidAndCompanyId(String uuid, long companyId) {
        return this.objectFolderPersistence.fetchByUuid_C_First(uuid, companyId, null);
    }

    public ObjectFolder fetchObjectFolderByExternalReferenceCode(String externalReferenceCode, long companyId) {
        return this.objectFolderPersistence.fetchByERC_C(externalReferenceCode, companyId);
    }

    public ObjectFolder getObjectFolderByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        return this.objectFolderPersistence.findByERC_C(externalReferenceCode, companyId);
    }

    public ObjectFolder getObjectFolder(long objectFolderId) throws PortalException {
        return this.objectFolderPersistence.findByPrimaryKey(objectFolderId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.objectFolderLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(ObjectFolder.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("objectFolderId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.objectFolderLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(ObjectFolder.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("objectFolderId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.objectFolderLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(ObjectFolder.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("objectFolderId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<ObjectFolder>(){

            public void performAction(ObjectFolder objectFolder) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)objectFolder);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)ObjectFolder.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.objectFolderPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement ObjectFolderLocalServiceImpl#deleteObjectFolder(ObjectFolder) to avoid orphaned data");
        }
        return this.objectFolderLocalService.deleteObjectFolder((ObjectFolder)persistedModel);
    }

    public BasePersistence<ObjectFolder> getBasePersistence() {
        return this.objectFolderPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.objectFolderPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public ObjectFolder getObjectFolderByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        return this.objectFolderPersistence.findByUuid_C_First(uuid, companyId, null);
    }

    public List<ObjectFolder> getObjectFolders(int start, int end) {
        return this.objectFolderPersistence.findAll(start, end);
    }

    public int getObjectFoldersCount() {
        return this.objectFolderPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectFolder updateObjectFolder(ObjectFolder objectFolder) {
        return (ObjectFolder)this.objectFolderPersistence.update((BaseModel)objectFolder);
    }

    @Deactivate
    protected void deactivate() {
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{ObjectFolderLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.objectFolderLocalService = (ObjectFolderLocalService)aopProxy;
    }

    public String getOSGiServiceIdentifier() {
        return ObjectFolderLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return ObjectFolder.class;
    }

    protected String getModelClassName() {
        return ObjectFolder.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.objectFolderPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

