/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.field.business.type;

import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.field.render.ObjectFieldRenderingContext;
import com.liferay.object.internal.field.business.type.BaseObjectFieldBusinessType;
import com.liferay.object.model.ObjectField;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.extension.PropertyDefinition;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"object.field.business.type.key=LongInteger"}, service={ObjectFieldBusinessType.class})
public class LongIntegerObjectFieldBusinessType
extends BaseObjectFieldBusinessType {
    @Reference
    private Language _language;

    public Set<String> getAllowedObjectFieldSettingsNames() {
        return SetUtil.fromArray((Object[])new String[]{"defaultValue", "defaultValueType"});
    }

    public String getDBType() {
        return "Long";
    }

    public String getDDMFormFieldTypeName() {
        return "numeric";
    }

    public String getDescription(Locale locale) {
        return this._language.get(locale, "add-a-long-integer-up-to-16-digits");
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "long-integer");
    }

    public String getName() {
        return "LongInteger";
    }

    @Override
    public Map<String, Object> getProperties(ObjectField objectField, ObjectFieldRenderingContext objectFieldRenderingContext) throws PortalException {
        return HashMapBuilder.put((Object)"dataType", (Object)"integer").putAll(super.getProperties(objectField, objectFieldRenderingContext)).build();
    }

    public PropertyDefinition.PropertyType getPropertyType() {
        return PropertyDefinition.PropertyType.LONG;
    }

    public void validateObjectFieldSettingsDefaultValue(ObjectField objectField, Map<String, String> objectFieldSettingsValuesMap) throws PortalException {
        if (objectFieldSettingsValuesMap.isEmpty()) {
            return;
        }
        super.validateObjectFieldSettingsDefaultValue(objectField, objectFieldSettingsValuesMap);
        if (Objects.equals(objectFieldSettingsValuesMap.get("defaultValueType"), "expressionBuilder")) {
            return;
        }
        String defaultValue = objectFieldSettingsValuesMap.get("defaultValue");
        if (Validator.isNull((String)defaultValue)) {
            return;
        }
        if (defaultValue.startsWith("-")) {
            defaultValue = defaultValue.substring(1);
        }
        this.validateMaxLength(16, "defaultValue", defaultValue);
    }
}

