/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.upgrade.v2_1_0;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;

public class ObjectFieldBusinessTypeUpgradeProcess
extends UpgradeProcess {
    private static final Map<String, String> _objectFieldBusinessTypes = HashMapBuilder.put((Object)"BigDecimal", (Object)"PrecisionDecimal").put((Object)"Boolean", (Object)"Boolean").put((Object)"Clob", (Object)"LongText").put((Object)"Date", (Object)"Date").put((Object)"Double", (Object)"Decimal").put((Object)"Integer", (Object)"Integer").put((Object)"Long", (Object)"LongInteger").put((Object)"String", (Object)"Text").build();

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select * from ObjectField");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update ObjectField set businessType = ? where objectFieldId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                String dbType = resultSet.getString("dbType");
                if (StringUtil.equals((String)dbType, (String)"String") && Validator.isNotNull((Long)resultSet.getLong("listTypeDefinitionId"))) {
                    preparedStatement2.setString(1, "Picklist");
                } else if (StringUtil.equals((String)dbType, (String)"Long") && Validator.isNotNull((String)resultSet.getString("relationshipType"))) {
                    preparedStatement2.setString(1, "Relationship");
                } else {
                    preparedStatement2.setString(1, _objectFieldBusinessTypes.get(dbType));
                }
                preparedStatement2.setLong(2, resultSet.getLong("objectFieldId"));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }
}

