/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.object.entry.util.ObjectEntryThreadLocal;
import com.liferay.object.internal.uad.constants.ObjectUADConstants;
import com.liferay.object.internal.uad.util.ObjectEntryUADUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;

public class ObjectEntryUADAnonymizer
extends DynamicQueryUADAnonymizer<ObjectEntry> {
    private final AssetEntryLocalService _assetEntryLocalService;
    private final ObjectDefinition _objectDefinition;
    private final ObjectEntryLocalService _objectEntryLocalService;
    private final ResourcePermissionLocalService _resourcePermissionLocalService;

    public ObjectEntryUADAnonymizer(AssetEntryLocalService assetEntryLocalService, ObjectDefinition objectDefinition, ObjectEntryLocalService objectEntryLocalService, ResourcePermissionLocalService resourcePermissionLocalService) {
        this._assetEntryLocalService = assetEntryLocalService;
        this._objectDefinition = objectDefinition;
        this._objectEntryLocalService = objectEntryLocalService;
        this._resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void autoAnonymize(ObjectEntry objectEntry, long userId, User anonymousUser) {
        if (objectEntry.getUserId() == userId) {
            objectEntry.setUserId(anonymousUser.getUserId());
            objectEntry.setUserName(anonymousUser.getFullName());
        }
        if (objectEntry.getStatusByUserId() == userId) {
            objectEntry.setStatusByUserId(anonymousUser.getUserId());
            objectEntry.setStatusByUserName(anonymousUser.getFullName());
        }
        objectEntry = this._objectEntryLocalService.updateObjectEntry(objectEntry);
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(this._objectDefinition.getClassName(), objectEntry.getObjectEntryId());
        if (assetEntry != null && assetEntry.getUserId() == userId) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this._assetEntryLocalService.updateAssetEntry(assetEntry);
        }
        for (ResourcePermission resourcePermission : this._resourcePermissionLocalService.getResourcePermissions(objectEntry.getCompanyId(), this._objectDefinition.getClassName(), 4, String.valueOf(objectEntry.getPrimaryKey()))) {
            if (resourcePermission.getOwnerId() != userId) continue;
            resourcePermission.setOwnerId(anonymousUser.getUserId());
            this._resourcePermissionLocalService.updateResourcePermission(resourcePermission);
        }
    }

    public void delete(ObjectEntry objectEntry) throws PortalException {
        try (SafeCloseable safeCloseable = ObjectEntryThreadLocal.setDisassociateRelatedModelsWithSafeCloseable((boolean)true);){
            this._objectEntryLocalService.deleteObjectEntry(objectEntry);
        }
    }

    public Class<ObjectEntry> getTypeClass() {
        return ObjectEntry.class;
    }

    public String getTypeKey() {
        return this._objectDefinition.getClassName();
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return ObjectEntryUADUtil.addActionableDynamicQueryCriteria(this._objectEntryLocalService.getActionableDynamicQuery(), this._objectDefinition.getObjectDefinitionId());
    }

    protected String[] doGetUserIdFieldNames() {
        return ObjectUADConstants.USER_ID_FIELD_NAMES_OBJECT_ENTRY;
    }

    protected ActionableDynamicQuery getActionableDynamicQuery(long userId) {
        return ObjectEntryUADUtil.addActionableDynamicQueryCriteria(this.doGetActionableDynamicQuery(), this.doGetUserIdFieldNames(), userId);
    }
}

