/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.object.model.ObjectLayout;
import com.liferay.object.service.ObjectLayoutLocalService;
import com.liferay.object.service.persistence.ObjectLayoutPersistence;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class ObjectLayoutLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
IdentifiableOSGiService,
ObjectLayoutLocalService {
    protected ObjectLayoutLocalService objectLayoutLocalService;
    @Reference
    protected ObjectLayoutPersistence objectLayoutPersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(ObjectLayoutLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public ObjectLayout addObjectLayout(ObjectLayout objectLayout) {
        objectLayout.setNew(true);
        return (ObjectLayout)this.objectLayoutPersistence.update((BaseModel)objectLayout);
    }

    @Transactional(enabled=false)
    public ObjectLayout createObjectLayout(long objectLayoutId) {
        return this.objectLayoutPersistence.create(objectLayoutId);
    }

    @Indexable(type=IndexableType.DELETE)
    public ObjectLayout deleteObjectLayout(long objectLayoutId) throws PortalException {
        return this.objectLayoutPersistence.remove(objectLayoutId);
    }

    @Indexable(type=IndexableType.DELETE)
    public ObjectLayout deleteObjectLayout(ObjectLayout objectLayout) throws PortalException {
        return (ObjectLayout)this.objectLayoutPersistence.remove((BaseModel)objectLayout);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.objectLayoutPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(ObjectLayout.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.objectLayoutPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.objectLayoutPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.objectLayoutPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.objectLayoutPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.objectLayoutPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public ObjectLayout fetchObjectLayout(long objectLayoutId) {
        return this.objectLayoutPersistence.fetchByPrimaryKey(objectLayoutId);
    }

    public ObjectLayout fetchObjectLayoutByUuidAndCompanyId(String uuid, long companyId) {
        return this.objectLayoutPersistence.fetchByUuid_C_First(uuid, companyId, null);
    }

    public ObjectLayout getObjectLayout(long objectLayoutId) throws PortalException {
        return this.objectLayoutPersistence.findByPrimaryKey(objectLayoutId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.objectLayoutLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(ObjectLayout.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("objectLayoutId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.objectLayoutLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(ObjectLayout.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("objectLayoutId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.objectLayoutLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(ObjectLayout.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("objectLayoutId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<ObjectLayout>(){

            public void performAction(ObjectLayout objectLayout) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)objectLayout);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)ObjectLayout.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.objectLayoutPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement ObjectLayoutLocalServiceImpl#deleteObjectLayout(ObjectLayout) to avoid orphaned data");
        }
        return this.objectLayoutLocalService.deleteObjectLayout((ObjectLayout)persistedModel);
    }

    public BasePersistence<ObjectLayout> getBasePersistence() {
        return this.objectLayoutPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.objectLayoutPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public ObjectLayout getObjectLayoutByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        return this.objectLayoutPersistence.findByUuid_C_First(uuid, companyId, null);
    }

    public List<ObjectLayout> getObjectLayouts(int start, int end) {
        return this.objectLayoutPersistence.findAll(start, end);
    }

    public int getObjectLayoutsCount() {
        return this.objectLayoutPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectLayout updateObjectLayout(ObjectLayout objectLayout) {
        return (ObjectLayout)this.objectLayoutPersistence.update((BaseModel)objectLayout);
    }

    @Deactivate
    protected void deactivate() {
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{ObjectLayoutLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.objectLayoutLocalService = (ObjectLayoutLocalService)aopProxy;
    }

    public String getOSGiServiceIdentifier() {
        return ObjectLayoutLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return ObjectLayout.class;
    }

    protected String getModelClassName() {
        return ObjectLayout.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.objectLayoutPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

