/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.upgrade.v10_8_1;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ObjectEntryAssetEntryTitleUpgradeProcess
extends UpgradeProcess {
    private final ClassNameLocalService _classNameLocalService;
    private final Localization _localization;

    public ObjectEntryAssetEntryTitleUpgradeProcess(ClassNameLocalService classNameLocalService, Localization localization) {
        this._classNameLocalService = classNameLocalService;
        this._localization = localization;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doUpgrade() throws Exception {
        HashMap<Long, ObjectEntryInfo> objectEntryInfos = new HashMap<Long, ObjectEntryInfo>();
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(SQLTransformer.transform((String)StringBundler.concat((String[])new String[]{"select ObjectDefinition.className, ", "ObjectDefinition.dbTableName, ", "ObjectDefinition.pkObjectFieldDBColumnName, ", "ObjectField.dbColumnName from ObjectDefinition left ", "join ObjectField on ", "ObjectDefinition.titleObjectFieldId = ", "ObjectField.objectFieldId where ", "ObjectDefinition.enableLocalization = [$TRUE$] and ", "ObjectField.localized = [$TRUE$]"})));
             ResultSet resultSet1 = preparedStatement1.executeQuery();){
            while (resultSet1.next()) {
                String dbColumnName = resultSet1.getString("dbColumnName");
                String dbTableName = resultSet1.getString("dbTableName") + "_l";
                PreparedStatement preparedStatement2 = this.connection.prepareStatement(SQLTransformer.transform((String)StringBundler.concat((String[])new String[]{"select ObjectEntry.objectEntryId, ", "ObjectEntry.defaultLanguageId, ", dbTableName, ".languageId, ", dbTableName, ".", dbColumnName, " from ObjectEntry inner join ", dbTableName, " on ObjectEntry.objectEntryId = ", dbTableName, ".", resultSet1.getString("pkObjectFieldDBColumnName")})));
                try {
                    ResultSet resultSet2 = preparedStatement2.executeQuery();
                    try {
                        while (resultSet2.next()) {
                            long objectEntryId = resultSet2.getLong("objectEntryId");
                            ObjectEntryInfo objectEntryInfo = (ObjectEntryInfo)objectEntryInfos.get(objectEntryId);
                            if (objectEntryInfo == null) {
                                objectEntryInfo = new ObjectEntryInfo(resultSet1.getString("className"), resultSet2.getString("defaultLanguageId"));
                                objectEntryInfos.put(objectEntryId, objectEntryInfo);
                            }
                            objectEntryInfo.putTitle(LocaleUtil.fromLanguageId((String)resultSet2.getString("languageId")), resultSet2.getString(dbColumnName));
                        }
                    }
                    finally {
                        if (resultSet2 == null) continue;
                        resultSet2.close();
                    }
                }
                finally {
                    if (preparedStatement2 == null) continue;
                    preparedStatement2.close();
                }
            }
        }
        try (PreparedStatement preparedStatement3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)StringBundler.concat((String[])new String[]{"update AssetEntry set mimeType = '", "text/html", "', title = ? where classNameId = ? and classPK = ", "?"}));){
            for (Map.Entry entry : objectEntryInfos.entrySet()) {
                ObjectEntryInfo objectEntryInfo = (ObjectEntryInfo)entry.getValue();
                preparedStatement3.setString(1, this._localization.getXml(LocalizedMapUtil.getLanguageIdMap(objectEntryInfo._titleMap), objectEntryInfo._defaultLanguageId, "title"));
                preparedStatement3.setLong(2, this._classNameLocalService.getClassNameId(objectEntryInfo._className));
                preparedStatement3.setLong(3, (Long)entry.getKey());
                preparedStatement3.addBatch();
            }
            preparedStatement3.executeBatch();
            return;
        }
    }

    private static class ObjectEntryInfo {
        private final String _className;
        private final String _defaultLanguageId;
        private Map<Locale, String> _titleMap = new HashMap<Locale, String>();

        public ObjectEntryInfo(String className, String defaultLanguageId) {
            this._className = className;
            this._defaultLanguageId = defaultLanguageId;
        }

        public void putTitle(Locale locale, String title) {
            this._titleMap.put(locale, title);
        }
    }
}

