/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.system.model.listener;

import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.object.action.engine.ObjectActionEngine;
import com.liferay.object.action.util.ObjectActionThreadLocal;
import com.liferay.object.entry.util.ObjectEntryThreadLocal;
import com.liferay.object.field.util.ObjectFieldUtil;
import com.liferay.object.internal.entry.util.ObjectEntryUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectValidationRuleLocalService;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.extension.EntityExtensionThreadLocal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class SystemObjectDefinitionManagerModelListener<T extends BaseModel<T>>
extends BaseModelListener<T> {
    private final DDMExpressionFactory _ddmExpressionFactory;
    private final DTOConverterRegistry _dtoConverterRegistry;
    private final JSONFactory _jsonFactory;
    private final Class<?> _modelClass;
    private final ObjectActionEngine _objectActionEngine;
    private final ObjectDefinitionLocalService _objectDefinitionLocalService;
    private final ObjectEntryLocalService _objectEntryLocalService;
    private final ObjectFieldLocalService _objectFieldLocalService;
    private final ObjectValidationRuleLocalService _objectValidationRuleLocalService;
    private final SystemObjectDefinitionManager _systemObjectDefinitionManager;
    private final UserLocalService _userLocalService;

    public SystemObjectDefinitionManagerModelListener(DDMExpressionFactory ddmExpressionFactory, DTOConverterRegistry dtoConverterRegistry, JSONFactory jsonFactory, Class<T> modelClass, ObjectActionEngine objectActionEngine, ObjectDefinitionLocalService objectDefinitionLocalService, ObjectEntryLocalService objectEntryLocalService, ObjectFieldLocalService objectFieldLocalService, ObjectValidationRuleLocalService objectValidationRuleLocalService, SystemObjectDefinitionManager systemObjectDefinitionManager, UserLocalService userLocalService) {
        this._ddmExpressionFactory = ddmExpressionFactory;
        this._dtoConverterRegistry = dtoConverterRegistry;
        this._jsonFactory = jsonFactory;
        this._modelClass = modelClass;
        this._objectActionEngine = objectActionEngine;
        this._objectDefinitionLocalService = objectDefinitionLocalService;
        this._objectEntryLocalService = objectEntryLocalService;
        this._objectFieldLocalService = objectFieldLocalService;
        this._objectValidationRuleLocalService = objectValidationRuleLocalService;
        this._systemObjectDefinitionManager = systemObjectDefinitionManager;
        this._userLocalService = userLocalService;
    }

    public Class<?> getModelClass() {
        return this._modelClass;
    }

    public void onAfterCreate(T baseModel) throws ModelListenerException {
        ObjectActionThreadLocal.setSkipObjectActionExecution((boolean)true);
        boolean clearObjectEntryIdsMap = ObjectActionThreadLocal.isClearObjectEntryIdsMap();
        try {
            if (clearObjectEntryIdsMap) {
                ObjectActionThreadLocal.clearObjectEntryIdsMap();
            }
            ObjectActionThreadLocal.setClearObjectEntryIdsMap((boolean)false);
            this._executeObjectActions("onAfterAdd", null, (BaseModel)baseModel.clone());
        }
        finally {
            ObjectActionThreadLocal.setClearObjectEntryIdsMap((boolean)clearObjectEntryIdsMap);
        }
        TransactionCommitCallbackUtil.registerCallback(() -> {
            ObjectActionThreadLocal.setSkipObjectActionExecution((boolean)false);
            return null;
        });
    }

    public void onAfterRemove(T baseModel) throws ModelListenerException {
        ObjectActionThreadLocal.clearObjectEntryIdsMap();
        this._executeObjectActions("onAfterDelete", baseModel, baseModel);
    }

    public void onAfterUpdate(T originalBaseModel, T baseModel) throws ModelListenerException {
        if (ObjectActionThreadLocal.isSkipObjectActionExecution()) {
            return;
        }
        this._executeObjectActions("onAfterUpdate", originalBaseModel, (BaseModel)baseModel.clone());
    }

    public void onBeforeCreate(T model) throws ModelListenerException {
        this._validateSystemObject(null, model);
    }

    public void onBeforeRemove(T baseModel) throws ModelListenerException {
        try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setProductionModeWithSafeCloseable();){
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinitionByClassName(this._getCompanyId(baseModel), this._modelClass.getName());
            if (objectDefinition == null) {
                return;
            }
            EntityExtensionThreadLocal.setExtendedProperties((Map)HashMapBuilder.putAll((Map)this._objectEntryLocalService.getExtensionDynamicObjectDefinitionTableValues(objectDefinition, GetterUtil.getLong((Object)baseModel.getPrimaryKeyObj()))).putAll(EntityExtensionThreadLocal.getExtendedProperties()).build());
            this._objectEntryLocalService.deleteExtensionDynamicObjectDefinitionTableValues(objectDefinition, GetterUtil.getLong((Object)baseModel.getPrimaryKeyObj()));
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    public void onBeforeUpdate(T originalModel, T model) throws ModelListenerException {
        this._validateSystemObject(originalModel, model);
    }

    private void _executeObjectActions(String objectActionTriggerKey, T originalBaseModel, T baseModel) throws ModelListenerException {
        try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setProductionModeWithSafeCloseable();){
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinitionByClassName(this._getCompanyId(baseModel), this._modelClass.getName());
            if (objectDefinition == null) {
                return;
            }
            long userId = this._getUserId(baseModel);
            this._objectActionEngine.executeObjectActions(this._modelClass.getName(), this._getCompanyId(baseModel), objectActionTriggerKey, () -> ObjectEntryUtil.getPayloadJSONObject(baseModel, this._dtoConverterRegistry, this._jsonFactory, objectActionTriggerKey, objectDefinition, originalBaseModel, this._systemObjectDefinitionManager, userId), userId);
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    private long _getCompanyId(T baseModel) {
        Map functions = baseModel.getAttributeGetterFunctions();
        Function function = (Function)functions.get("companyId");
        if (function == null) {
            throw new IllegalArgumentException("Base model does not have a company ID column");
        }
        return (Long)function.apply(baseModel);
    }

    private long _getUserId(T baseModel) {
        long userId = PrincipalThreadLocal.getUserId();
        if (userId != 0L) {
            return userId;
        }
        Map functions = baseModel.getAttributeGetterFunctions();
        Function function = (Function)functions.get("userId");
        if (function == null) {
            throw new IllegalArgumentException("Base model does not have a user ID column");
        }
        return (Long)function.apply(baseModel);
    }

    private void _validateReadOnlyObjectFields(T originalModel, T model, ObjectDefinition objectDefinition) throws PortalException {
        if (EntityExtensionThreadLocal.getExtendedProperties() == null) {
            return;
        }
        List objectFields = this._objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId());
        HashMap extendedProperties = new HashMap(EntityExtensionThreadLocal.getExtendedProperties());
        if (originalModel == null) {
            ObjectFieldUtil.validateReadOnlyObjectFields((DDMExpressionFactory)this._ddmExpressionFactory, new HashMap(), (List)objectFields, extendedProperties);
            ObjectEntryThreadLocal.setSkipReadOnlyObjectFieldsValidation((boolean)true);
            return;
        }
        ObjectFieldUtil.validateReadOnlyObjectFields((DDMExpressionFactory)this._ddmExpressionFactory, (Map)HashMapBuilder.putAll((Map)originalModel.getModelAttributes()).putAll(this._objectEntryLocalService.getExtensionDynamicObjectDefinitionTableValues(objectDefinition, GetterUtil.getLong((Object)model.getPrimaryKeyObj()))).build(), (List)objectFields, extendedProperties);
        ObjectEntryThreadLocal.setSkipReadOnlyObjectFieldsValidation((boolean)true);
    }

    private void _validateSystemObject(T originalModel, T model) throws ModelListenerException {
        try {
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinitionByClassName(this._getCompanyId(model), this._modelClass.getName());
            if (objectDefinition == null) {
                return;
            }
            long userId = this._getUserId(model);
            this._validateReadOnlyObjectFields(originalModel, model, objectDefinition);
            int count = this._objectValidationRuleLocalService.getObjectValidationRulesCount(objectDefinition.getObjectDefinitionId(), true);
            if (count > 0) {
                this._objectValidationRuleLocalService.validate(model, objectDefinition.getObjectDefinitionId(), ObjectEntryUtil.getPayloadJSONObject(model, this._dtoConverterRegistry, this._jsonFactory, null, objectDefinition, originalModel, this._systemObjectDefinitionManager, userId), userId);
            }
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }
}

