/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.search.spi.model.index.contributor;

import com.liferay.object.model.ObjectEntryFolder;
import com.liferay.object.service.ObjectEntryFolderLocalService;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.object.model.ObjectEntryFolder"}, service={ModelDocumentContributor.class})
public class ObjectEntryFolderModelDocumentContributor
implements ModelDocumentContributor<ObjectEntryFolder> {
    @Reference
    private ObjectEntryFolderLocalService _objectEntryFolderLocalService;

    public void contribute(Document document, ObjectEntryFolder objectEntryFolder) {
        document.addText("description", objectEntryFolder.getDescription());
        document.addKeyword("folderId", objectEntryFolder.getParentObjectEntryFolderId());
        document.addText("name", objectEntryFolder.getName());
        document.addText("title", objectEntryFolder.getName());
        String[] parts = StringUtil.split((String)objectEntryFolder.getTreePath(), (char)'/');
        document.addKeyword("treePath", parts);
        document.addKeyword("cms_section", this._getCMSSection(parts));
        document.addLocalizedKeyword("localized_label", objectEntryFolder.getLabelMap(), true, true);
    }

    private String _getCMSSection(String[] parts) {
        if (parts.length <= 2) {
            return "none";
        }
        ObjectEntryFolder objectEntryFolder = this._objectEntryFolderLocalService.fetchObjectEntryFolder(GetterUtil.getLong((String)parts[1]));
        if (objectEntryFolder == null) {
            return "none";
        }
        String externalReferenceCode = objectEntryFolder.getExternalReferenceCode();
        if (externalReferenceCode.equals("L_CONTENTS")) {
            return "contents";
        }
        if (externalReferenceCode.equals("L_FILES")) {
            return "files";
        }
        return "none";
    }
}

