/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectLayout;
import com.liferay.object.model.ObjectLayoutTab;
import com.liferay.object.service.base.ObjectLayoutServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=object", "json.web.service.context.path=ObjectLayout"}, service={AopService.class})
public class ObjectLayoutServiceImpl
extends ObjectLayoutServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.object.model.ObjectDefinition)")
    private ModelResourcePermission<ObjectDefinition> _objectDefinitionModelResourcePermission;
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;

    public ObjectLayout addObjectLayout(long objectDefinitionId, boolean defaultObjectLayout, Map<Locale, String> nameMap, List<ObjectLayoutTab> objectLayoutTabs) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectDefinition.getObjectDefinitionId(), "UPDATE");
        return this.objectLayoutLocalService.addObjectLayout(this.getUserId(), objectDefinitionId, defaultObjectLayout, nameMap, objectLayoutTabs);
    }

    public ObjectLayout deleteObjectLayout(long objectLayoutId) throws PortalException {
        ObjectLayout objectLayout = this.objectLayoutPersistence.findByPrimaryKey(objectLayoutId);
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectLayout.getObjectDefinitionId(), "DELETE");
        return this.objectLayoutLocalService.deleteObjectLayout(objectLayoutId);
    }

    public ObjectLayout getObjectLayout(long objectLayoutId) throws PortalException {
        ObjectLayout objectLayout = this.objectLayoutPersistence.findByPrimaryKey(objectLayoutId);
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectLayout.getObjectDefinitionId(), "VIEW");
        return this.objectLayoutLocalService.getObjectLayout(objectLayoutId);
    }

    public ObjectLayout updateObjectLayout(long objectLayoutId, boolean defaultObjectLayout, Map<Locale, String> nameMap, List<ObjectLayoutTab> objectLayoutTabs) throws PortalException {
        ObjectLayout objectLayout = this.objectLayoutPersistence.findByPrimaryKey(objectLayoutId);
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectLayout.getObjectDefinitionId(), "UPDATE");
        return this.objectLayoutLocalService.updateObjectLayout(objectLayoutId, defaultObjectLayout, nameMap, objectLayoutTabs);
    }
}

