/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.field.attachment;

import com.liferay.document.library.kernel.exception.FileExtensionException;
import com.liferay.document.library.kernel.exception.FileNameException;
import com.liferay.document.library.kernel.exception.FileSizeException;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.document.library.kernel.service.DLFolderService;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.kernel.util.DLValidator;
import com.liferay.object.configuration.ObjectConfiguration;
import com.liferay.object.field.attachment.AttachmentManager;
import com.liferay.object.field.setting.util.ObjectFieldSettingUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectFieldSettingLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypes;
import com.liferay.portal.kernel.util.Validator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.object.configuration.ObjectConfiguration"}, service={AttachmentManager.class})
public class AttachmentManagerImpl
implements AttachmentManager {
    private static final long _FILE_LENGTH_MB = 0x100000L;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DLFolderLocalService _dlFolderLocalService;
    @Reference
    private DLFolderService _dlFolderService;
    @Reference
    private DLValidator _dlValidator;
    @Reference
    private MimeTypes _mimeTypes;
    private volatile ObjectConfiguration _objectConfiguration;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectFieldSettingLocalService _objectFieldSettingLocalService;
    @Reference
    private PortletFileRepository _portletFileRepository;
    @Reference
    private UserLocalService _userLocalService;

    public String[] getAcceptedFileExtensions(long objectFieldId) {
        ObjectFieldSetting objectFieldSetting = this._objectFieldSettingLocalService.fetchObjectFieldSetting(objectFieldId, "acceptedFileExtensions");
        String value = objectFieldSetting.getValue();
        return value.split("\\s*,\\s*");
    }

    public DLFolder getDLFolder(long companyId, long groupId, long objectFieldId, ServiceContext serviceContext, long userId) throws PortalException {
        Long dlFolderId = null;
        ObjectField objectField = this._objectFieldLocalService.getObjectField(objectFieldId);
        boolean showFilesInDocumentsAndMedia = GetterUtil.getBoolean((String)ObjectFieldSettingUtil.getValue((String)"showFilesInDocumentsAndMedia", (List)objectField.getObjectFieldSettings()));
        if (showFilesInDocumentsAndMedia) {
            String storageDLFolderPath = ObjectFieldSettingUtil.getValue((String)"storageDLFolderPath", (List)objectField.getObjectFieldSettings());
            dlFolderId = this._getStorageDLFolderId(companyId, groupId, serviceContext, storageDLFolderPath);
        } else {
            ObjectDefinition objectDefinition = objectField.getObjectDefinition();
            dlFolderId = this._getRepositoryFolderId(companyId, groupId, objectDefinition.getPortletId(), serviceContext, userId);
        }
        return this._dlFolderLocalService.getDLFolder(dlFolderId.longValue());
    }

    public long getMaximumFileSize(long objectFieldId, boolean signedIn) {
        ObjectFieldSetting objectFieldSetting = this._objectFieldSettingLocalService.fetchObjectFieldSetting(objectFieldId, "maximumFileSize");
        long maximumFileSize = GetterUtil.getLong((String)objectFieldSetting.getValue());
        if (signedIn || maximumFileSize < (long)this._objectConfiguration.maximumFileSizeForGuestUsers()) {
            return maximumFileSize * 0x100000L;
        }
        return (long)this._objectConfiguration.maximumFileSizeForGuestUsers() * 0x100000L;
    }

    public FileEntry getOrAddFileEntry(long companyId, String externalReferenceCode, byte[] fileContent, String fileName, long groupId, long objectFieldId, ServiceContext serviceContext) throws Exception {
        FileEntry fileEntry = this._dlAppLocalService.fetchFileEntryByExternalReferenceCode(groupId, externalReferenceCode);
        if (fileEntry != null && companyId == fileEntry.getCompanyId()) {
            return fileEntry;
        }
        this._validateFile(fileContent, fileName, objectFieldId, serviceContext.getUserId());
        DLFolder dlFolder = this.getDLFolder(companyId, groupId, objectFieldId, serviceContext, serviceContext.getUserId());
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(fileContent);){
            FileEntry fileEntry2 = this._dlAppLocalService.addFileEntry(externalReferenceCode, serviceContext.getUserId(), dlFolder.getRepositoryId(), dlFolder.getFolderId(), DLUtil.getUniqueFileName((long)groupId, (long)dlFolder.getFolderId(), (String)fileName, (boolean)true), this._mimeTypes.getContentType((InputStream)inputStream, fileName), DLUtil.getUniqueTitle((long)groupId, (long)dlFolder.getFolderId(), (String)FileUtil.stripExtension((String)fileName)), "", null, null, (InputStream)inputStream, (long)fileContent.length, null, null, null, serviceContext);
            return fileEntry2;
        }
    }

    public FileEntry getOrAddFileEntry(long companyId, String externalReferenceCode, byte[] fileContent, String fileName, String folderExternalReferenceCode, long groupId, long objectFieldId, ServiceContext serviceContext) throws Exception {
        FileEntry fileEntry = this._dlAppLocalService.fetchFileEntryByExternalReferenceCode(groupId, externalReferenceCode);
        if (fileEntry != null && companyId == fileEntry.getCompanyId()) {
            return fileEntry;
        }
        this._validateFile(fileContent, fileName, objectFieldId, serviceContext.getUserId());
        long repositoryId = groupId;
        long folderId = 0L;
        if (Validator.isNotNull((String)folderExternalReferenceCode)) {
            DLFolder dlFolder = this._dlFolderService.getDLFolderByExternalReferenceCode(folderExternalReferenceCode, groupId);
            if (dlFolder.getCompanyId() != companyId) {
                throw new NoSuchFolderException();
            }
            repositoryId = dlFolder.getRepositoryId();
            folderId = dlFolder.getFolderId();
        }
        ServiceContext cloneServiceContext = (ServiceContext)serviceContext.clone();
        cloneServiceContext.setCompanyId(companyId);
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(fileContent);){
            this._dlValidator.validateFileSize(groupId, fileName, this._mimeTypes.getContentType((InputStream)inputStream, fileName), (long)fileContent.length);
            FileEntry fileEntry2 = this._dlAppService.addFileEntry(externalReferenceCode, repositoryId, folderId, DLUtil.getUniqueFileName((long)groupId, (long)folderId, (String)fileName, (boolean)true), this._mimeTypes.getContentType((InputStream)inputStream, fileName), DLUtil.getUniqueTitle((long)groupId, (long)folderId, (String)FileUtil.stripExtension((String)fileName)), "", null, null, (InputStream)inputStream, (long)fileContent.length, null, null, null, cloneServiceContext);
            return fileEntry2;
        }
    }

    public void validateFileExtension(String fileName, long objectFieldId) throws FileExtensionException {
        if (!ArrayUtil.contains((String[])this.getAcceptedFileExtensions(objectFieldId), (String)FileUtil.getExtension((String)fileName), (boolean)true)) {
            throw new FileExtensionException.InvalidExtension("Invalid file extension for " + fileName);
        }
    }

    public void validateFileName(String fileName) throws FileNameException {
        if (Validator.isNull((String)fileName)) {
            throw new FileNameException("File name is null");
        }
    }

    public void validateFileSize(String fileName, long fileSize, long objectFieldId, boolean signedIn) throws FileSizeException {
        long maximumFileSize = this.getMaximumFileSize(objectFieldId, signedIn);
        if (maximumFileSize > 0L && fileSize > maximumFileSize) {
            throw new FileSizeException(StringBundler.concat((Object[])new Object[]{"File ", fileName, " exceeds the maximum permitted size of ", maximumFileSize / 0x100000L, " MB"}));
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._objectConfiguration = (ObjectConfiguration)ConfigurableUtil.createConfigurable(ObjectConfiguration.class, properties);
    }

    private Repository _getRepository(long groupId, String portletId, ServiceContext serviceContext) throws PortalException {
        Repository repository = this._portletFileRepository.fetchPortletRepository(groupId, portletId);
        if (repository != null) {
            return repository;
        }
        serviceContext = (ServiceContext)serviceContext.clone();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        return this._portletFileRepository.addPortletRepository(groupId, portletId, serviceContext);
    }

    private Long _getRepositoryFolderId(long companyId, long groupId, String portletId, ServiceContext serviceContext, long userId) throws PortalException {
        Repository repository = this._getRepository(groupId, portletId, serviceContext);
        if (repository == null) {
            return null;
        }
        DLFolder dlFolder = this._dlFolderLocalService.fetchFolder(repository.getGroupId(), repository.getDlFolderId(), String.valueOf(userId));
        if (dlFolder != null) {
            return dlFolder.getFolderId();
        }
        dlFolder = this._dlFolderLocalService.addFolder(null, this._userLocalService.getGuestUserId(companyId), repository.getGroupId(), repository.getRepositoryId(), false, repository.getDlFolderId(), String.valueOf(userId), null, false, serviceContext);
        return dlFolder.getFolderId();
    }

    private Long _getStorageDLFolderId(long companyId, long groupId, ServiceContext serviceContext, String storageDLFolderPath) throws PortalException {
        long storageDLFolderId = 0L;
        for (String name : StringUtil.split((String)storageDLFolderPath, (char)'/')) {
            DLFolder dlFolder = this._dlFolderLocalService.fetchFolder(groupId, storageDLFolderId, name);
            if (dlFolder != null) {
                storageDLFolderId = dlFolder.getFolderId();
                continue;
            }
            Folder folder = this._dlAppLocalService.addFolder(null, this._userLocalService.getGuestUserId(companyId), groupId, storageDLFolderId, name, null, serviceContext);
            storageDLFolderId = folder.getFolderId();
        }
        return storageDLFolderId;
    }

    private void _validateFile(byte[] fileContent, String fileName, long objectFieldId, long userId) throws Exception {
        this.validateFileName(fileName);
        this.validateFileExtension(fileName, objectFieldId);
        User user = this._userLocalService.getUser(userId);
        this.validateFileSize(fileName, fileContent.length, objectFieldId, !user.isGuestUser());
    }
}

