/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.field.business.type;

import com.liferay.object.exception.ObjectFieldSettingValueException;
import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.field.render.ObjectFieldRenderingContext;
import com.liferay.object.internal.field.business.type.BaseObjectFieldBusinessType;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.scope.ObjectScopeProvider;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.vulcan.extension.PropertyDefinition;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"object.field.business.type.key=Attachment"}, service={ObjectFieldBusinessType.class})
public class AttachmentObjectFieldBusinessType
extends BaseObjectFieldBusinessType {
    private static final Log _log = LogFactoryUtil.getLog(AttachmentObjectFieldBusinessType.class);
    @Reference
    private Language _language;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectScopeProviderRegistry _objectScopeProviderRegistry;

    public Set<String> getAllowedObjectFieldSettingsNames() {
        return SetUtil.fromArray((Object[])new String[]{"showFilesInDocumentsAndMedia", "storageDLFolderPath"});
    }

    public String getDBType() {
        return "Long";
    }

    public String getDDMFormFieldTypeName() {
        return "attachment";
    }

    public String getDescription(Locale locale) {
        return this._language.get(locale, "upload-files-or-select-from-documents-and-media");
    }

    public Object getDisplayContextValue(ObjectField objectField, long userId, Map<String, Object> values) throws PortalException {
        if (objectField.isLocalized()) {
            return this.getLocalizedValues(objectField, userId, values);
        }
        return super.getDisplayContextValue(objectField, userId, values);
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "attachment");
    }

    public Map<String, Object> getLocalizedValues(ObjectField objectField, Long userId, Map<String, Object> values) throws PortalException {
        Map localizedValues = super.getLocalizedValues(objectField, userId, values);
        if (localizedValues == null) {
            return null;
        }
        for (Map.Entry entry : localizedValues.entrySet()) {
            localizedValues.put((String)entry.getKey(), this._getFileEntryId(entry.getValue()));
        }
        return localizedValues;
    }

    public String getName() {
        return "Attachment";
    }

    @Override
    public Map<String, Object> getProperties(ObjectField objectField, ObjectFieldRenderingContext objectFieldRenderingContext) throws PortalException {
        Map<String, Object> properties = super.getProperties(objectField, objectFieldRenderingContext);
        properties.remove("showFilesInDocumentsAndMedia");
        properties.remove("storageDLFolderPath");
        return HashMapBuilder.put((Object)"groupAware", () -> {
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectField.getObjectDefinitionId());
            ObjectScopeProvider objectScopeProvider = this._objectScopeProviderRegistry.getObjectScopeProvider(objectDefinition.getScope());
            return objectScopeProvider.isGroupAware();
        }).put((Object)"objectFieldId", (Object)objectField.getObjectFieldId()).put((Object)"portletId", (Object)objectFieldRenderingContext.getPortletId()).putAll(properties).build();
    }

    public PropertyDefinition.PropertyType getPropertyType() {
        return PropertyDefinition.PropertyType.LONG;
    }

    public Set<String> getRequiredObjectFieldSettingsNames(ObjectField objectField) {
        return SetUtil.fromArray((Object[])new String[]{"acceptedFileExtensions", "fileSource", "maximumFileSize"});
    }

    public Object getValue(ObjectField objectField, long userId, Map<String, Object> values) throws PortalException {
        return this._getFileEntryId(super.getValue(objectField, userId, values));
    }

    public boolean isLocalizable() {
        return true;
    }

    public boolean isVisible(ObjectDefinition objectDefinition) {
        return objectDefinition.isDefaultStorageType();
    }

    public void validateObjectFieldSettings(ObjectField objectField, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        BigDecimal bigDecimal;
        Map<String, String> objectFieldSettingsValues;
        block7: {
            super.validateObjectFieldSettings(objectField, objectFieldSettings);
            objectFieldSettingsValues = this.getObjectFieldSettingsValues(objectFieldSettings);
            String fileSource = objectFieldSettingsValues.get("fileSource");
            if (Objects.equals(fileSource, "documentsAndMedia")) {
                this.validateNotAllowedObjectFieldSettingNames(SetUtil.fromArray((Object[])new String[]{"showFilesInDocumentsAndMedia", "storageDLFolderPath"}), objectField.getName(), objectFieldSettingsValues);
            } else if (Objects.equals(fileSource, "userComputer")) {
                this.validateRelatedObjectFieldSettings(objectField, "showFilesInDocumentsAndMedia", "storageDLFolderPath", objectFieldSettingsValues);
            } else {
                throw new ObjectFieldSettingValueException.InvalidValue(objectField.getName(), "fileSource", fileSource);
            }
            bigDecimal = null;
            try {
                bigDecimal = new BigDecimal(objectFieldSettingsValues.get("maximumFileSize"));
            }
            catch (NumberFormatException numberFormatException) {
                if (!_log.isDebugEnabled()) break block7;
                _log.debug((Throwable)numberFormatException);
            }
        }
        if (bigDecimal == null || bigDecimal.signum() == -1) {
            throw new ObjectFieldSettingValueException.InvalidValue(objectField.getName(), "maximumFileSize", objectFieldSettingsValues.get("maximumFileSize"));
        }
    }

    private Object _getFileEntryId(Object value) throws PortalException {
        long fileEntryId = GetterUtil.getLong((Object)value);
        if (fileEntryId > 0L) {
            return fileEntryId;
        }
        if (value instanceof Map) {
            fileEntryId = MapUtil.getLong((Map)((Map)value), (String)"id");
        } else {
            String valueString = String.valueOf(value);
            if (JSONUtil.isJSONObject((String)valueString)) {
                JSONObject jsonObject = this.jsonFactory.createJSONObject(valueString);
                fileEntryId = GetterUtil.getLong((Object)jsonObject.get("id"));
            }
        }
        if (fileEntryId > 0L) {
            return fileEntryId;
        }
        return value;
    }
}

