/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.field.business.type;

import com.liferay.object.exception.ObjectEntryValuesException;
import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.field.setting.util.ObjectFieldSettingUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.object.system.SystemObjectDefinitionManagerRegistry;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.extension.PropertyDefinition;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"object.field.business.type.key=Relationship"}, service={ObjectFieldBusinessType.class})
public class RelationshipObjectFieldBusinessType
implements ObjectFieldBusinessType {
    private static final Log _log = LogFactoryUtil.getLog(RelationshipObjectFieldBusinessType.class);
    @Reference
    private Language _language;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private SystemObjectDefinitionManagerRegistry _systemObjectDefinitionManagerRegistry;

    public String getDBType() {
        return "Long";
    }

    public String getDDMFormFieldTypeName() {
        return "object-relationship";
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "relationship");
    }

    public String getName() {
        return "Relationship";
    }

    public PropertyDefinition.PropertyType getPropertyType() {
        return PropertyDefinition.PropertyType.LONG;
    }

    public Set<String> getRequiredObjectFieldSettingsNames(ObjectField objectField) {
        return SetUtil.fromArray((Object[])new String[]{"objectDefinition1ShortName", "objectRelationshipERCObjectFieldName"});
    }

    public Object getValue(ObjectField objectField, long userId, Map<String, Object> values) throws PortalException {
        String objectRelationshipERCObjectFieldName;
        String relationshipName = (String)StringUtil.split((String)objectField.getName(), (char)'_').get(1);
        if (Objects.equals(objectField.getRelationshipType(), "oneToMany") && values.containsKey(relationshipName)) {
            ObjectRelationship objectRelationship = this._objectRelationshipLocalService.fetchObjectRelationshipByObjectDefinitionId(objectField.getObjectDefinitionId(), relationshipName);
            if (objectRelationship == null) {
                return 0;
            }
            Object relatedElement = values.get(relationshipName);
            if (!(relatedElement instanceof Map)) {
                return 0;
            }
            String externalReferenceCode = MapUtil.getString((Map)((Map)values.get(relationshipName)), (String)"externalReferenceCode");
            if (Validator.isNull((String)externalReferenceCode)) {
                return 0;
            }
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId1());
            try {
                if (objectDefinition.isUnmodifiableSystemObject()) {
                    return this._getPrimaryKeyObj(externalReferenceCode, objectDefinition, 0L);
                }
                ObjectEntry objectEntry = this._objectEntryLocalService.getObjectEntry(externalReferenceCode, objectDefinition.getObjectDefinitionId());
                if (!Objects.equals(objectDefinition.getObjectDefinitionId(), objectEntry.getObjectDefinitionId())) {
                    throw new ObjectEntryValuesException.InvalidValue(objectField.getName());
                }
                return objectEntry.getObjectEntryId();
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
                return 0;
            }
        }
        PortalException portalException1 = null;
        if (values.containsKey(objectField.getName())) {
            Object value = values.get(objectField.getName());
            long valueLong = GetterUtil.getLong((Object)value);
            if (valueLong == 0L) {
                return value;
            }
            ObjectDefinition objectDefinition = this._getObjectDefinition(objectField);
            try {
                if (objectDefinition.isUnmodifiableSystemObject()) {
                    return this._getPrimaryKeyObj(null, objectDefinition, valueLong);
                }
                ObjectEntry objectEntry = this._objectEntryLocalService.getObjectEntry(valueLong);
                if (!Objects.equals(objectDefinition.getObjectDefinitionId(), objectEntry.getObjectDefinitionId())) {
                    throw new ObjectEntryValuesException.InvalidValue(objectField.getName());
                }
                return objectEntry.getObjectEntryId();
            }
            catch (PortalException portalException2) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)portalException2);
                }
                portalException1 = portalException2;
            }
        }
        if (values.containsKey(objectRelationshipERCObjectFieldName = ObjectFieldSettingUtil.getValue((String)"objectRelationshipERCObjectFieldName", (ObjectField)objectField))) {
            String externalReferenceCode = MapUtil.getString(values, (String)objectRelationshipERCObjectFieldName);
            ObjectDefinition objectDefinition = this._getObjectDefinition(objectField);
            if (objectDefinition.isUnmodifiableSystemObject()) {
                return this._getPrimaryKeyObj(externalReferenceCode, objectDefinition, 0L);
            }
            ObjectEntry objectEntry = this._objectEntryLocalService.getObjectEntry(externalReferenceCode, objectDefinition.getObjectDefinitionId());
            return objectEntry.getObjectEntryId();
        }
        if (portalException1 != null) {
            throw portalException1;
        }
        return null;
    }

    private ObjectDefinition _getObjectDefinition(ObjectField objectField) throws PortalException {
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.fetchObjectRelationshipByObjectFieldId2(objectField.getObjectFieldId());
        return this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId1());
    }

    private Object _getPrimaryKeyObj(String externalReferenceCode, ObjectDefinition objectDefinition, Long primaryKey) throws PortalException {
        SystemObjectDefinitionManager systemObjectDefinitionManager = this._systemObjectDefinitionManagerRegistry.getSystemObjectDefinitionManager(objectDefinition.getName());
        if (externalReferenceCode == null) {
            externalReferenceCode = systemObjectDefinitionManager.getBaseModelExternalReferenceCode(primaryKey.longValue());
        }
        BaseModel baseModel = systemObjectDefinitionManager.getBaseModelByExternalReferenceCode(externalReferenceCode, objectDefinition.getCompanyId());
        return baseModel.getPrimaryKeyObj();
    }
}

