/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.security.permission.resource.util;

import com.liferay.object.model.ObjectAction;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.ObjectActionLocalService;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.object.tree.Node;
import com.liferay.object.tree.ObjectDefinitionTreeFactory;
import com.liferay.object.tree.Tree;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.security.permission.ResourceActions;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectDefinitionResourcePermissionUtil {
    private static final int _INITIAL_WEIGHT = 3;
    private static final Map<ObjectDefinition, Document> _objectDefinitionResourceActionDocumentsMap = new ConcurrentHashMap<ObjectDefinition, Document>();

    public static void populateResourceActions(ObjectActionLocalService objectActionLocalService, ObjectDefinition objectDefinition, ObjectDefinitionPersistence objectDefinitionPersistence, ObjectDefinitionTreeFactory objectDefinitionTreeFactory, PortletLocalService portletLocalService, ResourceActions resourceActions, List<ObjectAction> standaloneObjectActions) throws Exception {
        if (objectDefinition.isRootDescendantNode()) {
            return;
        }
        ArrayList<String> rootDescendantNodeObjectDefinitionClassNames = new ArrayList<String>();
        Document document = ObjectDefinitionResourcePermissionUtil._readDocument(objectActionLocalService, objectDefinition, objectDefinitionPersistence, objectDefinitionTreeFactory, rootDescendantNodeObjectDefinitionClassNames, standaloneObjectActions);
        resourceActions.populateModelResources(document);
        Portlet portlet = portletLocalService.getPortletById(objectDefinition.getCompanyId(), objectDefinition.getPortletId());
        if (portlet != null) {
            resourceActions.populatePortletResource(portlet, ObjectDefinitionResourcePermissionUtil.class.getClassLoader(), document);
        }
        for (String rootDescendantNodeObjectDefinitionClassName : rootDescendantNodeObjectDefinitionClassNames) {
            resourceActions.removeModelResource(rootDescendantNodeObjectDefinitionClassName, "PERMISSIONS");
        }
        _objectDefinitionResourceActionDocumentsMap.put(objectDefinition, document);
    }

    public static void removeResourceActions(ObjectActionLocalService objectActionLocalService, ObjectDefinition objectDefinition, ObjectDefinitionPersistence objectDefinitionPersistence, ObjectDefinitionTreeFactory objectDefinitionTreeFactory, ResourceActions resourceActions) throws Exception {
        Document document = _objectDefinitionResourceActionDocumentsMap.remove(objectDefinition);
        if (document == null) {
            document = ObjectDefinitionResourcePermissionUtil._readDocument(objectActionLocalService, objectDefinition, objectDefinitionPersistence, objectDefinitionTreeFactory, new ArrayList<String>(), null);
        }
        resourceActions.removeModelResources(document);
        resourceActions.removePortletResources(document);
    }

    private static String _getObjectActionPermissionKeys(ObjectActionLocalService objectActionLocalService, long objectDefinitionId, List<ObjectAction> standaloneObjectActions) {
        String objectActionPermissionKeys = "";
        if (standaloneObjectActions == null) {
            standaloneObjectActions = objectActionLocalService.getObjectActions(objectDefinitionId, "standalone");
        }
        for (ObjectAction objectAction : standaloneObjectActions) {
            objectActionPermissionKeys = StringBundler.concat((String[])new String[]{objectActionPermissionKeys, "<action-key>", objectAction.getName(), "</action-key>"});
        }
        return objectActionPermissionKeys;
    }

    private static String _getPermissionsGuestUnsupported(ObjectDefinition objectDefinition) {
        if (!objectDefinition.isEnableComments()) {
            return "";
        }
        return "<action-key>DELETE_DISCUSSION</action-key><action-key>UPDATE_DISCUSSION</action-key>";
    }

    private static String _getPermissionsSupports(ObjectDefinition objectDefinition) {
        String permissionsSupports = "";
        if (objectDefinition.isEnableComments()) {
            permissionsSupports = StringBundler.concat((String[])new String[]{"<action-key>ADD_DISCUSSION</action-key>", "<action-key>DELETE_DISCUSSION</action-key>", "<action-key>UPDATE_DISCUSSION</action-key>"});
        }
        if (objectDefinition.isEnableObjectEntryHistory()) {
            permissionsSupports = StringBundler.concat((String[])new String[]{permissionsSupports, "<action-key>", "OBJECT_ENTRY_HISTORY", "</action-key>"});
        }
        return permissionsSupports;
    }

    private static String _getRootDescendantNodeObjectDefinitionsModelResources(ObjectActionLocalService objectActionLocalService, ObjectDefinitionPersistence objectDefinitionPersistence, ObjectDefinitionTreeFactory objectDefinitionTreeFactory, List<String> rootDescendantNodeObjectDefinitionClassNames, ObjectDefinition rootNodeObjectDefinition, List<ObjectAction> standaloneObjectActions) throws Exception {
        int weight = 3;
        Tree tree = objectDefinitionTreeFactory.create(rootNodeObjectDefinition.getObjectDefinitionId());
        Iterator iterator = tree.iterator();
        String modelResources = "";
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node.isRoot()) continue;
            ObjectDefinition rootDescendantNodeObjectDefinition = objectDefinitionPersistence.findByPrimaryKey(node.getPrimaryKey());
            rootDescendantNodeObjectDefinitionClassNames.add(rootDescendantNodeObjectDefinition.getClassName());
            String objectActionPermissionKeys = ObjectDefinitionResourcePermissionUtil._getObjectActionPermissionKeys(objectActionLocalService, node.getPrimaryKey(), standaloneObjectActions);
            if (Validator.isNull((String)objectActionPermissionKeys)) continue;
            modelResources = StringBundler.concat((Object[])new Object[]{modelResources, "<model-resource><model-name>", rootDescendantNodeObjectDefinition.getClassName(), "</model-name><portlet-ref><portlet-name>", rootNodeObjectDefinition.getPortletId(), "</portlet-name></portlet-ref><weight>", weight++, "</weight><permissions><supports>", objectActionPermissionKeys, "</supports><site-member-defaults>", "</site-member-defaults><guest-defaults>", "</guest-defaults><guest-unsupported>", objectActionPermissionKeys, "</guest-unsupported></permissions></model-resource>"});
        }
        return modelResources;
    }

    private static Document _readDocument(ObjectActionLocalService objectActionLocalService, ObjectDefinition objectDefinition, ObjectDefinitionPersistence objectDefinitionPersistence, ObjectDefinitionTreeFactory objectDefinitionTreeFactory, List<String> rootDescendantNodeObjectDefinitionClassNames, List<ObjectAction> standaloneObjectActions) throws Exception {
        String objectActionPermissionKeys = ObjectDefinitionResourcePermissionUtil._getObjectActionPermissionKeys(objectActionLocalService, objectDefinition.getObjectDefinitionId(), standaloneObjectActions);
        String resourceActionsFileName = "resource-actions/resource-actions.xml.tpl";
        if (!StringUtil.equals((String)objectDefinition.getStorageType(), (String)"default")) {
            resourceActionsFileName = "resource-actions/resource-actions-nondefault-storage-type.xml.tpl";
        }
        return SAXReaderUtil.read((String)StringUtil.replace((String)StringUtil.read((ClassLoader)ObjectDefinitionResourcePermissionUtil.class.getClassLoader(), (String)resourceActionsFileName), (String[])new String[]{"[$MODEL_NAME$]", "[$PERMISSIONS_GUEST_UNSUPPORTED$]", "[$PERMISSIONS_SUPPORTS$]", "[$PORTLET_NAME$]", "[$RESOURCE_NAME$]", "[%ROOT_DESCENDANT_NODE_OBJECT_DEFINITIONS_MODEL_RESOURCES%]"}, (String[])new String[]{objectDefinition.getClassName(), ObjectDefinitionResourcePermissionUtil._getPermissionsGuestUnsupported(objectDefinition) + objectActionPermissionKeys, ObjectDefinitionResourcePermissionUtil._getPermissionsSupports(objectDefinition) + objectActionPermissionKeys, objectDefinition.getPortletId(), objectDefinition.getResourceName(), ObjectDefinitionResourcePermissionUtil._getRootDescendantNodeObjectDefinitionsModelResources(objectActionLocalService, objectDefinitionPersistence, objectDefinitionTreeFactory, rootDescendantNodeObjectDefinitionClassNames, objectDefinition, standaloneObjectActions)}));
    }
}

