/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.upgrade.v9_0_1;

import com.liferay.object.model.ObjectFolder;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class ObjectFolderUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(ObjectFolderUpgradeProcess.class);
    private final CompanyLocalService _companyLocalService;
    private final ResourcePermissionLocalService _resourcePermissionLocalService;
    private final RoleLocalService _roleLocalService;

    public ObjectFolderUpgradeProcess(CompanyLocalService companyLocalService, ResourcePermissionLocalService resourcePermissionLocalService, RoleLocalService roleLocalService) {
        this._companyLocalService = companyLocalService;
        this._resourcePermissionLocalService = resourcePermissionLocalService;
        this._roleLocalService = roleLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._companyLocalService.forEachCompany(company -> {
            try {
                PreparedStatement preparedStatement = this.connection.prepareStatement("select objectFolderId from ObjectFolder where companyId = ? and externalReferenceCode = ?");
                preparedStatement.setLong(1, company.getCompanyId());
                preparedStatement.setString(2, "uncategorized");
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    Role guestRole = this._roleLocalService.getRole(company.getCompanyId(), "Guest");
                    this._resourcePermissionLocalService.setResourcePermissions(company.getCompanyId(), ObjectFolder.class.getName(), 4, String.valueOf(resultSet.getLong("objectFolderId")), guestRole.getRoleId(), new String[]{"VIEW"});
                }
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        });
    }
}

