/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.object.model.ObjectAction;
import com.liferay.object.service.ObjectActionLocalService;
import com.liferay.object.service.persistence.ObjectActionPersistence;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class ObjectActionLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
IdentifiableOSGiService,
ObjectActionLocalService {
    protected ObjectActionLocalService objectActionLocalService;
    @Reference
    protected ObjectActionPersistence objectActionPersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(ObjectActionLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public ObjectAction addObjectAction(ObjectAction objectAction) {
        objectAction.setNew(true);
        return (ObjectAction)this.objectActionPersistence.update((BaseModel)objectAction);
    }

    @Transactional(enabled=false)
    public ObjectAction createObjectAction(long objectActionId) {
        return this.objectActionPersistence.create(objectActionId);
    }

    @Indexable(type=IndexableType.DELETE)
    public ObjectAction deleteObjectAction(long objectActionId) throws PortalException {
        return this.objectActionPersistence.remove(objectActionId);
    }

    @Indexable(type=IndexableType.DELETE)
    public ObjectAction deleteObjectAction(ObjectAction objectAction) throws PortalException {
        return (ObjectAction)this.objectActionPersistence.remove((BaseModel)objectAction);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.objectActionPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(ObjectAction.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.objectActionPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.objectActionPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.objectActionPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.objectActionPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.objectActionPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public ObjectAction fetchObjectAction(long objectActionId) {
        return this.objectActionPersistence.fetchByPrimaryKey(objectActionId);
    }

    public ObjectAction fetchObjectActionByUuidAndCompanyId(String uuid, long companyId) {
        return this.objectActionPersistence.fetchByUuid_C_First(uuid, companyId, null);
    }

    public ObjectAction getObjectAction(long objectActionId) throws PortalException {
        return this.objectActionPersistence.findByPrimaryKey(objectActionId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.objectActionLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(ObjectAction.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("objectActionId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.objectActionLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(ObjectAction.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("objectActionId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.objectActionLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(ObjectAction.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("objectActionId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<ObjectAction>(){

            public void performAction(ObjectAction objectAction) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)objectAction);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)ObjectAction.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.objectActionPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement ObjectActionLocalServiceImpl#deleteObjectAction(ObjectAction) to avoid orphaned data");
        }
        return this.objectActionLocalService.deleteObjectAction((ObjectAction)persistedModel);
    }

    public BasePersistence<ObjectAction> getBasePersistence() {
        return this.objectActionPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.objectActionPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public ObjectAction getObjectActionByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        return this.objectActionPersistence.findByUuid_C_First(uuid, companyId, null);
    }

    public List<ObjectAction> getObjectActions(int start, int end) {
        return this.objectActionPersistence.findAll(start, end);
    }

    public int getObjectActionsCount() {
        return this.objectActionPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectAction updateObjectAction(ObjectAction objectAction) {
        return (ObjectAction)this.objectActionPersistence.update((BaseModel)objectAction);
    }

    @Deactivate
    protected void deactivate() {
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{ObjectActionLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.objectActionLocalService = (ObjectActionLocalService)aopProxy;
    }

    public String getOSGiServiceIdentifier() {
        return ObjectActionLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return ObjectAction.class;
    }

    protected String getModelClassName() {
        return ObjectAction.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.objectActionPersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL((String)sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)dataSource, (String)sql, (ParamSetter[])new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

