/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.field.business.type;

import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.field.render.ObjectFieldRenderingContext;
import com.liferay.object.internal.field.business.type.BaseObjectFieldBusinessType;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.vulcan.extension.PropertyDefinition;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"object.field.business.type.key=Integer"}, service={ObjectFieldBusinessType.class})
public class IntegerObjectFieldBusinessType
extends BaseObjectFieldBusinessType {
    @Reference
    private Language _language;

    public Set<String> getAllowedObjectFieldSettingsNames() {
        return SetUtil.fromArray((Object[])new String[]{"uniqueValues"});
    }

    public String getDBType() {
        return "Integer";
    }

    public String getDDMFormFieldTypeName() {
        return "numeric";
    }

    public String getDescription(Locale locale) {
        return this._language.get(locale, "add-an-integer-up-to-nine-digits");
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "integer");
    }

    public String getName() {
        return "Integer";
    }

    @Override
    public Map<String, Object> getProperties(ObjectField objectField, ObjectFieldRenderingContext objectFieldRenderingContext) {
        return HashMapBuilder.put((Object)"dataType", (Object)"integer").build();
    }

    public PropertyDefinition.PropertyType getPropertyType() {
        return PropertyDefinition.PropertyType.INTEGER;
    }

    public Set<String> getUnmodifiableObjectFieldSettingsNames() {
        return SetUtil.fromArray((Object[])new String[]{"uniqueValues"});
    }

    public void validateObjectFieldSettings(ObjectField objectField, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        super.validateObjectFieldSettings(objectField, objectFieldSettings);
        this.validateBooleanObjectFieldSetting(objectField.getName(), "uniqueValues", this.getObjectFieldSettingsValues(objectFieldSettings));
    }
}

