/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.model.impl;

import com.liferay.object.entry.util.ObjectEntryValuesUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.impl.ObjectEntryBaseImpl;
import com.liferay.object.service.ObjectDefinitionLocalServiceUtil;
import com.liferay.object.service.ObjectEntryLocalServiceUtil;
import com.liferay.object.service.ObjectFieldLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ObjectEntryImpl
extends ObjectEntryBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryImpl.class);
    private Map<String, Serializable> _transientValues;
    private Map<String, Serializable> _values;

    @Override
    public ObjectEntry cloneWithOriginalValues() {
        ObjectEntry objectEntry = super.cloneWithOriginalValues();
        objectEntry.setValues(this._transientValues);
        return objectEntry;
    }

    @Override
    public String getModelClassName() {
        return ObjectDefinition.class.getName() + "#" + this.getObjectDefinitionId();
    }

    public long getNonzeroGroupId() throws PortalException {
        long groupId = this.getGroupId();
        if (groupId == 0L) {
            Company company = CompanyLocalServiceUtil.getCompany((long)this.getCompanyId());
            groupId = company.getGroupId();
        }
        return groupId;
    }

    public String getTitleValue() throws PortalException {
        ObjectField objectField;
        ObjectDefinition objectDefinition = ObjectDefinitionLocalServiceUtil.getObjectDefinition((long)this.getObjectDefinitionId());
        if (objectDefinition != null && objectDefinition.getTitleObjectFieldId() > 0L && (objectField = ObjectFieldLocalServiceUtil.fetchObjectField((long)objectDefinition.getTitleObjectFieldId())) != null) {
            String title = ObjectEntryValuesUtil.getValueString((ObjectField)objectField, this.getValues());
            if (Validator.isNotNull((String)title)) {
                return title;
            }
            return ObjectEntryValuesUtil.getValueString((ObjectField)objectField, (Map)ObjectEntryLocalServiceUtil.getSystemValues((ObjectEntry)this));
        }
        return String.valueOf(this.getObjectEntryId());
    }

    public Map<String, Serializable> getValues() {
        if (this._values == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Get values for object entry " + this.getObjectEntryId()));
            }
            try {
                this._values = ObjectEntryLocalServiceUtil.getValues((ObjectEntry)this);
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
                return new HashMap<String, Serializable>();
            }
        } else if (_log.isDebugEnabled()) {
            _log.debug((Object)("Use cached values for object entry " + this.getObjectEntryId()));
        }
        return this._values;
    }

    public void setTransientValues(Map<String, Serializable> values) {
        this._transientValues = values;
    }

    public void setValues(Map<String, Serializable> values) {
        this._values = values;
    }
}

