/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.model.impl;

import com.liferay.object.definition.util.ObjectDefinitionUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectFolder;
import com.liferay.object.model.impl.ObjectDefinitionBaseImpl;
import com.liferay.object.service.ObjectDefinitionLocalServiceUtil;
import com.liferay.object.service.ObjectFolderLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import java.util.Objects;

public class ObjectDefinitionImpl
extends ObjectDefinitionBaseImpl {
    public static String getShortName(String name) {
        String shortName = name;
        if (shortName.startsWith("C_")) {
            shortName = shortName.substring(2);
        }
        return shortName;
    }

    public String getDestinationName() {
        return StringBundler.concat((Object[])new Object[]{"liferay/object/", this.getCompanyId(), "/", this.getShortName()});
    }

    public String getExtensionDBTableName() {
        if (this.isUnmodifiableSystemObject()) {
            String extensionDBTableName = this.getDBTableName();
            extensionDBTableName = extensionDBTableName.endsWith("_") ? extensionDBTableName + "x_" : extensionDBTableName + "_x_";
            extensionDBTableName = extensionDBTableName + this.getCompanyId();
            return extensionDBTableName;
        }
        return this.getDBTableName() + "_x";
    }

    public String getLocalizationDBTableName() {
        if (!this.isEnableLocalization()) {
            return null;
        }
        return this.getDBTableName() + "_l";
    }

    public String getObjectFolderExternalReferenceCode() {
        ObjectFolder objectFolder = ObjectFolderLocalServiceUtil.fetchObjectFolder((long)this.getObjectFolderId());
        if (objectFolder == null) {
            return null;
        }
        return objectFolder.getExternalReferenceCode();
    }

    public String getOSGiJaxRsName() {
        return this.getOSGiJaxRsName("");
    }

    public String getOSGiJaxRsName(String className) {
        return StringUtil.toLowerCase((String)this.getName()) + className;
    }

    public String getPortletId() {
        if (this.isUnmodifiableSystemObject()) {
            throw new UnsupportedOperationException();
        }
        return "com_liferay_object_web_internal_object_definitions_portlet_ObjectDefinitionsPortlet_" + this.getObjectDefinitionId();
    }

    public String getResourceName() {
        if (this.isUnmodifiableSystemObject()) {
            throw new UnsupportedOperationException();
        }
        return "com.liferay.object#" + this.getObjectDefinitionId();
    }

    public String getRESTContextPath() {
        if (this.isUnmodifiableSystemObject()) {
            throw new UnsupportedOperationException();
        }
        if (!this.isRootDescendantNode()) {
            if (this.isModifiableAndSystem()) {
                return ObjectDefinitionUtil.getModifiableSystemObjectDefinitionRESTContextPath((String)this.getName());
            }
            String lowerCaseShortName = StringUtil.toLowerCase((String)this.getShortName());
            return "/c/" + TextFormatter.formatPlural((String)lowerCaseShortName);
        }
        ObjectDefinition rootObjectDefinition = ObjectDefinitionLocalServiceUtil.fetchObjectDefinition((long)this.getRootObjectDefinitionId());
        if (this.isModifiableAndSystem()) {
            String rootRESTContextPath = ObjectDefinitionUtil.getModifiableSystemObjectDefinitionRESTContextPath((String)rootObjectDefinition.getName());
            String restContextPath = ObjectDefinitionUtil.getModifiableSystemObjectDefinitionRESTContextPath((String)this.getName());
            restContextPath = restContextPath.substring(restContextPath.lastIndexOf("/"));
            return rootRESTContextPath + restContextPath;
        }
        return StringBundler.concat((String[])new String[]{"/c/", TextFormatter.formatPlural((String)StringUtil.toLowerCase((String)rootObjectDefinition.getShortName())), "/", TextFormatter.formatPlural((String)StringUtil.toLowerCase((String)this.getShortName()))});
    }

    public String getRootObjectDefinitionExternalReferenceCode() {
        ObjectDefinition rootObjectDefinition = ObjectDefinitionLocalServiceUtil.fetchObjectDefinition((long)this.getRootObjectDefinitionId());
        if (rootObjectDefinition == null) {
            return null;
        }
        return rootObjectDefinition.getExternalReferenceCode();
    }

    public String getShortName() {
        return ObjectDefinitionImpl.getShortName(this.getName());
    }

    public boolean isApproved() {
        return this.getStatus() == 0;
    }

    public boolean isDefaultStorageType() {
        return Objects.equals(this.getStorageType(), "default");
    }

    public boolean isLinkedToObjectFolder(long objectFolderId) {
        return this.getObjectFolderId() != objectFolderId;
    }

    public boolean isModifiableAndSystem() {
        return this.isModifiable() && this.isSystem();
    }

    public boolean isNodeCandidate() {
        return !this.isApproved() && !this.isUnmodifiableSystemObject();
    }

    public boolean isRootDescendantNode() {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-187142")) {
            return false;
        }
        return this.getRootObjectDefinitionId() > 0L && !this.isRootNode();
    }

    public boolean isRootNode() {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-187142")) {
            return false;
        }
        return this.getObjectDefinitionId() == this.getRootObjectDefinitionId();
    }

    public boolean isUnmodifiableSystemObject() {
        return !this.isModifiable() && this.isSystem();
    }
}

