/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.object.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the ObjectField service. Represents a row in the &quot;ObjectField&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>ObjectFieldModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectFieldImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectFieldImpl
 * @generated
 */
@JSON(strict = true)
public class ObjectFieldModelImpl
	extends BaseModelImpl<ObjectField> implements ObjectFieldModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object field model instance should use the <code>ObjectField</code> interface instead.
	 */
	public static final String TABLE_NAME = "ObjectField";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"externalReferenceCode", Types.VARCHAR},
		{"objectFieldId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"listTypeDefinitionId", Types.BIGINT},
		{"objectDefinitionId", Types.BIGINT}, {"businessType", Types.VARCHAR},
		{"dbColumnName", Types.VARCHAR}, {"dbTableName", Types.VARCHAR},
		{"dbType", Types.VARCHAR}, {"indexed", Types.BOOLEAN},
		{"indexedAsKeyword", Types.BOOLEAN},
		{"indexedLanguageId", Types.VARCHAR}, {"label", Types.VARCHAR},
		{"localized", Types.BOOLEAN}, {"name", Types.VARCHAR},
		{"readOnly", Types.VARCHAR},
		{"readOnlyConditionExpression", Types.CLOB},
		{"relationshipType", Types.VARCHAR}, {"required", Types.BOOLEAN},
		{"state_", Types.BOOLEAN}, {"system_", Types.BOOLEAN}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("objectFieldId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("listTypeDefinitionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("objectDefinitionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("businessType", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("dbColumnName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("dbTableName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("dbType", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("indexed", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("indexedAsKeyword", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("indexedLanguageId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("label", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("localized", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("readOnly", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("readOnlyConditionExpression", Types.CLOB);
		TABLE_COLUMNS_MAP.put("relationshipType", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("required", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("state_", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("system_", Types.BOOLEAN);
	}

	public static final String TABLE_SQL_CREATE =
		"create table ObjectField (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,externalReferenceCode VARCHAR(75) null,objectFieldId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,listTypeDefinitionId LONG,objectDefinitionId LONG,businessType VARCHAR(75) null,dbColumnName VARCHAR(75) null,dbTableName VARCHAR(75) null,dbType VARCHAR(75) null,indexed BOOLEAN,indexedAsKeyword BOOLEAN,indexedLanguageId VARCHAR(75) null,label STRING null,localized BOOLEAN,name VARCHAR(75) null,readOnly VARCHAR(75) null,readOnlyConditionExpression TEXT null,relationshipType VARCHAR(75) null,required BOOLEAN,state_ BOOLEAN,system_ BOOLEAN)";

	public static final String TABLE_SQL_DROP = "drop table ObjectField";

	public static final String ORDER_BY_JPQL = " ORDER BY objectField.name ASC";

	public static final String ORDER_BY_SQL = " ORDER BY ObjectField.name ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long DBTABLENAME_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long DBTYPE_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long INDEXED_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long LISTTYPEDEFINITIONID_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long LOCALIZED_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NAME_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTDEFINITIONID_COLUMN_BITMASK = 256L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long STATE_COLUMN_BITMASK = 512L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SYSTEM_COLUMN_BITMASK = 1024L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long USERID_COLUMN_BITMASK = 2048L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 4096L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public ObjectFieldModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _objectFieldId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setObjectFieldId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _objectFieldId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return ObjectField.class;
	}

	@Override
	public String getModelClassName() {
		return ObjectField.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<ObjectField, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<ObjectField, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectField, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((ObjectField)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<ObjectField, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<ObjectField, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(ObjectField)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<ObjectField, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<ObjectField, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<ObjectField, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<ObjectField, Object>>
				attributeGetterFunctions =
					new LinkedHashMap<String, Function<ObjectField, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", ObjectField::getMvccVersion);
			attributeGetterFunctions.put("uuid", ObjectField::getUuid);
			attributeGetterFunctions.put(
				"externalReferenceCode", ObjectField::getExternalReferenceCode);
			attributeGetterFunctions.put(
				"objectFieldId", ObjectField::getObjectFieldId);
			attributeGetterFunctions.put(
				"companyId", ObjectField::getCompanyId);
			attributeGetterFunctions.put("userId", ObjectField::getUserId);
			attributeGetterFunctions.put("userName", ObjectField::getUserName);
			attributeGetterFunctions.put(
				"createDate", ObjectField::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", ObjectField::getModifiedDate);
			attributeGetterFunctions.put(
				"listTypeDefinitionId", ObjectField::getListTypeDefinitionId);
			attributeGetterFunctions.put(
				"objectDefinitionId", ObjectField::getObjectDefinitionId);
			attributeGetterFunctions.put(
				"businessType", ObjectField::getBusinessType);
			attributeGetterFunctions.put(
				"dbColumnName", ObjectField::getDBColumnName);
			attributeGetterFunctions.put(
				"dbTableName", ObjectField::getDBTableName);
			attributeGetterFunctions.put("dbType", ObjectField::getDBType);
			attributeGetterFunctions.put("indexed", ObjectField::getIndexed);
			attributeGetterFunctions.put(
				"indexedAsKeyword", ObjectField::getIndexedAsKeyword);
			attributeGetterFunctions.put(
				"indexedLanguageId", ObjectField::getIndexedLanguageId);
			attributeGetterFunctions.put("label", ObjectField::getLabel);
			attributeGetterFunctions.put(
				"localized", ObjectField::getLocalized);
			attributeGetterFunctions.put("name", ObjectField::getName);
			attributeGetterFunctions.put("readOnly", ObjectField::getReadOnly);
			attributeGetterFunctions.put(
				"readOnlyConditionExpression",
				ObjectField::getReadOnlyConditionExpression);
			attributeGetterFunctions.put(
				"relationshipType", ObjectField::getRelationshipType);
			attributeGetterFunctions.put("required", ObjectField::getRequired);
			attributeGetterFunctions.put("state", ObjectField::getState);
			attributeGetterFunctions.put("system", ObjectField::getSystem);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<ObjectField, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<ObjectField, ?>> attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<ObjectField, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<ObjectField, Long>)ObjectField::setMvccVersion);
			attributeSetterBiConsumers.put(
				"uuid", (BiConsumer<ObjectField, String>)ObjectField::setUuid);
			attributeSetterBiConsumers.put(
				"externalReferenceCode",
				(BiConsumer<ObjectField, String>)
					ObjectField::setExternalReferenceCode);
			attributeSetterBiConsumers.put(
				"objectFieldId",
				(BiConsumer<ObjectField, Long>)ObjectField::setObjectFieldId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<ObjectField, Long>)ObjectField::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<ObjectField, Long>)ObjectField::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<ObjectField, String>)ObjectField::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<ObjectField, Date>)ObjectField::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<ObjectField, Date>)ObjectField::setModifiedDate);
			attributeSetterBiConsumers.put(
				"listTypeDefinitionId",
				(BiConsumer<ObjectField, Long>)
					ObjectField::setListTypeDefinitionId);
			attributeSetterBiConsumers.put(
				"objectDefinitionId",
				(BiConsumer<ObjectField, Long>)
					ObjectField::setObjectDefinitionId);
			attributeSetterBiConsumers.put(
				"businessType",
				(BiConsumer<ObjectField, String>)ObjectField::setBusinessType);
			attributeSetterBiConsumers.put(
				"dbColumnName",
				(BiConsumer<ObjectField, String>)ObjectField::setDBColumnName);
			attributeSetterBiConsumers.put(
				"dbTableName",
				(BiConsumer<ObjectField, String>)ObjectField::setDBTableName);
			attributeSetterBiConsumers.put(
				"dbType",
				(BiConsumer<ObjectField, String>)ObjectField::setDBType);
			attributeSetterBiConsumers.put(
				"indexed",
				(BiConsumer<ObjectField, Boolean>)ObjectField::setIndexed);
			attributeSetterBiConsumers.put(
				"indexedAsKeyword",
				(BiConsumer<ObjectField, Boolean>)
					ObjectField::setIndexedAsKeyword);
			attributeSetterBiConsumers.put(
				"indexedLanguageId",
				(BiConsumer<ObjectField, String>)
					ObjectField::setIndexedLanguageId);
			attributeSetterBiConsumers.put(
				"label",
				(BiConsumer<ObjectField, String>)ObjectField::setLabel);
			attributeSetterBiConsumers.put(
				"localized",
				(BiConsumer<ObjectField, Boolean>)ObjectField::setLocalized);
			attributeSetterBiConsumers.put(
				"name", (BiConsumer<ObjectField, String>)ObjectField::setName);
			attributeSetterBiConsumers.put(
				"readOnly",
				(BiConsumer<ObjectField, String>)ObjectField::setReadOnly);
			attributeSetterBiConsumers.put(
				"readOnlyConditionExpression",
				(BiConsumer<ObjectField, String>)
					ObjectField::setReadOnlyConditionExpression);
			attributeSetterBiConsumers.put(
				"relationshipType",
				(BiConsumer<ObjectField, String>)
					ObjectField::setRelationshipType);
			attributeSetterBiConsumers.put(
				"required",
				(BiConsumer<ObjectField, Boolean>)ObjectField::setRequired);
			attributeSetterBiConsumers.put(
				"state",
				(BiConsumer<ObjectField, Boolean>)ObjectField::setState);
			attributeSetterBiConsumers.put(
				"system",
				(BiConsumer<ObjectField, Boolean>)ObjectField::setSystem);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalReferenceCode = externalReferenceCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalReferenceCode() {
		return getColumnOriginalValue("externalReferenceCode");
	}

	@JSON
	@Override
	public long getObjectFieldId() {
		return _objectFieldId;
	}

	@Override
	public void setObjectFieldId(long objectFieldId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectFieldId = objectFieldId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalUserId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("userId"));
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getListTypeDefinitionId() {
		return _listTypeDefinitionId;
	}

	@Override
	public void setListTypeDefinitionId(long listTypeDefinitionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_listTypeDefinitionId = listTypeDefinitionId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalListTypeDefinitionId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("listTypeDefinitionId"));
	}

	@JSON
	@Override
	public long getObjectDefinitionId() {
		return _objectDefinitionId;
	}

	@Override
	public void setObjectDefinitionId(long objectDefinitionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectDefinitionId = objectDefinitionId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalObjectDefinitionId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("objectDefinitionId"));
	}

	@JSON
	@Override
	public String getBusinessType() {
		if (_businessType == null) {
			return "";
		}
		else {
			return _businessType;
		}
	}

	@Override
	public void setBusinessType(String businessType) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_businessType = businessType;
	}

	@JSON
	@Override
	public String getDBColumnName() {
		if (_dbColumnName == null) {
			return "";
		}
		else {
			return _dbColumnName;
		}
	}

	@Override
	public void setDBColumnName(String dbColumnName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_dbColumnName = dbColumnName;
	}

	@JSON
	@Override
	public String getDBTableName() {
		if (_dbTableName == null) {
			return "";
		}
		else {
			return _dbTableName;
		}
	}

	@Override
	public void setDBTableName(String dbTableName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_dbTableName = dbTableName;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalDBTableName() {
		return getColumnOriginalValue("dbTableName");
	}

	@JSON
	@Override
	public String getDBType() {
		if (_dbType == null) {
			return "";
		}
		else {
			return _dbType;
		}
	}

	@Override
	public void setDBType(String dbType) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_dbType = dbType;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalDBType() {
		return getColumnOriginalValue("dbType");
	}

	@JSON
	@Override
	public boolean getIndexed() {
		return _indexed;
	}

	@JSON
	@Override
	public boolean isIndexed() {
		return _indexed;
	}

	@Override
	public void setIndexed(boolean indexed) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_indexed = indexed;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalIndexed() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("indexed"));
	}

	@JSON
	@Override
	public boolean getIndexedAsKeyword() {
		return _indexedAsKeyword;
	}

	@JSON
	@Override
	public boolean isIndexedAsKeyword() {
		return _indexedAsKeyword;
	}

	@Override
	public void setIndexedAsKeyword(boolean indexedAsKeyword) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_indexedAsKeyword = indexedAsKeyword;
	}

	@JSON
	@Override
	public String getIndexedLanguageId() {
		if (_indexedLanguageId == null) {
			return "";
		}
		else {
			return _indexedLanguageId;
		}
	}

	@Override
	public void setIndexedLanguageId(String indexedLanguageId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_indexedLanguageId = indexedLanguageId;
	}

	@JSON
	@Override
	public String getLabel() {
		if (_label == null) {
			return "";
		}
		else {
			return _label;
		}
	}

	@Override
	public String getLabel(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getLabel(languageId);
	}

	@Override
	public String getLabel(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getLabel(languageId, useDefault);
	}

	@Override
	public String getLabel(String languageId) {
		return LocalizationUtil.getLocalization(getLabel(), languageId);
	}

	@Override
	public String getLabel(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getLabel(), languageId, useDefault);
	}

	@Override
	public String getLabelCurrentLanguageId() {
		return _labelCurrentLanguageId;
	}

	@JSON
	@Override
	public String getLabelCurrentValue() {
		Locale locale = getLocale(_labelCurrentLanguageId);

		return getLabel(locale);
	}

	@Override
	public Map<Locale, String> getLabelMap() {
		return LocalizationUtil.getLocalizationMap(getLabel());
	}

	@Override
	public void setLabel(String label) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_label = label;
	}

	@Override
	public void setLabel(String label, Locale locale) {
		setLabel(label, locale, LocaleUtil.getDefault());
	}

	@Override
	public void setLabel(String label, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(label)) {
			setLabel(
				LocalizationUtil.updateLocalization(
					getLabel(), "Label", label, languageId, defaultLanguageId));
		}
		else {
			setLabel(
				LocalizationUtil.removeLocalization(
					getLabel(), "Label", languageId));
		}
	}

	@Override
	public void setLabelCurrentLanguageId(String languageId) {
		_labelCurrentLanguageId = languageId;
	}

	@Override
	public void setLabelMap(Map<Locale, String> labelMap) {
		setLabelMap(labelMap, LocaleUtil.getDefault());
	}

	@Override
	public void setLabelMap(
		Map<Locale, String> labelMap, Locale defaultLocale) {

		if (labelMap == null) {
			return;
		}

		setLabel(
			LocalizationUtil.updateLocalization(
				labelMap, getLabel(), "Label",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public boolean getLocalized() {
		return _localized;
	}

	@JSON
	@Override
	public boolean isLocalized() {
		return _localized;
	}

	@Override
	public void setLocalized(boolean localized) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_localized = localized;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalLocalized() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("localized"));
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalName() {
		return getColumnOriginalValue("name");
	}

	@JSON
	@Override
	public String getReadOnly() {
		if (_readOnly == null) {
			return "";
		}
		else {
			return _readOnly;
		}
	}

	@Override
	public void setReadOnly(String readOnly) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_readOnly = readOnly;
	}

	@JSON
	@Override
	public String getReadOnlyConditionExpression() {
		if (_readOnlyConditionExpression == null) {
			return "";
		}
		else {
			return _readOnlyConditionExpression;
		}
	}

	@Override
	public void setReadOnlyConditionExpression(
		String readOnlyConditionExpression) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_readOnlyConditionExpression = readOnlyConditionExpression;
	}

	@JSON
	@Override
	public String getRelationshipType() {
		if (_relationshipType == null) {
			return "";
		}
		else {
			return _relationshipType;
		}
	}

	@Override
	public void setRelationshipType(String relationshipType) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_relationshipType = relationshipType;
	}

	@JSON
	@Override
	public boolean getRequired() {
		return _required;
	}

	@JSON
	@Override
	public boolean isRequired() {
		return _required;
	}

	@Override
	public void setRequired(boolean required) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_required = required;
	}

	@JSON
	@Override
	public boolean getState() {
		return _state;
	}

	@JSON
	@Override
	public boolean isState() {
		return _state;
	}

	@Override
	public void setState(boolean state) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_state = state;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalState() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("state_"));
	}

	@JSON
	@Override
	public boolean getSystem() {
		return _system;
	}

	@JSON
	@Override
	public boolean isSystem() {
		return _system;
	}

	@Override
	public void setSystem(boolean system) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_system = system;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalSystem() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("system_"));
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(ObjectField.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), ObjectField.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> labelMap = getLabelMap();

		for (Map.Entry<Locale, String> entry : labelMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(
			new String[availableLanguageIds.size()]);
	}

	@Override
	public String getDefaultLanguageId() {
		String xml = getLabel();

		if (xml == null) {
			return "";
		}

		Locale defaultLocale = LocaleUtil.getDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException {
		Locale defaultLocale = LocaleUtil.fromLanguageId(
			getDefaultLanguageId());

		Locale[] availableLocales = LocaleUtil.fromLanguageIds(
			getAvailableLanguageIds());

		Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(
			ObjectField.class.getName(), getPrimaryKey(), defaultLocale,
			availableLocales);

		prepareLocalizedFieldsForImport(defaultImportLocale);
	}

	@Override
	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {

		Locale defaultLocale = LocaleUtil.getDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String label = getLabel(defaultLocale);

		if (Validator.isNull(label)) {
			setLabel(getLabel(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setLabel(getLabel(defaultLocale), defaultLocale, defaultLocale);
		}
	}

	@Override
	public ObjectField toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, ObjectField>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		ObjectFieldImpl objectFieldImpl = new ObjectFieldImpl();

		objectFieldImpl.setMvccVersion(getMvccVersion());
		objectFieldImpl.setUuid(getUuid());
		objectFieldImpl.setExternalReferenceCode(getExternalReferenceCode());
		objectFieldImpl.setObjectFieldId(getObjectFieldId());
		objectFieldImpl.setCompanyId(getCompanyId());
		objectFieldImpl.setUserId(getUserId());
		objectFieldImpl.setUserName(getUserName());
		objectFieldImpl.setCreateDate(getCreateDate());
		objectFieldImpl.setModifiedDate(getModifiedDate());
		objectFieldImpl.setListTypeDefinitionId(getListTypeDefinitionId());
		objectFieldImpl.setObjectDefinitionId(getObjectDefinitionId());
		objectFieldImpl.setBusinessType(getBusinessType());
		objectFieldImpl.setDBColumnName(getDBColumnName());
		objectFieldImpl.setDBTableName(getDBTableName());
		objectFieldImpl.setDBType(getDBType());
		objectFieldImpl.setIndexed(isIndexed());
		objectFieldImpl.setIndexedAsKeyword(isIndexedAsKeyword());
		objectFieldImpl.setIndexedLanguageId(getIndexedLanguageId());
		objectFieldImpl.setLabel(getLabel());
		objectFieldImpl.setLocalized(isLocalized());
		objectFieldImpl.setName(getName());
		objectFieldImpl.setReadOnly(getReadOnly());
		objectFieldImpl.setReadOnlyConditionExpression(
			getReadOnlyConditionExpression());
		objectFieldImpl.setRelationshipType(getRelationshipType());
		objectFieldImpl.setRequired(isRequired());
		objectFieldImpl.setState(isState());
		objectFieldImpl.setSystem(isSystem());

		objectFieldImpl.resetOriginalValues();

		return objectFieldImpl;
	}

	@Override
	public ObjectField cloneWithOriginalValues() {
		ObjectFieldImpl objectFieldImpl = new ObjectFieldImpl();

		objectFieldImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		objectFieldImpl.setUuid(this.<String>getColumnOriginalValue("uuid_"));
		objectFieldImpl.setExternalReferenceCode(
			this.<String>getColumnOriginalValue("externalReferenceCode"));
		objectFieldImpl.setObjectFieldId(
			this.<Long>getColumnOriginalValue("objectFieldId"));
		objectFieldImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		objectFieldImpl.setUserId(this.<Long>getColumnOriginalValue("userId"));
		objectFieldImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		objectFieldImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		objectFieldImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		objectFieldImpl.setListTypeDefinitionId(
			this.<Long>getColumnOriginalValue("listTypeDefinitionId"));
		objectFieldImpl.setObjectDefinitionId(
			this.<Long>getColumnOriginalValue("objectDefinitionId"));
		objectFieldImpl.setBusinessType(
			this.<String>getColumnOriginalValue("businessType"));
		objectFieldImpl.setDBColumnName(
			this.<String>getColumnOriginalValue("dbColumnName"));
		objectFieldImpl.setDBTableName(
			this.<String>getColumnOriginalValue("dbTableName"));
		objectFieldImpl.setDBType(
			this.<String>getColumnOriginalValue("dbType"));
		objectFieldImpl.setIndexed(
			this.<Boolean>getColumnOriginalValue("indexed"));
		objectFieldImpl.setIndexedAsKeyword(
			this.<Boolean>getColumnOriginalValue("indexedAsKeyword"));
		objectFieldImpl.setIndexedLanguageId(
			this.<String>getColumnOriginalValue("indexedLanguageId"));
		objectFieldImpl.setLabel(this.<String>getColumnOriginalValue("label"));
		objectFieldImpl.setLocalized(
			this.<Boolean>getColumnOriginalValue("localized"));
		objectFieldImpl.setName(this.<String>getColumnOriginalValue("name"));
		objectFieldImpl.setReadOnly(
			this.<String>getColumnOriginalValue("readOnly"));
		objectFieldImpl.setReadOnlyConditionExpression(
			this.<String>getColumnOriginalValue("readOnlyConditionExpression"));
		objectFieldImpl.setRelationshipType(
			this.<String>getColumnOriginalValue("relationshipType"));
		objectFieldImpl.setRequired(
			this.<Boolean>getColumnOriginalValue("required"));
		objectFieldImpl.setState(
			this.<Boolean>getColumnOriginalValue("state_"));
		objectFieldImpl.setSystem(
			this.<Boolean>getColumnOriginalValue("system_"));

		return objectFieldImpl;
	}

	@Override
	public int compareTo(ObjectField objectField) {
		int value = 0;

		value = getName().compareTo(objectField.getName());

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof ObjectField)) {
			return false;
		}

		ObjectField objectField = (ObjectField)object;

		long primaryKey = objectField.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<ObjectField> toCacheModel() {
		ObjectFieldCacheModel objectFieldCacheModel =
			new ObjectFieldCacheModel();

		objectFieldCacheModel.mvccVersion = getMvccVersion();

		objectFieldCacheModel.uuid = getUuid();

		String uuid = objectFieldCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			objectFieldCacheModel.uuid = null;
		}

		objectFieldCacheModel.externalReferenceCode =
			getExternalReferenceCode();

		String externalReferenceCode =
			objectFieldCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			objectFieldCacheModel.externalReferenceCode = null;
		}

		objectFieldCacheModel.objectFieldId = getObjectFieldId();

		objectFieldCacheModel.companyId = getCompanyId();

		objectFieldCacheModel.userId = getUserId();

		objectFieldCacheModel.userName = getUserName();

		String userName = objectFieldCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			objectFieldCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			objectFieldCacheModel.createDate = createDate.getTime();
		}
		else {
			objectFieldCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			objectFieldCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			objectFieldCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		objectFieldCacheModel.listTypeDefinitionId = getListTypeDefinitionId();

		objectFieldCacheModel.objectDefinitionId = getObjectDefinitionId();

		objectFieldCacheModel.businessType = getBusinessType();

		String businessType = objectFieldCacheModel.businessType;

		if ((businessType != null) && (businessType.length() == 0)) {
			objectFieldCacheModel.businessType = null;
		}

		objectFieldCacheModel.dbColumnName = getDBColumnName();

		String dbColumnName = objectFieldCacheModel.dbColumnName;

		if ((dbColumnName != null) && (dbColumnName.length() == 0)) {
			objectFieldCacheModel.dbColumnName = null;
		}

		objectFieldCacheModel.dbTableName = getDBTableName();

		String dbTableName = objectFieldCacheModel.dbTableName;

		if ((dbTableName != null) && (dbTableName.length() == 0)) {
			objectFieldCacheModel.dbTableName = null;
		}

		objectFieldCacheModel.dbType = getDBType();

		String dbType = objectFieldCacheModel.dbType;

		if ((dbType != null) && (dbType.length() == 0)) {
			objectFieldCacheModel.dbType = null;
		}

		objectFieldCacheModel.indexed = isIndexed();

		objectFieldCacheModel.indexedAsKeyword = isIndexedAsKeyword();

		objectFieldCacheModel.indexedLanguageId = getIndexedLanguageId();

		String indexedLanguageId = objectFieldCacheModel.indexedLanguageId;

		if ((indexedLanguageId != null) && (indexedLanguageId.length() == 0)) {
			objectFieldCacheModel.indexedLanguageId = null;
		}

		objectFieldCacheModel.label = getLabel();

		String label = objectFieldCacheModel.label;

		if ((label != null) && (label.length() == 0)) {
			objectFieldCacheModel.label = null;
		}

		objectFieldCacheModel.localized = isLocalized();

		objectFieldCacheModel.name = getName();

		String name = objectFieldCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			objectFieldCacheModel.name = null;
		}

		objectFieldCacheModel.readOnly = getReadOnly();

		String readOnly = objectFieldCacheModel.readOnly;

		if ((readOnly != null) && (readOnly.length() == 0)) {
			objectFieldCacheModel.readOnly = null;
		}

		objectFieldCacheModel.readOnlyConditionExpression =
			getReadOnlyConditionExpression();

		String readOnlyConditionExpression =
			objectFieldCacheModel.readOnlyConditionExpression;

		if ((readOnlyConditionExpression != null) &&
			(readOnlyConditionExpression.length() == 0)) {

			objectFieldCacheModel.readOnlyConditionExpression = null;
		}

		objectFieldCacheModel.relationshipType = getRelationshipType();

		String relationshipType = objectFieldCacheModel.relationshipType;

		if ((relationshipType != null) && (relationshipType.length() == 0)) {
			objectFieldCacheModel.relationshipType = null;
		}

		objectFieldCacheModel.required = isRequired();

		objectFieldCacheModel.state = isState();

		objectFieldCacheModel.system = isSystem();

		return objectFieldCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<ObjectField, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<ObjectField, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectField, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((ObjectField)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, ObjectField>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					ObjectField.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private String _externalReferenceCode;
	private long _objectFieldId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _listTypeDefinitionId;
	private long _objectDefinitionId;
	private String _businessType;
	private String _dbColumnName;
	private String _dbTableName;
	private String _dbType;
	private boolean _indexed;
	private boolean _indexedAsKeyword;
	private String _indexedLanguageId;
	private String _label;
	private String _labelCurrentLanguageId;
	private boolean _localized;
	private String _name;
	private String _readOnly;
	private String _readOnlyConditionExpression;
	private String _relationshipType;
	private boolean _required;
	private boolean _state;
	private boolean _system;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<ObjectField, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((ObjectField)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"externalReferenceCode", _externalReferenceCode);
		_columnOriginalValues.put("objectFieldId", _objectFieldId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put(
			"listTypeDefinitionId", _listTypeDefinitionId);
		_columnOriginalValues.put("objectDefinitionId", _objectDefinitionId);
		_columnOriginalValues.put("businessType", _businessType);
		_columnOriginalValues.put("dbColumnName", _dbColumnName);
		_columnOriginalValues.put("dbTableName", _dbTableName);
		_columnOriginalValues.put("dbType", _dbType);
		_columnOriginalValues.put("indexed", _indexed);
		_columnOriginalValues.put("indexedAsKeyword", _indexedAsKeyword);
		_columnOriginalValues.put("indexedLanguageId", _indexedLanguageId);
		_columnOriginalValues.put("label", _label);
		_columnOriginalValues.put("localized", _localized);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("readOnly", _readOnly);
		_columnOriginalValues.put(
			"readOnlyConditionExpression", _readOnlyConditionExpression);
		_columnOriginalValues.put("relationshipType", _relationshipType);
		_columnOriginalValues.put("required", _required);
		_columnOriginalValues.put("state_", _state);
		_columnOriginalValues.put("system_", _system);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("state_", "state");
		attributeNames.put("system_", "system");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("externalReferenceCode", 4L);

		columnBitmasks.put("objectFieldId", 8L);

		columnBitmasks.put("companyId", 16L);

		columnBitmasks.put("userId", 32L);

		columnBitmasks.put("userName", 64L);

		columnBitmasks.put("createDate", 128L);

		columnBitmasks.put("modifiedDate", 256L);

		columnBitmasks.put("listTypeDefinitionId", 512L);

		columnBitmasks.put("objectDefinitionId", 1024L);

		columnBitmasks.put("businessType", 2048L);

		columnBitmasks.put("dbColumnName", 4096L);

		columnBitmasks.put("dbTableName", 8192L);

		columnBitmasks.put("dbType", 16384L);

		columnBitmasks.put("indexed", 32768L);

		columnBitmasks.put("indexedAsKeyword", 65536L);

		columnBitmasks.put("indexedLanguageId", 131072L);

		columnBitmasks.put("label", 262144L);

		columnBitmasks.put("localized", 524288L);

		columnBitmasks.put("name", 1048576L);

		columnBitmasks.put("readOnly", 2097152L);

		columnBitmasks.put("readOnlyConditionExpression", 4194304L);

		columnBitmasks.put("relationshipType", 8388608L);

		columnBitmasks.put("required", 16777216L);

		columnBitmasks.put("state_", 33554432L);

		columnBitmasks.put("system_", 67108864L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private ObjectField _escapedModel;

}