/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.dynamic.data.mapping.expression.CreateExpressionRequest;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.object.definition.util.ObjectDefinitionUtil;
import com.liferay.object.entry.util.ObjectEntryThreadLocal;
import com.liferay.object.exception.DuplicateObjectValidationRuleExternalReferenceCodeException;
import com.liferay.object.exception.ObjectValidationRuleEngineException;
import com.liferay.object.exception.ObjectValidationRuleNameException;
import com.liferay.object.exception.ObjectValidationRuleOutputTypeException;
import com.liferay.object.exception.ObjectValidationRuleScriptException;
import com.liferay.object.exception.ObjectValidationRuleSettingNameException;
import com.liferay.object.exception.ObjectValidationRuleSettingValueException;
import com.liferay.object.exception.ObjectValidationRuleSystemException;
import com.liferay.object.exception.RequiredObjectValidationRuleSettingException;
import com.liferay.object.internal.action.util.ObjectEntryVariablesUtil;
import com.liferay.object.internal.validation.rule.FunctionObjectValidationRuleEngineImpl;
import com.liferay.object.internal.validation.rule.UniqueCompositeKeyObjectValidationRuleEngineImpl;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectValidationRule;
import com.liferay.object.model.ObjectValidationRuleSetting;
import com.liferay.object.scripting.exception.ObjectScriptingException;
import com.liferay.object.scripting.validator.ObjectScriptingValidator;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectValidationRuleSettingLocalService;
import com.liferay.object.service.base.ObjectValidationRuleLocalServiceBaseImpl;
import com.liferay.object.service.impl.ObjectValidationRuleSettingLocalServiceImpl;
import com.liferay.object.service.persistence.ObjectDefinitionPersistence;
import com.liferay.object.service.persistence.ObjectFieldPersistence;
import com.liferay.object.service.persistence.ObjectValidationRuleSettingPersistence;
import com.liferay.object.system.SystemObjectDefinitionManagerRegistry;
import com.liferay.object.validation.rule.ObjectValidationRuleEngine;
import com.liferay.object.validation.rule.ObjectValidationRuleEngineRegistry;
import com.liferay.object.validation.rule.ObjectValidationRuleResult;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.script.management.configuration.helper.ScriptManagementConfigurationHelper;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectValidationRule"}, service={AopService.class})
public class ObjectValidationRuleLocalServiceImpl
extends ObjectValidationRuleLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(ObjectValidationRuleLocalServiceImpl.class);
    private static final List<String> _compositeKeyObjectFieldBusinessTypes = Arrays.asList("Integer", "Picklist", "Relationship", "Text");
    private static final Snapshot<ObjectEntryLocalService> _objectEntryLocalServiceSnapshot = new Snapshot(ObjectValidationRuleSettingLocalServiceImpl.class, ObjectEntryLocalService.class, null, true);
    private static final Snapshot<ObjectFieldLocalService> _objectFieldLocalServiceSnapshot = new Snapshot(ObjectValidationRuleSettingLocalServiceImpl.class, ObjectFieldLocalService.class, null, true);
    @Reference
    private DDMExpressionFactory _ddmExpressionFactory;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private Language _language;
    @Reference
    private ObjectDefinitionPersistence _objectDefinitionPersistence;
    @Reference
    private ObjectFieldPersistence _objectFieldPersistence;
    @Reference
    private ObjectScriptingValidator _objectScriptingValidator;
    @Reference
    private ObjectValidationRuleEngineRegistry _objectValidationRuleEngineRegistry;
    @Reference
    private ObjectValidationRuleSettingLocalService _objectValidationRuleSettingLocalService;
    @Reference
    private ObjectValidationRuleSettingPersistence _objectValidationRuleSettingPersistence;
    @Reference
    private ScriptManagementConfigurationHelper _scriptManagementConfigurationHelper;
    @Reference
    private SystemObjectDefinitionManagerRegistry _systemObjectDefinitionManagerRegistry;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public ObjectValidationRule addObjectValidationRule(String externalReferenceCode, long userId, long objectDefinitionId, boolean active, String engine, Map<Locale, String> errorLabelMap, Map<Locale, String> nameMap, String outputType, String script, boolean system, List<ObjectValidationRuleSetting> objectValidationRuleSettings) throws PortalException {
        this._validateInvokerBundle("Only allowed bundles can add system object validation rules", system);
        User user = this._userLocalService.getUser(userId);
        this._validate(externalReferenceCode, 0L, user.getCompanyId(), objectDefinitionId, active, engine, nameMap, outputType, script, objectValidationRuleSettings);
        ObjectValidationRule objectValidationRule = this.objectValidationRulePersistence.create(this.counterLocalService.increment());
        if (Validator.isNull((String)externalReferenceCode)) {
            externalReferenceCode = objectValidationRule.getUuid();
        }
        objectValidationRule.setExternalReferenceCode(externalReferenceCode);
        objectValidationRule.setCompanyId(user.getCompanyId());
        objectValidationRule.setUserId(user.getUserId());
        objectValidationRule.setUserName(user.getFullName());
        objectValidationRule.setObjectDefinitionId(objectDefinitionId);
        objectValidationRule.setActive(active);
        objectValidationRule.setEngine(engine);
        objectValidationRule.setErrorLabelMap(errorLabelMap);
        objectValidationRule.setNameMap(nameMap);
        objectValidationRule.setOutputType(outputType);
        objectValidationRule.setScript(script);
        objectValidationRule.setSystem(system);
        objectValidationRule = (ObjectValidationRule)this.objectValidationRulePersistence.update((BaseModel)objectValidationRule);
        long objectValidationRuleId = objectValidationRule.getObjectValidationRuleId();
        objectValidationRule.setObjectValidationRuleSettings(TransformUtil.transform(objectValidationRuleSettings, objectValidationRuleSetting -> this._objectValidationRuleSettingLocalService.addObjectValidationRuleSetting(userId, objectValidationRuleId, objectValidationRuleSetting.getName(), objectValidationRuleSetting.getValue())));
        return objectValidationRule;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public ObjectValidationRule deleteObjectValidationRule(long objectValidationRuleId) throws PortalException {
        ObjectValidationRule objectValidationRule = this.objectValidationRulePersistence.findByPrimaryKey(objectValidationRuleId);
        return this.deleteObjectValidationRule(objectValidationRule);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public ObjectValidationRule deleteObjectValidationRule(ObjectValidationRule objectValidationRule) throws PortalException {
        this._validateInvokerBundle("Only allowed bundles can delete system object validation rules", objectValidationRule.isSystem());
        objectValidationRule = (ObjectValidationRule)this.objectValidationRulePersistence.remove((BaseModel)objectValidationRule);
        this._objectValidationRuleSettingPersistence.removeByObjectValidationRuleId(objectValidationRule.getObjectValidationRuleId());
        return objectValidationRule;
    }

    public void deleteObjectValidationRules(Long objectDefinitionId) throws PortalException {
        for (ObjectValidationRule objectValidationRule : this.objectValidationRulePersistence.findByObjectDefinitionId(objectDefinitionId.longValue())) {
            this.objectValidationRuleLocalService.deleteObjectValidationRule(objectValidationRule);
        }
    }

    public ObjectValidationRule fetchObjectValidationRule(String externalReferenceCode, long objectDefinitionId) {
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId);
        if (objectDefinition == null) {
            return null;
        }
        return this.objectValidationRulePersistence.fetchByERC_C_ODI(externalReferenceCode, objectDefinition.getCompanyId(), objectDefinitionId);
    }

    @Override
    public ObjectValidationRule getObjectValidationRule(long objectValidationRuleId) throws PortalException {
        ObjectValidationRule objectValidationRule = this.objectValidationRulePersistence.findByPrimaryKey(objectValidationRuleId);
        objectValidationRule.setObjectValidationRuleSettings(this._objectValidationRuleSettingPersistence.findByObjectValidationRuleId(objectValidationRuleId));
        return objectValidationRule;
    }

    public List<ObjectValidationRule> getObjectValidationRules(boolean active, String engine) {
        return this.objectValidationRulePersistence.findByA_E(active, engine);
    }

    public List<ObjectValidationRule> getObjectValidationRules(long objectDefinitionId) {
        return this._getObjectValidationRules(this.objectValidationRulePersistence.findByObjectDefinitionId(objectDefinitionId));
    }

    public List<ObjectValidationRule> getObjectValidationRules(long objectDefinitionId, boolean active) {
        return this._getObjectValidationRules(this.objectValidationRulePersistence.findByODI_A(objectDefinitionId, active));
    }

    public List<ObjectValidationRule> getObjectValidationRules(long objectDefinitionId, String engine) {
        return this._getObjectValidationRules(this.objectValidationRulePersistence.findByODI_E(objectDefinitionId, engine));
    }

    public int getObjectValidationRulesCount(long objectDefinitionId, boolean active) {
        return this.objectValidationRulePersistence.countByODI_A(objectDefinitionId, active);
    }

    public void unassociateObjectField(ObjectField objectField) {
        for (ObjectValidationRule objectValidationRule : this.objectValidationRulePersistence.findByODI_O(objectField.getObjectDefinitionId(), "partialValidation")) {
            ObjectValidationRuleSetting objectValidationRuleSetting = this._objectValidationRuleSettingPersistence.fetchByOVRI_N_V(objectValidationRule.getObjectValidationRuleId(), "outputObjectFieldId", String.valueOf(objectField.getObjectFieldId()));
            if (objectValidationRuleSetting == null) continue;
            this._objectValidationRuleSettingPersistence.remove((BaseModel)objectValidationRuleSetting);
            int count = this._objectValidationRuleSettingPersistence.countByOVRI_N(objectValidationRule.getObjectValidationRuleId(), "outputObjectFieldId");
            if (count != 0) continue;
            objectValidationRule.setOutputType("fullValidation");
            this.objectValidationRulePersistence.update((BaseModel)objectValidationRule);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public ObjectValidationRule updateObjectValidationRule(String externalReferenceCode, long objectValidationRuleId, boolean active, String engine, Map<Locale, String> errorLabelMap, Map<Locale, String> nameMap, String outputType, String script, List<ObjectValidationRuleSetting> objectValidationRuleSettings) throws PortalException {
        ObjectValidationRule objectValidationRule = this.objectValidationRulePersistence.findByPrimaryKey(objectValidationRuleId);
        this._validateInvokerBundle("Only allowed bundles can edit system object validation rules", objectValidationRule.isSystem());
        if (StringUtil.equals((String)engine, (String)"compositeKey")) {
            active = true;
        }
        this._validate(externalReferenceCode, objectValidationRule.getObjectValidationRuleId(), objectValidationRule.getCompanyId(), objectValidationRule.getObjectDefinitionId(), active, engine, nameMap, outputType, script, objectValidationRuleSettings);
        objectValidationRule.setExternalReferenceCode(externalReferenceCode);
        objectValidationRule.setActive(active);
        objectValidationRule.setEngine(engine);
        objectValidationRule.setErrorLabelMap(errorLabelMap);
        objectValidationRule.setNameMap(nameMap);
        objectValidationRule.setOutputType(outputType);
        objectValidationRule.setScript(script);
        objectValidationRule = (ObjectValidationRule)this.objectValidationRulePersistence.update((BaseModel)objectValidationRule);
        objectValidationRule.setObjectValidationRuleSettings(this._updateObjectValidationRuleSettings(objectValidationRuleSettings, this._objectDefinitionPersistence.fetchByPrimaryKey(objectValidationRule.getObjectDefinitionId()), objectValidationRule));
        return objectValidationRule;
    }

    @Transactional(readOnly=true)
    public void validate(BaseModel<?> baseModel, long objectDefinitionId, JSONObject payloadJSONObject, long userId) throws PortalException {
        if (baseModel == null || ObjectEntryThreadLocal.isValidatedObjectEntry((long)((Long)baseModel.getPrimaryKeyObj()))) {
            return;
        }
        List objectValidationRules = this.objectValidationRuleLocalService.getObjectValidationRules(objectDefinitionId, true);
        if (ListUtil.isEmpty((List)objectValidationRules)) {
            return;
        }
        ObjectDefinition objectDefinition = this._objectDefinitionPersistence.fetchByPrimaryKey(objectDefinitionId);
        Map<String, Object> variables = ObjectEntryVariablesUtil.getVariables(this._dtoConverterRegistry, objectDefinition, payloadJSONObject, this._systemObjectDefinitionManagerRegistry);
        ArrayList<ObjectValidationRuleResult> objectValidationRuleResults = new ArrayList<ObjectValidationRuleResult>();
        for (ObjectValidationRule objectValidationRule : objectValidationRules) {
            Map results = new HashMap();
            ObjectValidationRuleEngine objectValidationRuleEngine = this._objectValidationRuleEngineRegistry.getObjectValidationRuleEngine(objectValidationRule.getCompanyId(), objectValidationRule.getEngine());
            if (StringUtil.equals((String)objectValidationRuleEngine.getKey(), (String)"compositeKey")) {
                variables.put("objectValidationRule", objectValidationRule);
                results = objectValidationRuleEngine.execute(variables, null);
            } else {
                results = StringUtil.equals((String)objectValidationRuleEngine.getKey(), (String)"ddm") ? objectValidationRuleEngine.execute(variables, objectValidationRule.getScript()) : (StringUtil.equals((String)objectValidationRuleEngine.getKey(), (String)"groovy") ? objectValidationRuleEngine.execute((Map)variables.get("baseModel"), objectValidationRule.getScript()) : (StringUtil.startsWith((String)objectValidationRuleEngine.getKey(), (String)"javaDelegate#") ? objectValidationRuleEngine.execute((Map)HashMapBuilder.put((Object)"entryDTO", (Object)variables.get("entryDTO")).put((Object)"originalEntryDTO", variables.get("originalEntryDTO")).build(), null) : objectValidationRuleEngine.execute((Map)variables.get("entryDTO"), null)));
            }
            Locale locale = LocaleUtil.getMostRelevantLocale();
            User user = this._userLocalService.fetchUser(userId);
            if (user != null) {
                locale = user.getLocale();
            }
            String errorMessage = null;
            if (!GetterUtil.getBoolean(results.get("validationCriteriaMet"))) {
                errorMessage = objectValidationRule.getErrorLabel(locale);
            } else if (GetterUtil.getBoolean(results.get("invalidScript"))) {
                errorMessage = this._language.get(locale, "there-was-an-error-validating-your-data");
            }
            if (Validator.isNull((String)errorMessage)) continue;
            if (objectValidationRule.compareOutputType("partialValidation")) {
                for (ObjectValidationRuleSetting objectValidationRuleSetting : this._objectValidationRuleSettingPersistence.findByOVRI_N(objectValidationRule.getObjectValidationRuleId(), "outputObjectFieldId")) {
                    ObjectField objectField = this._objectFieldPersistence.fetchByPrimaryKey(GetterUtil.getLong((String)objectValidationRuleSetting.getValue()));
                    if (objectField == null) continue;
                    objectValidationRuleResults.add(new ObjectValidationRuleResult(errorMessage, objectField.getName()));
                }
                continue;
            }
            objectValidationRuleResults.add(new ObjectValidationRuleResult(errorMessage));
        }
        ObjectEntryThreadLocal.addValidatedObjectEntryId((long)((Long)baseModel.getPrimaryKeyObj()));
        if (ListUtil.isNotEmpty(objectValidationRuleResults)) {
            throw new ObjectValidationRuleEngineException(objectValidationRuleResults);
        }
    }

    private List<ObjectValidationRule> _getObjectValidationRules(List<ObjectValidationRule> objectValidationRules) {
        for (ObjectValidationRule objectValidationRule : objectValidationRules) {
            objectValidationRule.setObjectValidationRuleSettings(this._objectValidationRuleSettingPersistence.findByObjectValidationRuleId(objectValidationRule.getObjectValidationRuleId()));
        }
        return objectValidationRules;
    }

    private List<ObjectValidationRuleSetting> _updateObjectValidationRuleSettings(List<ObjectValidationRuleSetting> newObjectValidationRuleSettings, ObjectDefinition objectDefinition, ObjectValidationRule objectValidationRule) throws PortalException {
        for (ObjectValidationRuleSetting oldObjectValidationRuleSetting : this._objectValidationRuleSettingPersistence.findByObjectValidationRuleId(objectValidationRule.getObjectValidationRuleId())) {
            boolean delete = true;
            for (ObjectValidationRuleSetting newObjectValidationRuleSetting : newObjectValidationRuleSettings) {
                if (!StringUtil.equals((String)oldObjectValidationRuleSetting.getName(), (String)newObjectValidationRuleSetting.getName()) || !StringUtil.equals((String)oldObjectValidationRuleSetting.getValue(), (String)newObjectValidationRuleSetting.getValue())) continue;
                delete = false;
                break;
            }
            if (!delete) continue;
            if (objectDefinition.isApproved() && oldObjectValidationRuleSetting.compareName("compositeKeyObjectFieldId")) {
                throw new RequiredObjectValidationRuleSettingException.MustNotDeleteObjectValidationRuleSettingPublishedObjectDefinition(oldObjectValidationRuleSetting.getName());
            }
            this._objectValidationRuleSettingPersistence.remove((BaseModel)oldObjectValidationRuleSetting);
        }
        for (ObjectValidationRuleSetting newObjectValidationRuleSetting : newObjectValidationRuleSettings) {
            ObjectValidationRuleSetting oldObjectValidationRuleSetting = this._objectValidationRuleSettingPersistence.fetchByOVRI_N_V(objectValidationRule.getObjectValidationRuleId(), newObjectValidationRuleSetting.getName(), newObjectValidationRuleSetting.getValue());
            if (oldObjectValidationRuleSetting != null) continue;
            this._objectValidationRuleSettingLocalService.addObjectValidationRuleSetting(objectValidationRule.getUserId(), objectValidationRule.getObjectValidationRuleId(), newObjectValidationRuleSetting.getName(), newObjectValidationRuleSetting.getValue());
        }
        return newObjectValidationRuleSettings;
    }

    private void _validate(String externalReferenceCode, long objectValidationRuleId, long companyId, long objectDefinitionId, boolean active, String engine, Map<Locale, String> nameMap, String outputType, String script, List<ObjectValidationRuleSetting> objectValidationRuleSettings) throws PortalException {
        ObjectValidationRule objectValidationRule;
        if (Validator.isNotNull((String)externalReferenceCode) && (objectValidationRule = this.objectValidationRulePersistence.fetchByERC_C_ODI(externalReferenceCode, companyId, objectDefinitionId)) != null && objectValidationRule.getObjectValidationRuleId() != objectValidationRuleId) {
            throw new DuplicateObjectValidationRuleExternalReferenceCodeException();
        }
        if (Validator.isNull((String)engine)) {
            throw new ObjectValidationRuleEngineException.MustNotBeNull();
        }
        if (Objects.equals(engine, "groovy") && !this._scriptManagementConfigurationHelper.isAllowScriptContentToBeExecutedOrIncluded()) {
            throw new ObjectValidationRuleEngineException.NotAllowedEngine("groovy");
        }
        Locale locale = LocaleUtil.getSiteDefault();
        if (nameMap == null || Validator.isNull((String)nameMap.get(locale))) {
            throw new ObjectValidationRuleNameException("Name is null for locale " + locale.getDisplayName());
        }
        if (!StringUtil.equals((String)outputType, (String)"fullValidation") && !StringUtil.equals((String)outputType, (String)"partialValidation")) {
            throw new ObjectValidationRuleOutputTypeException("Invalid output type " + outputType);
        }
        if (!this._objectValidationRuleEngineRegistry.hasObjectValidationRuleEngine(companyId, engine)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"No object validation rule engine is registered with ", "key ", engine}));
            }
            return;
        }
        ObjectValidationRuleEngine objectValidationRuleEngine = this._objectValidationRuleEngineRegistry.getObjectValidationRuleEngine(companyId, engine);
        if (Validator.isNull((String)script) && !(objectValidationRuleEngine instanceof FunctionObjectValidationRuleEngineImpl) && !(objectValidationRuleEngine instanceof UniqueCompositeKeyObjectValidationRuleEngineImpl) && !StringUtil.startsWith((String)engine, (String)"javaDelegate#")) {
            throw new ObjectValidationRuleScriptException("The script is required", "required");
        }
        try {
            if (Objects.equals(engine, "ddm")) {
                this._ddmExpressionFactory.createExpression(CreateExpressionRequest.Builder.newBuilder((String)script).build());
            } else if (Objects.equals(engine, "groovy")) {
                this._objectScriptingValidator.validate("groovy", script);
            }
        }
        catch (ObjectScriptingException objectScriptingException) {
            throw new ObjectValidationRuleScriptException(objectScriptingException.getMessage(), objectScriptingException.getMessageKey());
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            throw new ObjectValidationRuleScriptException("The script syntax is invalid", "syntax-error");
        }
        if (StringUtil.equals((String)outputType, (String)"partialValidation") && ListUtil.isEmpty(objectValidationRuleSettings)) {
            throw new ObjectValidationRuleSettingNameException.MissingRequiredName("outputObjectFieldId");
        }
        Set allowedObjectValidationRuleSettingNames = SetUtil.fromArray((Object[])new String[]{"outputObjectFieldId"});
        if (FeatureFlagManagerUtil.isEnabled((String)"LPS-187854")) {
            allowedObjectValidationRuleSettingNames.add("compositeKeyObjectFieldId");
        }
        int count = 0;
        for (ObjectValidationRuleSetting objectValidationRuleSetting : objectValidationRuleSettings) {
            if (!allowedObjectValidationRuleSettingNames.contains(objectValidationRuleSetting.getName()) || objectValidationRuleSetting.compareName("outputObjectFieldId") && !StringUtil.equals((String)outputType, (String)"partialValidation")) {
                throw new ObjectValidationRuleSettingNameException.NotAllowedName(objectValidationRuleSetting.getName());
            }
            ObjectField objectField = this._objectFieldPersistence.fetchByPrimaryKey(GetterUtil.getLong((String)objectValidationRuleSetting.getValue()));
            if (objectField == null || objectField.isSystem() || objectValidationRuleSetting.compareName("compositeKeyObjectFieldId") && !_compositeKeyObjectFieldBusinessTypes.contains(objectField.getBusinessType())) {
                throw new ObjectValidationRuleSettingValueException.InvalidValue(objectValidationRuleSetting.getName(), objectValidationRuleSetting.getValue());
            }
            if (!objectValidationRuleSetting.compareName("compositeKeyObjectFieldId")) continue;
            ObjectDefinition objectDefinition = this._objectDefinitionPersistence.findByPrimaryKey(objectDefinitionId);
            ObjectValidationRuleSetting oldObjectValidationRuleSetting = this._objectValidationRuleSettingPersistence.fetchByOVRI_N_V(objectValidationRuleId, objectValidationRuleSetting.getName(), objectValidationRuleSetting.getValue());
            if (oldObjectValidationRuleSetting == null && objectDefinition.isApproved()) {
                ObjectFieldLocalService objectFieldLocalService = (ObjectFieldLocalService)_objectFieldLocalServiceSnapshot.get();
                Column column = objectFieldLocalService.getColumn(objectDefinition.getObjectDefinitionId(), objectField.getName());
                ObjectEntryLocalService objectEntryLocalService = (ObjectEntryLocalService)_objectEntryLocalServiceSnapshot.get();
                long objectEntriesCount = objectEntryLocalService.getObjectEntriesCount(0L, objectDefinition, column.isNotNull());
                if (objectEntriesCount > 0L) {
                    throw new ObjectValidationRuleSettingValueException.InvalidValue(objectValidationRuleSetting.getName(), objectValidationRuleSetting.getValue());
                }
            }
            ++count;
        }
        if (StringUtil.equals((String)engine, (String)"compositeKey")) {
            if (count > 5) {
                throw new ObjectValidationRuleSettingValueException.CompositeKeyMustHaveMaxObjectFields();
            }
            if (active && count < 2) {
                throw new ObjectValidationRuleSettingValueException.CompositeKeyMustHaveMinObjectFields();
            }
        }
    }

    private void _validateInvokerBundle(String message, boolean system) throws PortalException {
        if (!system || ObjectDefinitionUtil.isInvokerBundleAllowed()) {
            return;
        }
        throw new ObjectValidationRuleSystemException(message);
    }
}

