/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.field.filter.parser;

import com.liferay.frontend.data.set.filter.FDSFilter;
import com.liferay.list.type.service.ListTypeDefinitionLocalService;
import com.liferay.list.type.service.ListTypeEntryLocalService;
import com.liferay.object.field.filter.parser.ObjectFieldFilterContext;
import com.liferay.object.field.filter.parser.ObjectFieldFilterContributor;
import com.liferay.object.field.filter.parser.ObjectFieldFilterStrategy;
import com.liferay.object.field.filter.parser.OneToManyObjectFieldFilterStrategy;
import com.liferay.object.field.filter.parser.PicklistObjectFieldFilterStrategy;
import com.liferay.object.field.filter.parser.StatusSystemObjectFieldFilterStrategy;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.model.ObjectViewFilterColumn;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.system.SystemObjectDefinitionManagerRegistry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"object.field.filter.type.key=excludes", "object.field.filter.type.key=includes"}, service={ObjectFieldFilterContributor.class})
public class ListObjectFieldFilterContributor
implements ObjectFieldFilterContributor {
    @Reference
    private Language _language;
    @Reference
    private ListTypeDefinitionLocalService _listTypeDefinitionLocalService;
    @Reference
    private ListTypeEntryLocalService _listTypeEntryLocalService;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    private ObjectFieldFilterStrategy _objectFieldFilterStrategy;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private SystemObjectDefinitionManagerRegistry _systemObjectDefinitionManagerRegistry;

    public FDSFilter getFDSFilter() throws PortalException {
        return this._objectFieldFilterStrategy.getFDSFilter();
    }

    public Map<String, Object> parse() throws PortalException {
        return this._objectFieldFilterStrategy.parse();
    }

    public void setObjectFieldFilterStrategy(ObjectFieldFilterContext objectFieldFilterContext) throws PortalException {
        this._objectFieldFilterStrategy = this._toObjectFieldFilterStrategy(objectFieldFilterContext.getLocale(), objectFieldFilterContext.getObjectDefinitionId(), objectFieldFilterContext.getObjectViewFilterColumn());
    }

    public String toValueSummary() throws PortalException {
        return this._objectFieldFilterStrategy.toValueSummary();
    }

    public void validate() throws PortalException {
        this._objectFieldFilterStrategy.validate();
    }

    private ObjectFieldFilterStrategy _toObjectFieldFilterStrategy(Locale locale, long objectDefinitionId, ObjectViewFilterColumn objectViewFilterColumn) throws PortalException {
        if (Objects.equals(objectViewFilterColumn.getObjectFieldName(), "status")) {
            return new StatusSystemObjectFieldFilterStrategy(this._language, locale, objectViewFilterColumn);
        }
        ObjectField objectField = this._objectFieldLocalService.fetchObjectField(objectDefinitionId, objectViewFilterColumn.getObjectFieldName());
        if (Objects.equals("MultiselectPicklist", objectField.getBusinessType()) || Objects.equals("Picklist", objectField.getBusinessType())) {
            return new PicklistObjectFieldFilterStrategy(locale, objectField.getListTypeDefinitionId(), this._listTypeDefinitionLocalService, this._listTypeEntryLocalService, objectField, objectViewFilterColumn);
        }
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.fetchObjectRelationshipByObjectFieldId2(objectField.getObjectFieldId());
        return new OneToManyObjectFieldFilterStrategy(locale, this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId1()), this._objectDefinitionLocalService, this._objectEntryLocalService, objectField, this._objectFieldLocalService, this._objectRelationshipLocalService, objectViewFilterColumn, this._systemObjectDefinitionManagerRegistry);
    }
}

