/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.model.ObjectState;
import com.liferay.object.service.ObjectStateTransitionLocalService;
import com.liferay.object.service.base.ObjectStateLocalServiceBaseImpl;
import com.liferay.object.service.persistence.ObjectStateTransitionPersistence;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.object.model.ObjectState"}, service={AopService.class})
public class ObjectStateLocalServiceImpl
extends ObjectStateLocalServiceBaseImpl {
    @Reference
    private ObjectStateTransitionLocalService _objectStateTransitionLocalService;
    @Reference
    private ObjectStateTransitionPersistence _objectStateTransitionPersistence;
    @Reference
    private UserLocalService _userLocalService;

    public ObjectState addObjectState(long userId, long listTypeEntryId, long objectStateFlowId) throws PortalException {
        ObjectState objectState = this.createObjectState(this.counterLocalService.increment());
        User user = this._userLocalService.getUser(userId);
        objectState.setCompanyId(user.getCompanyId());
        objectState.setUserId(user.getUserId());
        objectState.setUserName(user.getFullName());
        objectState.setListTypeEntryId(listTypeEntryId);
        objectState.setObjectStateFlowId(objectStateFlowId);
        return this.updateObjectState(objectState);
    }

    public void deleteListTypeEntryObjectStates(long listTypeEntryId) {
        List objectStates = this.objectStatePersistence.findByListTypeEntryId(listTypeEntryId);
        for (ObjectState objectState : objectStates) {
            this.objectStatePersistence.remove((BaseModel)objectState);
            this._objectStateTransitionLocalService.deleteObjectStateObjectStateTransitions(objectState.getObjectStateId());
        }
    }

    public void deleteObjectStateFlowObjectStates(long objectStateFlowId) {
        this.objectStatePersistence.removeByObjectStateFlowId(objectStateFlowId);
    }

    public ObjectState fetchObjectStateFlowObjectState(long listTypeEntryId, long objectStateFlowId) throws PortalException {
        return this.objectStatePersistence.fetchByLTEI_OSFI(listTypeEntryId, objectStateFlowId);
    }

    public List<ObjectState> getNextObjectStates(long sourceObjectStateId) {
        return TransformUtil.transform((Collection)this._objectStateTransitionPersistence.findBySourceObjectStateId(sourceObjectStateId), objectStateTransition -> this.objectStatePersistence.fetchByPrimaryKey(objectStateTransition.getTargetObjectStateId()));
    }

    public ObjectState getObjectStateFlowObjectState(long listTypeEntryId, long objectStateFlowId) throws PortalException {
        return this.objectStatePersistence.findByLTEI_OSFI(listTypeEntryId, objectStateFlowId);
    }

    public List<ObjectState> getObjectStateFlowObjectStates(long objectStateFlowId) {
        return this.objectStatePersistence.findByObjectStateFlowId(objectStateFlowId);
    }
}

