/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.sort;

import com.liferay.object.internal.sort.Sort;
import com.liferay.object.model.ObjectEntryTable;
import com.liferay.object.petra.sql.dsl.DynamicObjectDefinitionLocalizationTable;
import com.liferay.object.petra.sql.dsl.DynamicObjectDefinitionTable;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.ast.ASTNode;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.petra.sql.dsl.spi.ast.BaseASTNode;
import com.liferay.petra.sql.dsl.spi.query.From;
import com.liferay.petra.sql.dsl.spi.query.Join;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Stack;

public abstract class BaseSortDSLQueryVisitor {
    protected ObjectFieldLocalService objectFieldLocalService;
    protected ObjectRelationshipLocalService objectRelationshipLocalService;

    public BaseSortDSLQueryVisitor(ObjectFieldLocalService objectFieldLocalService, ObjectRelationshipLocalService objectRelationshipLocalService) {
        this.objectFieldLocalService = objectFieldLocalService;
        this.objectRelationshipLocalService = objectRelationshipLocalService;
    }

    public abstract DSLQuery visit(DSLQuery var1, Sort var2) throws PortalException;

    protected DSLQuery addLeftJoin(Column<?, Long> column, DSLQuery dslQuery, Table<?> table) {
        Stack<BaseASTNode> allBaseASTNodes = this.getAllBaseASTNodes(JoinStep.class, dslQuery);
        JoinStep joinStep = (JoinStep)allBaseASTNodes.pop();
        BaseASTNode baseASTNode = (BaseASTNode)joinStep.leftJoinOn(table, column.eq(this.getPrimaryKeyColumn(this.getTable(joinStep))));
        return this.updateParents(baseASTNode, allBaseASTNodes);
    }

    protected boolean contains(DSLQuery dslQuery, Table<?> table) {
        for (BaseASTNode baseASTNode = (BaseASTNode)dslQuery; baseASTNode != null; baseASTNode = (BaseASTNode)baseASTNode.getChild()) {
            Table<?> currentTable;
            if (!(baseASTNode instanceof JoinStep) || !StringUtil.equals((String)(currentTable = this.getTable((JoinStep)baseASTNode)).getName(), (String)table.getName())) continue;
            return true;
        }
        return false;
    }

    protected Table getAliasedTable(String prefix, Table table) {
        if (Validator.isBlank((String)prefix)) {
            return table;
        }
        return table.as(prefix + '_' + table.getName());
    }

    protected Stack<BaseASTNode> getAllBaseASTNodes(Class<?> clazz, DSLQuery dslQuery) {
        BaseASTNode baseASTNode;
        Stack<BaseASTNode> allBaseASTNodes = new Stack<BaseASTNode>();
        for (baseASTNode = (BaseASTNode)dslQuery; baseASTNode != null && !clazz.isInstance(baseASTNode); baseASTNode = (BaseASTNode)baseASTNode.getChild()) {
            allBaseASTNodes.push(baseASTNode);
        }
        if (baseASTNode == null) {
            throw new IllegalStateException("Base AST node is null");
        }
        allBaseASTNodes.push(baseASTNode);
        return allBaseASTNodes;
    }

    protected Column<?, Long> getPrimaryKeyColumn(Table<?> table) {
        if (table instanceof DynamicObjectDefinitionLocalizationTable) {
            DynamicObjectDefinitionLocalizationTable dynamicObjectDefinitionLocalizationTable = (DynamicObjectDefinitionLocalizationTable)table;
            return dynamicObjectDefinitionLocalizationTable.getForeignKeyColumn();
        }
        if (table instanceof DynamicObjectDefinitionTable) {
            DynamicObjectDefinitionTable dynamicObjectDefinitionTable = (DynamicObjectDefinitionTable)table;
            return dynamicObjectDefinitionTable.getPrimaryKeyColumn();
        }
        ObjectEntryTable objectEntryTable = (ObjectEntryTable)table;
        return objectEntryTable.objectEntryId;
    }

    protected Table<?> getTable(JoinStep joinStep) {
        if (joinStep instanceof From) {
            From from = (From)joinStep;
            return from.getTable();
        }
        if (joinStep instanceof Join) {
            Join join = (Join)joinStep;
            return join.getTable();
        }
        throw new RuntimeException();
    }

    protected DSLQuery updateParents(BaseASTNode baseASTNode, Stack<BaseASTNode> parentBaseASTNodes) {
        while (!parentBaseASTNodes.empty()) {
            BaseASTNode currentBaseASTNode = parentBaseASTNodes.pop();
            baseASTNode = currentBaseASTNode.withNewChild((ASTNode)baseASTNode);
        }
        return (DSLQuery)baseASTNode;
    }
}

