/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.model.listener;

import com.liferay.object.model.ObjectLayoutBox;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.security.audit.event.generators.util.Attribute;
import com.liferay.portal.security.audit.event.generators.util.AttributesBuilder;
import com.liferay.portal.security.audit.event.generators.util.AuditMessageBuilder;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class ObjectLayoutBoxModelListener
extends BaseModelListener<ObjectLayoutBox> {
    @Reference
    private AuditRouter _auditRouter;

    public void onBeforeCreate(ObjectLayoutBox objectLayoutBox) throws ModelListenerException {
        this._route("ADD", objectLayoutBox);
    }

    public void onBeforeRemove(ObjectLayoutBox objectLayoutBox) throws ModelListenerException {
        this._route("DELETE", objectLayoutBox);
    }

    public void onBeforeUpdate(ObjectLayoutBox originalObjectLayoutBox, ObjectLayoutBox objectLayoutBox) throws ModelListenerException {
        try {
            this._auditRouter.route(AuditMessageBuilder.buildAuditMessage((String)"UPDATE", (String)ObjectLayoutBox.class.getName(), (long)objectLayoutBox.getObjectLayoutBoxId(), this._getModifiedAttributes(originalObjectLayoutBox, objectLayoutBox)));
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }

    private List<Attribute> _getModifiedAttributes(ObjectLayoutBox originalObjectLayoutBox, ObjectLayoutBox objectLayoutBox) {
        AttributesBuilder attributesBuilder = new AttributesBuilder((Object)objectLayoutBox, (Object)originalObjectLayoutBox);
        attributesBuilder.add("collapsable");
        attributesBuilder.add("nameMap");
        attributesBuilder.add("objectLayoutTabId");
        attributesBuilder.add("priority");
        return attributesBuilder.getAttributes();
    }

    private void _route(String eventType, ObjectLayoutBox objectLayoutBox) throws ModelListenerException {
        try {
            AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)eventType, (String)ObjectLayoutBox.class.getName(), (long)objectLayoutBox.getObjectLayoutBoxId(), null);
            JSONObject additionalInfoJSONObject = auditMessage.getAdditionalInfo();
            additionalInfoJSONObject.put("collapsable", objectLayoutBox.isCollapsable()).put("nameMap", (Object)objectLayoutBox.getNameMap()).put("objectLayoutTabId", objectLayoutBox.getObjectLayoutTabId()).put("priority", objectLayoutBox.getPriority());
            this._auditRouter.route(auditMessage);
        }
        catch (Exception exception) {
            throw new ModelListenerException((Throwable)exception);
        }
    }
}

