/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.entry.util;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.petra.sql.dsl.DynamicObjectDefinitionTable;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.math.BigDecimal;

public class ObjectEntrySearchUtil {
    public static Predicate getObjectFieldPredicate(Column<?, Object> column, String dbType, String search) {
        if (dbType.equals("BigDecimal") || dbType.equals("Double")) {
            BigDecimal searchBigDecimal = BigDecimal.valueOf(GetterUtil.getDouble((String)search));
            if (searchBigDecimal.compareTo(BigDecimal.ZERO) != 0) {
                return column.eq((Object)searchBigDecimal);
            }
        } else {
            long searchLong;
            if (dbType.equals("Clob") || dbType.equals("String")) {
                return column.like("%" + search + "%");
            }
            if ((dbType.equals("Integer") || dbType.equals("Long")) && (searchLong = GetterUtil.getLong((String)search)) != 0L) {
                return column.eq((Object)searchLong);
            }
        }
        return null;
    }

    public static Predicate getRelatedModelsPredicate(DynamicObjectDefinitionTable dynamicObjectDefinitionTable, ObjectDefinition objectDefinition, ObjectFieldLocalService objectFieldLocalService, String search) {
        if (objectDefinition == null || Validator.isNull((String)search)) {
            return null;
        }
        ObjectField titleObjectField = objectFieldLocalService.fetchObjectField(objectDefinition.getTitleObjectFieldId());
        if (titleObjectField == null) {
            titleObjectField = objectFieldLocalService.fetchObjectField(objectDefinition.getObjectDefinitionId(), "id");
        }
        Predicate objectFieldPredicate = ObjectEntrySearchUtil.getObjectFieldPredicate(objectFieldLocalService.getColumn(objectDefinition.getObjectDefinitionId(), titleObjectField.getName()), titleObjectField.getDBType(), search);
        long searchLong = GetterUtil.getLong((String)search);
        if (searchLong == 0L) {
            return objectFieldPredicate;
        }
        Predicate primaryKeyPredicate = dynamicObjectDefinitionTable.getPrimaryKeyColumn().eq((Object)searchLong);
        if (objectFieldPredicate == null) {
            return primaryKeyPredicate;
        }
        return objectFieldPredicate.or((Expression)primaryKeyPredicate).withParentheses();
    }

    public static Predicate getUniqueCompositeKeyObjectFieldPredicate(Column<?, Object> column, String dbType, String value) {
        if (dbType.equals("Integer") || dbType.equals("Long")) {
            long valueLong = GetterUtil.getLong((String)value);
            if (valueLong != 0L) {
                return column.eq((Object)valueLong);
            }
        } else if (dbType.equals("String")) {
            return column.eq((Object)value);
        }
        return null;
    }
}

