/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.action.executor;

import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.object.action.executor.ObjectActionExecutor;
import com.liferay.object.entry.util.ObjectEntryThreadLocal;
import com.liferay.object.internal.action.util.ObjectEntryVariablesUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.rest.dto.v1_0.Status;
import com.liferay.object.rest.manager.v1_0.DefaultObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.DefaultObjectEntryManagerProvider;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManagerRegistry;
import com.liferay.object.service.ObjectActionLocalService;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.object.system.SystemObjectDefinitionManagerRegistry;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ObjectActionExecutor.class})
public class UpdateObjectEntryObjectActionExecutorImpl
implements ObjectActionExecutor {
    @Reference
    private DDMExpressionFactory _ddmExpressionFactory;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ObjectActionLocalService _objectActionLocalService;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryManagerRegistry _objectEntryManagerRegistry;
    @Reference
    private ObjectEntryLocalService _objectEntryService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    private final Set<String> _readOnlyObjectFieldNames = SetUtil.fromArray((Object[])new String[]{"creator", "createDate", "id", "modifiedDate", "status"});
    @Reference
    private SystemObjectDefinitionManagerRegistry _systemObjectDefinitionManagerRegistry;
    @Reference
    private UserLocalService _userLocalService;

    public void execute(long companyId, long objectActionId, UnicodeProperties parametersUnicodeProperties, JSONObject payloadJSONObject, long userId) throws Exception {
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(payloadJSONObject.getLong("objectDefinitionId"));
        TransactionCommitCallbackUtil.registerCallback(() -> {
            this._execute(objectActionId, objectDefinition, GetterUtil.getLong((Object)payloadJSONObject.getLong("classPK")), this._userLocalService.getUser(userId), this._getValues(objectDefinition, parametersUnicodeProperties, ObjectEntryVariablesUtil.getVariables(this._dtoConverterRegistry, objectDefinition, payloadJSONObject, this._systemObjectDefinitionManagerRegistry)));
            return null;
        });
    }

    public String getKey() {
        return "update-object-entry";
    }

    private void _execute(long objectActionId, ObjectDefinition objectDefinition, final long primaryKey, User user, final Map<String, Object> values) throws Exception {
        if (objectDefinition.isUnmodifiableSystemObject()) {
            SystemObjectDefinitionManager systemObjectDefinitionManager = this._systemObjectDefinitionManagerRegistry.getSystemObjectDefinitionManager(objectDefinition.getName());
            systemObjectDefinitionManager.updateBaseModel(primaryKey, user, values);
            return;
        }
        boolean skipObjectEntryResourcePermission = ObjectEntryThreadLocal.isSkipObjectEntryResourcePermission();
        try {
            ObjectEntryThreadLocal.setSkipObjectEntryResourcePermission((boolean)true);
            ObjectEntryThreadLocal.setSkipReadOnlyObjectFieldsValidation((boolean)true);
            DefaultObjectEntryManager defaultObjectEntryManager = DefaultObjectEntryManagerProvider.provide((ObjectEntryManager)this._objectEntryManagerRegistry.getObjectEntryManager(objectDefinition.getStorageType()));
            defaultObjectEntryManager.partialUpdateObjectEntry((DTOConverterContext)new DefaultDTOConverterContext(false, Collections.emptyMap(), this._dtoConverterRegistry, null, user.getLocale(), null, user), objectDefinition, primaryKey, new com.liferay.object.rest.dto.v1_0.ObjectEntry(){
                {
                    this.properties = values;
                    this.setStatus(() -> {
                        final ObjectEntry serviceBuilderObjectEntry = UpdateObjectEntryObjectActionExecutorImpl.this._objectEntryService.getObjectEntry(primaryKey);
                        return new Status(){
                            {
                                this.code = serviceBuilderObjectEntry.getStatus();
                            }
                        };
                    });
                }
            });
        }
        catch (Exception exception) {
            this._objectActionLocalService.updateStatus(objectActionId, 2);
            throw exception;
        }
        finally {
            ObjectEntryThreadLocal.setSkipObjectEntryResourcePermission((boolean)skipObjectEntryResourcePermission);
            ObjectEntryThreadLocal.setSkipReadOnlyObjectFieldsValidation((boolean)false);
        }
    }

    private Map<String, Object> _getValues(ObjectDefinition objectDefinition, UnicodeProperties parametersUnicodeProperties, Map<String, Object> variables) throws Exception {
        Map<String, Object> values = ObjectEntryVariablesUtil.getValues(this._ddmExpressionFactory, parametersUnicodeProperties, variables);
        Map baseModel = (Map)variables.get("baseModel");
        for (ObjectField objectField : this._objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId(), objectDefinition.isUnmodifiableSystemObject())) {
            if (this._readOnlyObjectFieldNames.contains(objectField.getName()) || values.containsKey(objectField.getName())) continue;
            values.put(objectField.getName(), baseModel.get(objectField.getName()));
        }
        return values;
    }
}

