/**
 * SPDX-FileCopyrightText: (c) 2023 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.object.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.object.model.ObjectFolder;
import com.liferay.object.model.ObjectFolderModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the ObjectFolder service. Represents a row in the &quot;ObjectFolder&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>ObjectFolderModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectFolderImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectFolderImpl
 * @generated
 */
@JSON(strict = true)
public class ObjectFolderModelImpl
	extends BaseModelImpl<ObjectFolder> implements ObjectFolderModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object folder model instance should use the <code>ObjectFolder</code> interface instead.
	 */
	public static final String TABLE_NAME = "ObjectFolder";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"externalReferenceCode", Types.VARCHAR},
		{"objectFolderId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"label", Types.VARCHAR}, {"name", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("objectFolderId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("label", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table ObjectFolder (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,externalReferenceCode VARCHAR(75) null,objectFolderId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,label STRING null,name VARCHAR(75) null)";

	public static final String TABLE_SQL_DROP = "drop table ObjectFolder";

	public static final String ORDER_BY_JPQL =
		" ORDER BY objectFolder.objectFolderId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY ObjectFolder.objectFolderId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NAME_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTFOLDERID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public ObjectFolderModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _objectFolderId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setObjectFolderId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _objectFolderId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return ObjectFolder.class;
	}

	@Override
	public String getModelClassName() {
		return ObjectFolder.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<ObjectFolder, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<ObjectFolder, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectFolder, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((ObjectFolder)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<ObjectFolder, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<ObjectFolder, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(ObjectFolder)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<ObjectFolder, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<ObjectFolder, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<ObjectFolder, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<ObjectFolder, Object>>
				attributeGetterFunctions =
					new LinkedHashMap<String, Function<ObjectFolder, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", ObjectFolder::getMvccVersion);
			attributeGetterFunctions.put("uuid", ObjectFolder::getUuid);
			attributeGetterFunctions.put(
				"externalReferenceCode",
				ObjectFolder::getExternalReferenceCode);
			attributeGetterFunctions.put(
				"objectFolderId", ObjectFolder::getObjectFolderId);
			attributeGetterFunctions.put(
				"companyId", ObjectFolder::getCompanyId);
			attributeGetterFunctions.put("userId", ObjectFolder::getUserId);
			attributeGetterFunctions.put("userName", ObjectFolder::getUserName);
			attributeGetterFunctions.put(
				"createDate", ObjectFolder::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", ObjectFolder::getModifiedDate);
			attributeGetterFunctions.put("label", ObjectFolder::getLabel);
			attributeGetterFunctions.put("name", ObjectFolder::getName);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<ObjectFolder, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<ObjectFolder, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap<String, BiConsumer<ObjectFolder, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<ObjectFolder, Long>)ObjectFolder::setMvccVersion);
			attributeSetterBiConsumers.put(
				"uuid",
				(BiConsumer<ObjectFolder, String>)ObjectFolder::setUuid);
			attributeSetterBiConsumers.put(
				"externalReferenceCode",
				(BiConsumer<ObjectFolder, String>)
					ObjectFolder::setExternalReferenceCode);
			attributeSetterBiConsumers.put(
				"objectFolderId",
				(BiConsumer<ObjectFolder, Long>)
					ObjectFolder::setObjectFolderId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<ObjectFolder, Long>)ObjectFolder::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<ObjectFolder, Long>)ObjectFolder::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<ObjectFolder, String>)ObjectFolder::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<ObjectFolder, Date>)ObjectFolder::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<ObjectFolder, Date>)ObjectFolder::setModifiedDate);
			attributeSetterBiConsumers.put(
				"label",
				(BiConsumer<ObjectFolder, String>)ObjectFolder::setLabel);
			attributeSetterBiConsumers.put(
				"name",
				(BiConsumer<ObjectFolder, String>)ObjectFolder::setName);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalReferenceCode = externalReferenceCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalReferenceCode() {
		return getColumnOriginalValue("externalReferenceCode");
	}

	@JSON
	@Override
	public long getObjectFolderId() {
		return _objectFolderId;
	}

	@Override
	public void setObjectFolderId(long objectFolderId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectFolderId = objectFolderId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public String getLabel() {
		if (_label == null) {
			return "";
		}
		else {
			return _label;
		}
	}

	@Override
	public String getLabel(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getLabel(languageId);
	}

	@Override
	public String getLabel(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getLabel(languageId, useDefault);
	}

	@Override
	public String getLabel(String languageId) {
		return LocalizationUtil.getLocalization(getLabel(), languageId);
	}

	@Override
	public String getLabel(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getLabel(), languageId, useDefault);
	}

	@Override
	public String getLabelCurrentLanguageId() {
		return _labelCurrentLanguageId;
	}

	@JSON
	@Override
	public String getLabelCurrentValue() {
		Locale locale = getLocale(_labelCurrentLanguageId);

		return getLabel(locale);
	}

	@Override
	public Map<Locale, String> getLabelMap() {
		return LocalizationUtil.getLocalizationMap(getLabel());
	}

	@Override
	public void setLabel(String label) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_label = label;
	}

	@Override
	public void setLabel(String label, Locale locale) {
		setLabel(label, locale, LocaleUtil.getDefault());
	}

	@Override
	public void setLabel(String label, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(label)) {
			setLabel(
				LocalizationUtil.updateLocalization(
					getLabel(), "Label", label, languageId, defaultLanguageId));
		}
		else {
			setLabel(
				LocalizationUtil.removeLocalization(
					getLabel(), "Label", languageId));
		}
	}

	@Override
	public void setLabelCurrentLanguageId(String languageId) {
		_labelCurrentLanguageId = languageId;
	}

	@Override
	public void setLabelMap(Map<Locale, String> labelMap) {
		setLabelMap(labelMap, LocaleUtil.getDefault());
	}

	@Override
	public void setLabelMap(
		Map<Locale, String> labelMap, Locale defaultLocale) {

		if (labelMap == null) {
			return;
		}

		setLabel(
			LocalizationUtil.updateLocalization(
				labelMap, getLabel(), "Label",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalName() {
		return getColumnOriginalValue("name");
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(ObjectFolder.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), ObjectFolder.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> labelMap = getLabelMap();

		for (Map.Entry<Locale, String> entry : labelMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(
			new String[availableLanguageIds.size()]);
	}

	@Override
	public String getDefaultLanguageId() {
		String xml = getLabel();

		if (xml == null) {
			return "";
		}

		Locale defaultLocale = LocaleUtil.getDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException {
		Locale defaultLocale = LocaleUtil.fromLanguageId(
			getDefaultLanguageId());

		Locale[] availableLocales = LocaleUtil.fromLanguageIds(
			getAvailableLanguageIds());

		Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(
			ObjectFolder.class.getName(), getPrimaryKey(), defaultLocale,
			availableLocales);

		prepareLocalizedFieldsForImport(defaultImportLocale);
	}

	@Override
	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {

		Locale defaultLocale = LocaleUtil.getDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String label = getLabel(defaultLocale);

		if (Validator.isNull(label)) {
			setLabel(getLabel(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setLabel(getLabel(defaultLocale), defaultLocale, defaultLocale);
		}
	}

	@Override
	public ObjectFolder toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, ObjectFolder>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		ObjectFolderImpl objectFolderImpl = new ObjectFolderImpl();

		objectFolderImpl.setMvccVersion(getMvccVersion());
		objectFolderImpl.setUuid(getUuid());
		objectFolderImpl.setExternalReferenceCode(getExternalReferenceCode());
		objectFolderImpl.setObjectFolderId(getObjectFolderId());
		objectFolderImpl.setCompanyId(getCompanyId());
		objectFolderImpl.setUserId(getUserId());
		objectFolderImpl.setUserName(getUserName());
		objectFolderImpl.setCreateDate(getCreateDate());
		objectFolderImpl.setModifiedDate(getModifiedDate());
		objectFolderImpl.setLabel(getLabel());
		objectFolderImpl.setName(getName());

		objectFolderImpl.resetOriginalValues();

		return objectFolderImpl;
	}

	@Override
	public ObjectFolder cloneWithOriginalValues() {
		ObjectFolderImpl objectFolderImpl = new ObjectFolderImpl();

		objectFolderImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		objectFolderImpl.setUuid(this.<String>getColumnOriginalValue("uuid_"));
		objectFolderImpl.setExternalReferenceCode(
			this.<String>getColumnOriginalValue("externalReferenceCode"));
		objectFolderImpl.setObjectFolderId(
			this.<Long>getColumnOriginalValue("objectFolderId"));
		objectFolderImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		objectFolderImpl.setUserId(this.<Long>getColumnOriginalValue("userId"));
		objectFolderImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		objectFolderImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		objectFolderImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		objectFolderImpl.setLabel(this.<String>getColumnOriginalValue("label"));
		objectFolderImpl.setName(this.<String>getColumnOriginalValue("name"));

		return objectFolderImpl;
	}

	@Override
	public int compareTo(ObjectFolder objectFolder) {
		long primaryKey = objectFolder.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof ObjectFolder)) {
			return false;
		}

		ObjectFolder objectFolder = (ObjectFolder)object;

		long primaryKey = objectFolder.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<ObjectFolder> toCacheModel() {
		ObjectFolderCacheModel objectFolderCacheModel =
			new ObjectFolderCacheModel();

		objectFolderCacheModel.mvccVersion = getMvccVersion();

		objectFolderCacheModel.uuid = getUuid();

		String uuid = objectFolderCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			objectFolderCacheModel.uuid = null;
		}

		objectFolderCacheModel.externalReferenceCode =
			getExternalReferenceCode();

		String externalReferenceCode =
			objectFolderCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			objectFolderCacheModel.externalReferenceCode = null;
		}

		objectFolderCacheModel.objectFolderId = getObjectFolderId();

		objectFolderCacheModel.companyId = getCompanyId();

		objectFolderCacheModel.userId = getUserId();

		objectFolderCacheModel.userName = getUserName();

		String userName = objectFolderCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			objectFolderCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			objectFolderCacheModel.createDate = createDate.getTime();
		}
		else {
			objectFolderCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			objectFolderCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			objectFolderCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		objectFolderCacheModel.label = getLabel();

		String label = objectFolderCacheModel.label;

		if ((label != null) && (label.length() == 0)) {
			objectFolderCacheModel.label = null;
		}

		objectFolderCacheModel.name = getName();

		String name = objectFolderCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			objectFolderCacheModel.name = null;
		}

		return objectFolderCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<ObjectFolder, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<ObjectFolder, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectFolder, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((ObjectFolder)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, ObjectFolder>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					ObjectFolder.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private String _externalReferenceCode;
	private long _objectFolderId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private String _label;
	private String _labelCurrentLanguageId;
	private String _name;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<ObjectFolder, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((ObjectFolder)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"externalReferenceCode", _externalReferenceCode);
		_columnOriginalValues.put("objectFolderId", _objectFolderId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("label", _label);
		_columnOriginalValues.put("name", _name);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("externalReferenceCode", 4L);

		columnBitmasks.put("objectFolderId", 8L);

		columnBitmasks.put("companyId", 16L);

		columnBitmasks.put("userId", 32L);

		columnBitmasks.put("userName", 64L);

		columnBitmasks.put("createDate", 128L);

		columnBitmasks.put("modifiedDate", 256L);

		columnBitmasks.put("label", 512L);

		columnBitmasks.put("name", 1024L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private ObjectFolder _escapedModel;

}