/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.object.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.object.model.ObjectAction;
import com.liferay.object.model.ObjectActionModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the ObjectAction service. Represents a row in the &quot;ObjectAction&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>ObjectActionModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectActionImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectActionImpl
 * @generated
 */
@JSON(strict = true)
public class ObjectActionModelImpl
	extends BaseModelImpl<ObjectAction> implements ObjectActionModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object action model instance should use the <code>ObjectAction</code> interface instead.
	 */
	public static final String TABLE_NAME = "ObjectAction";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"externalReferenceCode", Types.VARCHAR},
		{"objectActionId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"objectDefinitionId", Types.BIGINT}, {"active_", Types.BOOLEAN},
		{"conditionExpression", Types.CLOB}, {"description", Types.VARCHAR},
		{"errorMessage", Types.VARCHAR}, {"label", Types.VARCHAR},
		{"name", Types.VARCHAR}, {"objectActionExecutorKey", Types.VARCHAR},
		{"objectActionTriggerKey", Types.VARCHAR}, {"parameters", Types.CLOB},
		{"system_", Types.BOOLEAN}, {"status", Types.INTEGER}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("objectActionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("objectDefinitionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("active_", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("conditionExpression", Types.CLOB);
		TABLE_COLUMNS_MAP.put("description", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("errorMessage", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("label", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("objectActionExecutorKey", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("objectActionTriggerKey", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("parameters", Types.CLOB);
		TABLE_COLUMNS_MAP.put("system_", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
	}

	public static final String TABLE_SQL_CREATE =
		"create table ObjectAction (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,externalReferenceCode VARCHAR(75) null,objectActionId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,objectDefinitionId LONG,active_ BOOLEAN,conditionExpression TEXT null,description VARCHAR(75) null,errorMessage STRING null,label STRING null,name VARCHAR(75) null,objectActionExecutorKey VARCHAR(255) null,objectActionTriggerKey VARCHAR(75) null,parameters TEXT null,system_ BOOLEAN,status INTEGER)";

	public static final String TABLE_SQL_DROP = "drop table ObjectAction";

	public static final String ORDER_BY_JPQL =
		" ORDER BY objectAction.objectActionId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY ObjectAction.objectActionId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long ACTIVE_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NAME_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTACTIONTRIGGERKEY_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTDEFINITIONID_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long OBJECTACTIONID_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public ObjectActionModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _objectActionId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setObjectActionId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _objectActionId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return ObjectAction.class;
	}

	@Override
	public String getModelClassName() {
		return ObjectAction.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<ObjectAction, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<ObjectAction, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectAction, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((ObjectAction)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<ObjectAction, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<ObjectAction, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(ObjectAction)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<ObjectAction, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<ObjectAction, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<ObjectAction, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<ObjectAction, Object>>
				attributeGetterFunctions =
					new LinkedHashMap<String, Function<ObjectAction, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", ObjectAction::getMvccVersion);
			attributeGetterFunctions.put("uuid", ObjectAction::getUuid);
			attributeGetterFunctions.put(
				"externalReferenceCode",
				ObjectAction::getExternalReferenceCode);
			attributeGetterFunctions.put(
				"objectActionId", ObjectAction::getObjectActionId);
			attributeGetterFunctions.put(
				"companyId", ObjectAction::getCompanyId);
			attributeGetterFunctions.put("userId", ObjectAction::getUserId);
			attributeGetterFunctions.put("userName", ObjectAction::getUserName);
			attributeGetterFunctions.put(
				"createDate", ObjectAction::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", ObjectAction::getModifiedDate);
			attributeGetterFunctions.put(
				"objectDefinitionId", ObjectAction::getObjectDefinitionId);
			attributeGetterFunctions.put("active", ObjectAction::getActive);
			attributeGetterFunctions.put(
				"conditionExpression", ObjectAction::getConditionExpression);
			attributeGetterFunctions.put(
				"description", ObjectAction::getDescription);
			attributeGetterFunctions.put(
				"errorMessage", ObjectAction::getErrorMessage);
			attributeGetterFunctions.put("label", ObjectAction::getLabel);
			attributeGetterFunctions.put("name", ObjectAction::getName);
			attributeGetterFunctions.put(
				"objectActionExecutorKey",
				ObjectAction::getObjectActionExecutorKey);
			attributeGetterFunctions.put(
				"objectActionTriggerKey",
				ObjectAction::getObjectActionTriggerKey);
			attributeGetterFunctions.put(
				"parameters", ObjectAction::getParameters);
			attributeGetterFunctions.put("system", ObjectAction::getSystem);
			attributeGetterFunctions.put("status", ObjectAction::getStatus);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<ObjectAction, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<ObjectAction, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap<String, BiConsumer<ObjectAction, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<ObjectAction, Long>)ObjectAction::setMvccVersion);
			attributeSetterBiConsumers.put(
				"uuid",
				(BiConsumer<ObjectAction, String>)ObjectAction::setUuid);
			attributeSetterBiConsumers.put(
				"externalReferenceCode",
				(BiConsumer<ObjectAction, String>)
					ObjectAction::setExternalReferenceCode);
			attributeSetterBiConsumers.put(
				"objectActionId",
				(BiConsumer<ObjectAction, Long>)
					ObjectAction::setObjectActionId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<ObjectAction, Long>)ObjectAction::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<ObjectAction, Long>)ObjectAction::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<ObjectAction, String>)ObjectAction::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<ObjectAction, Date>)ObjectAction::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<ObjectAction, Date>)ObjectAction::setModifiedDate);
			attributeSetterBiConsumers.put(
				"objectDefinitionId",
				(BiConsumer<ObjectAction, Long>)
					ObjectAction::setObjectDefinitionId);
			attributeSetterBiConsumers.put(
				"active",
				(BiConsumer<ObjectAction, Boolean>)ObjectAction::setActive);
			attributeSetterBiConsumers.put(
				"conditionExpression",
				(BiConsumer<ObjectAction, String>)
					ObjectAction::setConditionExpression);
			attributeSetterBiConsumers.put(
				"description",
				(BiConsumer<ObjectAction, String>)ObjectAction::setDescription);
			attributeSetterBiConsumers.put(
				"errorMessage",
				(BiConsumer<ObjectAction, String>)
					ObjectAction::setErrorMessage);
			attributeSetterBiConsumers.put(
				"label",
				(BiConsumer<ObjectAction, String>)ObjectAction::setLabel);
			attributeSetterBiConsumers.put(
				"name",
				(BiConsumer<ObjectAction, String>)ObjectAction::setName);
			attributeSetterBiConsumers.put(
				"objectActionExecutorKey",
				(BiConsumer<ObjectAction, String>)
					ObjectAction::setObjectActionExecutorKey);
			attributeSetterBiConsumers.put(
				"objectActionTriggerKey",
				(BiConsumer<ObjectAction, String>)
					ObjectAction::setObjectActionTriggerKey);
			attributeSetterBiConsumers.put(
				"parameters",
				(BiConsumer<ObjectAction, String>)ObjectAction::setParameters);
			attributeSetterBiConsumers.put(
				"system",
				(BiConsumer<ObjectAction, Boolean>)ObjectAction::setSystem);
			attributeSetterBiConsumers.put(
				"status",
				(BiConsumer<ObjectAction, Integer>)ObjectAction::setStatus);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalReferenceCode = externalReferenceCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalReferenceCode() {
		return getColumnOriginalValue("externalReferenceCode");
	}

	@JSON
	@Override
	public long getObjectActionId() {
		return _objectActionId;
	}

	@Override
	public void setObjectActionId(long objectActionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectActionId = objectActionId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getObjectDefinitionId() {
		return _objectDefinitionId;
	}

	@Override
	public void setObjectDefinitionId(long objectDefinitionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectDefinitionId = objectDefinitionId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalObjectDefinitionId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("objectDefinitionId"));
	}

	@JSON
	@Override
	public boolean getActive() {
		return _active;
	}

	@JSON
	@Override
	public boolean isActive() {
		return _active;
	}

	@Override
	public void setActive(boolean active) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_active = active;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalActive() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("active_"));
	}

	@JSON
	@Override
	public String getConditionExpression() {
		if (_conditionExpression == null) {
			return "";
		}
		else {
			return _conditionExpression;
		}
	}

	@Override
	public void setConditionExpression(String conditionExpression) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_conditionExpression = conditionExpression;
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public void setDescription(String description) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_description = description;
	}

	@JSON
	@Override
	public String getErrorMessage() {
		if (_errorMessage == null) {
			return "";
		}
		else {
			return _errorMessage;
		}
	}

	@Override
	public String getErrorMessage(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getErrorMessage(languageId);
	}

	@Override
	public String getErrorMessage(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getErrorMessage(languageId, useDefault);
	}

	@Override
	public String getErrorMessage(String languageId) {
		return LocalizationUtil.getLocalization(getErrorMessage(), languageId);
	}

	@Override
	public String getErrorMessage(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getErrorMessage(), languageId, useDefault);
	}

	@Override
	public String getErrorMessageCurrentLanguageId() {
		return _errorMessageCurrentLanguageId;
	}

	@JSON
	@Override
	public String getErrorMessageCurrentValue() {
		Locale locale = getLocale(_errorMessageCurrentLanguageId);

		return getErrorMessage(locale);
	}

	@Override
	public Map<Locale, String> getErrorMessageMap() {
		return LocalizationUtil.getLocalizationMap(getErrorMessage());
	}

	@Override
	public void setErrorMessage(String errorMessage) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_errorMessage = errorMessage;
	}

	@Override
	public void setErrorMessage(String errorMessage, Locale locale) {
		setErrorMessage(errorMessage, locale, LocaleUtil.getDefault());
	}

	@Override
	public void setErrorMessage(
		String errorMessage, Locale locale, Locale defaultLocale) {

		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(errorMessage)) {
			setErrorMessage(
				LocalizationUtil.updateLocalization(
					getErrorMessage(), "ErrorMessage", errorMessage, languageId,
					defaultLanguageId));
		}
		else {
			setErrorMessage(
				LocalizationUtil.removeLocalization(
					getErrorMessage(), "ErrorMessage", languageId));
		}
	}

	@Override
	public void setErrorMessageCurrentLanguageId(String languageId) {
		_errorMessageCurrentLanguageId = languageId;
	}

	@Override
	public void setErrorMessageMap(Map<Locale, String> errorMessageMap) {
		setErrorMessageMap(errorMessageMap, LocaleUtil.getDefault());
	}

	@Override
	public void setErrorMessageMap(
		Map<Locale, String> errorMessageMap, Locale defaultLocale) {

		if (errorMessageMap == null) {
			return;
		}

		setErrorMessage(
			LocalizationUtil.updateLocalization(
				errorMessageMap, getErrorMessage(), "ErrorMessage",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getLabel() {
		if (_label == null) {
			return "";
		}
		else {
			return _label;
		}
	}

	@Override
	public String getLabel(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getLabel(languageId);
	}

	@Override
	public String getLabel(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getLabel(languageId, useDefault);
	}

	@Override
	public String getLabel(String languageId) {
		return LocalizationUtil.getLocalization(getLabel(), languageId);
	}

	@Override
	public String getLabel(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getLabel(), languageId, useDefault);
	}

	@Override
	public String getLabelCurrentLanguageId() {
		return _labelCurrentLanguageId;
	}

	@JSON
	@Override
	public String getLabelCurrentValue() {
		Locale locale = getLocale(_labelCurrentLanguageId);

		return getLabel(locale);
	}

	@Override
	public Map<Locale, String> getLabelMap() {
		return LocalizationUtil.getLocalizationMap(getLabel());
	}

	@Override
	public void setLabel(String label) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_label = label;
	}

	@Override
	public void setLabel(String label, Locale locale) {
		setLabel(label, locale, LocaleUtil.getDefault());
	}

	@Override
	public void setLabel(String label, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(label)) {
			setLabel(
				LocalizationUtil.updateLocalization(
					getLabel(), "Label", label, languageId, defaultLanguageId));
		}
		else {
			setLabel(
				LocalizationUtil.removeLocalization(
					getLabel(), "Label", languageId));
		}
	}

	@Override
	public void setLabelCurrentLanguageId(String languageId) {
		_labelCurrentLanguageId = languageId;
	}

	@Override
	public void setLabelMap(Map<Locale, String> labelMap) {
		setLabelMap(labelMap, LocaleUtil.getDefault());
	}

	@Override
	public void setLabelMap(
		Map<Locale, String> labelMap, Locale defaultLocale) {

		if (labelMap == null) {
			return;
		}

		setLabel(
			LocalizationUtil.updateLocalization(
				labelMap, getLabel(), "Label",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalName() {
		return getColumnOriginalValue("name");
	}

	@JSON
	@Override
	public String getObjectActionExecutorKey() {
		if (_objectActionExecutorKey == null) {
			return "";
		}
		else {
			return _objectActionExecutorKey;
		}
	}

	@Override
	public void setObjectActionExecutorKey(String objectActionExecutorKey) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectActionExecutorKey = objectActionExecutorKey;
	}

	@JSON
	@Override
	public String getObjectActionTriggerKey() {
		if (_objectActionTriggerKey == null) {
			return "";
		}
		else {
			return _objectActionTriggerKey;
		}
	}

	@Override
	public void setObjectActionTriggerKey(String objectActionTriggerKey) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectActionTriggerKey = objectActionTriggerKey;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalObjectActionTriggerKey() {
		return getColumnOriginalValue("objectActionTriggerKey");
	}

	@JSON
	@Override
	public String getParameters() {
		if (_parameters == null) {
			return "";
		}
		else {
			return _parameters;
		}
	}

	@Override
	public void setParameters(String parameters) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_parameters = parameters;
	}

	@JSON
	@Override
	public boolean getSystem() {
		return _system;
	}

	@JSON
	@Override
	public boolean isSystem() {
		return _system;
	}

	@Override
	public void setSystem(boolean system) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_system = system;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(ObjectAction.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), ObjectAction.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> errorMessageMap = getErrorMessageMap();

		for (Map.Entry<Locale, String> entry : errorMessageMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> labelMap = getLabelMap();

		for (Map.Entry<Locale, String> entry : labelMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(
			new String[availableLanguageIds.size()]);
	}

	@Override
	public String getDefaultLanguageId() {
		String xml = getErrorMessage();

		if (xml == null) {
			return "";
		}

		Locale defaultLocale = LocaleUtil.getDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException {
		Locale defaultLocale = LocaleUtil.fromLanguageId(
			getDefaultLanguageId());

		Locale[] availableLocales = LocaleUtil.fromLanguageIds(
			getAvailableLanguageIds());

		Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(
			ObjectAction.class.getName(), getPrimaryKey(), defaultLocale,
			availableLocales);

		prepareLocalizedFieldsForImport(defaultImportLocale);
	}

	@Override
	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {

		Locale defaultLocale = LocaleUtil.getDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String errorMessage = getErrorMessage(defaultLocale);

		if (Validator.isNull(errorMessage)) {
			setErrorMessage(
				getErrorMessage(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setErrorMessage(
				getErrorMessage(defaultLocale), defaultLocale, defaultLocale);
		}

		String label = getLabel(defaultLocale);

		if (Validator.isNull(label)) {
			setLabel(getLabel(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setLabel(getLabel(defaultLocale), defaultLocale, defaultLocale);
		}
	}

	@Override
	public ObjectAction toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, ObjectAction>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		ObjectActionImpl objectActionImpl = new ObjectActionImpl();

		objectActionImpl.setMvccVersion(getMvccVersion());
		objectActionImpl.setUuid(getUuid());
		objectActionImpl.setExternalReferenceCode(getExternalReferenceCode());
		objectActionImpl.setObjectActionId(getObjectActionId());
		objectActionImpl.setCompanyId(getCompanyId());
		objectActionImpl.setUserId(getUserId());
		objectActionImpl.setUserName(getUserName());
		objectActionImpl.setCreateDate(getCreateDate());
		objectActionImpl.setModifiedDate(getModifiedDate());
		objectActionImpl.setObjectDefinitionId(getObjectDefinitionId());
		objectActionImpl.setActive(isActive());
		objectActionImpl.setConditionExpression(getConditionExpression());
		objectActionImpl.setDescription(getDescription());
		objectActionImpl.setErrorMessage(getErrorMessage());
		objectActionImpl.setLabel(getLabel());
		objectActionImpl.setName(getName());
		objectActionImpl.setObjectActionExecutorKey(
			getObjectActionExecutorKey());
		objectActionImpl.setObjectActionTriggerKey(getObjectActionTriggerKey());
		objectActionImpl.setParameters(getParameters());
		objectActionImpl.setSystem(isSystem());
		objectActionImpl.setStatus(getStatus());

		objectActionImpl.resetOriginalValues();

		return objectActionImpl;
	}

	@Override
	public ObjectAction cloneWithOriginalValues() {
		ObjectActionImpl objectActionImpl = new ObjectActionImpl();

		objectActionImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		objectActionImpl.setUuid(this.<String>getColumnOriginalValue("uuid_"));
		objectActionImpl.setExternalReferenceCode(
			this.<String>getColumnOriginalValue("externalReferenceCode"));
		objectActionImpl.setObjectActionId(
			this.<Long>getColumnOriginalValue("objectActionId"));
		objectActionImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		objectActionImpl.setUserId(this.<Long>getColumnOriginalValue("userId"));
		objectActionImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		objectActionImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		objectActionImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		objectActionImpl.setObjectDefinitionId(
			this.<Long>getColumnOriginalValue("objectDefinitionId"));
		objectActionImpl.setActive(
			this.<Boolean>getColumnOriginalValue("active_"));
		objectActionImpl.setConditionExpression(
			this.<String>getColumnOriginalValue("conditionExpression"));
		objectActionImpl.setDescription(
			this.<String>getColumnOriginalValue("description"));
		objectActionImpl.setErrorMessage(
			this.<String>getColumnOriginalValue("errorMessage"));
		objectActionImpl.setLabel(this.<String>getColumnOriginalValue("label"));
		objectActionImpl.setName(this.<String>getColumnOriginalValue("name"));
		objectActionImpl.setObjectActionExecutorKey(
			this.<String>getColumnOriginalValue("objectActionExecutorKey"));
		objectActionImpl.setObjectActionTriggerKey(
			this.<String>getColumnOriginalValue("objectActionTriggerKey"));
		objectActionImpl.setParameters(
			this.<String>getColumnOriginalValue("parameters"));
		objectActionImpl.setSystem(
			this.<Boolean>getColumnOriginalValue("system_"));
		objectActionImpl.setStatus(
			this.<Integer>getColumnOriginalValue("status"));

		return objectActionImpl;
	}

	@Override
	public int compareTo(ObjectAction objectAction) {
		long primaryKey = objectAction.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof ObjectAction)) {
			return false;
		}

		ObjectAction objectAction = (ObjectAction)object;

		long primaryKey = objectAction.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<ObjectAction> toCacheModel() {
		ObjectActionCacheModel objectActionCacheModel =
			new ObjectActionCacheModel();

		objectActionCacheModel.mvccVersion = getMvccVersion();

		objectActionCacheModel.uuid = getUuid();

		String uuid = objectActionCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			objectActionCacheModel.uuid = null;
		}

		objectActionCacheModel.externalReferenceCode =
			getExternalReferenceCode();

		String externalReferenceCode =
			objectActionCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			objectActionCacheModel.externalReferenceCode = null;
		}

		objectActionCacheModel.objectActionId = getObjectActionId();

		objectActionCacheModel.companyId = getCompanyId();

		objectActionCacheModel.userId = getUserId();

		objectActionCacheModel.userName = getUserName();

		String userName = objectActionCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			objectActionCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			objectActionCacheModel.createDate = createDate.getTime();
		}
		else {
			objectActionCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			objectActionCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			objectActionCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		objectActionCacheModel.objectDefinitionId = getObjectDefinitionId();

		objectActionCacheModel.active = isActive();

		objectActionCacheModel.conditionExpression = getConditionExpression();

		String conditionExpression = objectActionCacheModel.conditionExpression;

		if ((conditionExpression != null) &&
			(conditionExpression.length() == 0)) {

			objectActionCacheModel.conditionExpression = null;
		}

		objectActionCacheModel.description = getDescription();

		String description = objectActionCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			objectActionCacheModel.description = null;
		}

		objectActionCacheModel.errorMessage = getErrorMessage();

		String errorMessage = objectActionCacheModel.errorMessage;

		if ((errorMessage != null) && (errorMessage.length() == 0)) {
			objectActionCacheModel.errorMessage = null;
		}

		objectActionCacheModel.label = getLabel();

		String label = objectActionCacheModel.label;

		if ((label != null) && (label.length() == 0)) {
			objectActionCacheModel.label = null;
		}

		objectActionCacheModel.name = getName();

		String name = objectActionCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			objectActionCacheModel.name = null;
		}

		objectActionCacheModel.objectActionExecutorKey =
			getObjectActionExecutorKey();

		String objectActionExecutorKey =
			objectActionCacheModel.objectActionExecutorKey;

		if ((objectActionExecutorKey != null) &&
			(objectActionExecutorKey.length() == 0)) {

			objectActionCacheModel.objectActionExecutorKey = null;
		}

		objectActionCacheModel.objectActionTriggerKey =
			getObjectActionTriggerKey();

		String objectActionTriggerKey =
			objectActionCacheModel.objectActionTriggerKey;

		if ((objectActionTriggerKey != null) &&
			(objectActionTriggerKey.length() == 0)) {

			objectActionCacheModel.objectActionTriggerKey = null;
		}

		objectActionCacheModel.parameters = getParameters();

		String parameters = objectActionCacheModel.parameters;

		if ((parameters != null) && (parameters.length() == 0)) {
			objectActionCacheModel.parameters = null;
		}

		objectActionCacheModel.system = isSystem();

		objectActionCacheModel.status = getStatus();

		return objectActionCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<ObjectAction, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<ObjectAction, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectAction, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((ObjectAction)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, ObjectAction>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					ObjectAction.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private String _externalReferenceCode;
	private long _objectActionId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _objectDefinitionId;
	private boolean _active;
	private String _conditionExpression;
	private String _description;
	private String _errorMessage;
	private String _errorMessageCurrentLanguageId;
	private String _label;
	private String _labelCurrentLanguageId;
	private String _name;
	private String _objectActionExecutorKey;
	private String _objectActionTriggerKey;
	private String _parameters;
	private boolean _system;
	private int _status;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<ObjectAction, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((ObjectAction)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"externalReferenceCode", _externalReferenceCode);
		_columnOriginalValues.put("objectActionId", _objectActionId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("objectDefinitionId", _objectDefinitionId);
		_columnOriginalValues.put("active_", _active);
		_columnOriginalValues.put("conditionExpression", _conditionExpression);
		_columnOriginalValues.put("description", _description);
		_columnOriginalValues.put("errorMessage", _errorMessage);
		_columnOriginalValues.put("label", _label);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put(
			"objectActionExecutorKey", _objectActionExecutorKey);
		_columnOriginalValues.put(
			"objectActionTriggerKey", _objectActionTriggerKey);
		_columnOriginalValues.put("parameters", _parameters);
		_columnOriginalValues.put("system_", _system);
		_columnOriginalValues.put("status", _status);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("active_", "active");
		attributeNames.put("system_", "system");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("externalReferenceCode", 4L);

		columnBitmasks.put("objectActionId", 8L);

		columnBitmasks.put("companyId", 16L);

		columnBitmasks.put("userId", 32L);

		columnBitmasks.put("userName", 64L);

		columnBitmasks.put("createDate", 128L);

		columnBitmasks.put("modifiedDate", 256L);

		columnBitmasks.put("objectDefinitionId", 512L);

		columnBitmasks.put("active_", 1024L);

		columnBitmasks.put("conditionExpression", 2048L);

		columnBitmasks.put("description", 4096L);

		columnBitmasks.put("errorMessage", 8192L);

		columnBitmasks.put("label", 16384L);

		columnBitmasks.put("name", 32768L);

		columnBitmasks.put("objectActionExecutorKey", 65536L);

		columnBitmasks.put("objectActionTriggerKey", 131072L);

		columnBitmasks.put("parameters", 262144L);

		columnBitmasks.put("system_", 524288L);

		columnBitmasks.put("status", 1048576L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private ObjectAction _escapedModel;

}