/**
 * SPDX-FileCopyrightText: (c) 2023 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.object.internal.search;

import com.liferay.object.model.ObjectValidationRule;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.search.spi.model.index.contributor.ModelIndexerWriterContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchConfigurator;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Marcela Cunha
 */
@Component(service = ModelSearchConfigurator.class)
public class ObjectValidationRuleModelSearchConfigurator
	implements ModelSearchConfigurator<ObjectValidationRule> {

	@Override
	public String getClassName() {
		return ObjectValidationRule.class.getName();
	}

	@Override
	public String[] getDefaultSelectedFieldNames() {
		return new String[] {
			Field.COMPANY_ID, Field.ENTRY_CLASS_NAME, Field.ENTRY_CLASS_PK,
			Field.UID
		};
	}

	@Override
	public String[] getDefaultSelectedLocalizedFieldNames() {
		return new String[] {Field.NAME};
	}

	@Override
	public ModelIndexerWriterContributor<ObjectValidationRule>
		getModelIndexerWriterContributor() {

		return _modelIndexWriterContributor;
	}

	@Reference(
		target = "(indexer.class.name=com.liferay.object.model.ObjectValidationRule)"
	)
	private ModelIndexerWriterContributor<ObjectValidationRule>
		_modelIndexWriterContributor;

}