/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.service.impl;

import com.liferay.object.model.ObjectFilter;
import com.liferay.object.service.base.ObjectFilterLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;

import java.util.List;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Marco Leo
 */
@Component(
	property = "model.class.name=com.liferay.object.model.ObjectFilter",
	service = AopService.class
)
public class ObjectFilterLocalServiceImpl
	extends ObjectFilterLocalServiceBaseImpl {

	@Override
	public ObjectFilter addObjectFilter(
			long userId, long objectFieldId, String filterBy, String filterType,
			String json)
		throws PortalException {

		ObjectFilter objectFilter = objectFilterPersistence.create(
			counterLocalService.increment());

		User user = _userLocalService.getUser(userId);

		objectFilter.setCompanyId(user.getCompanyId());
		objectFilter.setUserId(user.getUserId());
		objectFilter.setUserName(user.getFullName());

		objectFilter.setObjectFieldId(objectFieldId);
		objectFilter.setFilterBy(filterBy);
		objectFilter.setFilterType(filterType);
		objectFilter.setJSON(json);

		return objectFilterPersistence.update(objectFilter);
	}

	@Override
	public void deleteObjectFieldObjectFilter(long objectFieldId) {
		objectFilterPersistence.removeByObjectFieldId(objectFieldId);
	}

	@Override
	public List<ObjectFilter> getObjectFieldObjectFilter(long objectFieldId) {
		return objectFilterPersistence.findByObjectFieldId(objectFieldId);
	}

	@Reference
	private UserLocalService _userLocalService;

}