/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.model.impl;

import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.StringUtil;

/**
 * @author Marco Leo
 */
public class ObjectViewFilterColumnImpl extends ObjectViewFilterColumnBaseImpl {

	@Override
	public JSONArray getJSONArray() throws JSONException {
		if (StringUtil.equals(getFilterType(), StringPool.BLANK)) {
			return null;
		}

		JSONObject jsonObject = JSONFactoryUtil.createJSONObject(getJSON());

		return jsonObject.getJSONArray(getFilterType());
	}

}