/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.model.impl;

import com.liferay.object.model.ObjectLayoutTab;
import com.liferay.object.service.ObjectLayoutTabLocalServiceUtil;

/**
 * The extended model base implementation for the ObjectLayoutTab service. Represents a row in the &quot;ObjectLayoutTab&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectLayoutTabImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectLayoutTabImpl
 * @see ObjectLayoutTab
 * @generated
 */
public abstract class ObjectLayoutTabBaseImpl
	extends ObjectLayoutTabModelImpl implements ObjectLayoutTab {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object layout tab model instance should use the <code>ObjectLayoutTab</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			ObjectLayoutTabLocalServiceUtil.addObjectLayoutTab(this);
		}
		else {
			ObjectLayoutTabLocalServiceUtil.updateObjectLayoutTab(this);
		}
	}

}