/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.upgrade.v5_2_0;

import com.liferay.object.constants.ObjectRelationshipConstants;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.dao.db.IndexMetadata;
import com.liferay.portal.kernel.dao.db.IndexMetadataFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;

/**
 * @author Mateus Santana
 */
public class ObjectRelationshipUpgradeProcess extends UpgradeProcess {

	@Override
	protected void doUpgrade() throws Exception {
		DBInspector dbInspector = new DBInspector(connection);

		processConcurrently(
			StringBundler.concat(
				"select ObjectDefinition.pkObjectFieldDBColumnName, ",
				"ObjectRelationship.dbTableName from ObjectDefinition inner ",
				"join ObjectRelationship on ObjectRelationship.type_ = '",
				ObjectRelationshipConstants.TYPE_MANY_TO_MANY, "' where ",
				"ObjectDefinition.objectDefinitionId = ",
				"ObjectRelationship.objectDefinitionId1"),
			resultSet -> new Object[] {
				resultSet.getString(1), resultSet.getString(2)
			},
			values -> _createIndex(
				String.valueOf(values[0]), dbInspector,
				String.valueOf(values[1])),
			null);
	}

	private void _createIndex(
			String columnName, DBInspector dbInspector, String tableName)
		throws Exception {

		IndexMetadata indexMetadata =
			IndexMetadataFactoryUtil.createIndexMetadata(
				false, tableName, columnName);

		if (!dbInspector.hasIndex(tableName, indexMetadata.getIndexName())) {
			runSQL(indexMetadata.getCreateSQL(null));
		}
	}

}