/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.upgrade.v3_9_0;

import com.liferay.object.constants.ObjectLayoutBoxConstants;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;

/**
 * @author Selton Guedes
 */
public class ObjectLayoutBoxUpgradeProcess extends UpgradeProcess {

	@Override
	protected void doUpgrade() throws Exception {
		if (hasColumn("ObjectLayoutBox", "type_")) {
			return;
		}

		alterTableAddColumn("ObjectLayoutBox", "type_", "VARCHAR(75) null");

		runSQL(
			"update ObjectLayoutBox set type_ = '" +
				ObjectLayoutBoxConstants.TYPE_REGULAR + "'");
	}

}