/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.uad.util;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.user.associated.data.util.UADDynamicQueryUtil;

/**
 * @author Carolina Barbosa
 */
public class ObjectEntryUADUtil {

	public static ActionableDynamicQuery addActionableDynamicQueryCriteria(
		ActionableDynamicQuery actionableDynamicQuery,
		long objectDefinitionId) {

		actionableDynamicQuery.setAddCriteriaMethod(
			dynamicQuery -> addDynamicQueryCriteria(
				dynamicQuery, objectDefinitionId));

		return actionableDynamicQuery;
	}

	public static ActionableDynamicQuery addActionableDynamicQueryCriteria(
		ActionableDynamicQuery actionableDynamicQuery,
		String[] userIdFieldNames, long userId) {

		ActionableDynamicQuery.AddCriteriaMethod addCriteriaMethod =
			actionableDynamicQuery.getAddCriteriaMethod();

		actionableDynamicQuery.setAddCriteriaMethod(
			dynamicQuery -> {
				addCriteriaMethod.addCriteria(dynamicQuery);

				UADDynamicQueryUtil.addDynamicQueryCriteria(
					dynamicQuery, userIdFieldNames, userId);
			});

		return actionableDynamicQuery;
	}

	public static DynamicQuery addDynamicQueryCriteria(
		DynamicQuery dynamicQuery, long objectDefinitionId) {

		dynamicQuery.add(
			RestrictionsFactoryUtil.eq(
				"objectDefinitionId", objectDefinitionId));

		return dynamicQuery;
	}

}